<?php namespace Phpcmf\Controllers\Admin;

// 物流公司
class Delivery_corp extends \Phpcmf\Table
{

    private $my_field;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 支持附表存储
        $this->is_data = 0;
        $this->tpl_prefix = 'delivery_corp_';
        $this->my_field = array(
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('名称'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 200,
                    ),
                    'validate' => array(
                        'required' => 1,
                    )
                )
            ),
            'code' => array(
                'ismain' => 1,
                'name' => dr_lang('物流代码'),
                'fieldname' => 'code',
                'fieldtype'	=> 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 200,
                    ),
                    'validate' => array(
                        'required' => 1,
                    )
                )
            ),
            'url' => array(
                'ismain' => 1,
                'name' => dr_lang('运单查询地址'),
                'fieldname' => 'url',
                'fieldtype'	=> 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => '80%',
                    ),
                    'validate' => array(
                        'required' => 1,
                    )
                )
            ),
        );
        // 表单显示名称
        $this->name = dr_lang('物流公司');
        // 初始化数据表
        $this->_init([
            'table' => 'mall_delivery_corp',
            'field' => $this->my_field,
            'order_by' => 'displayorder asc,id desc',
        ]);
        \Phpcmf\Service::V()->assign([
            'field' => $this->my_field,
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    '物流公司' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-truck'],
                    '添加' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/add', 'fa fa-plus'],
                    '修改' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ]
            ),
        ]);
    }

    // 后台查看表单列表
    public function index() {
        list($tpl) = $this->_List();
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台添加表单内容
    public function add() {
        list($tpl) = $this->_Post(0);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 排序
    public function displayorder_edit() {

        // 查询数据
        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $row =\Phpcmf\Service::M()->table($this->init['table'])->get($id);
        !$row && $this->_json(0, dr_lang('数据不存在'));

        $value = (int)\Phpcmf\Service::L('Input')->get('value');
        $rt =\Phpcmf\Service::M()->table($this->init['table'])->save($id, 'displayorder', $value);
        !$rt['code'] && $this->_json(0, $rt['msg']);

        \Phpcmf\Service::L('Input')->system_log('修改物流公司('.$row['name'].')的排序值为：'.$value);
        $this->_json(1, dr_lang('操作成功'));
    }

    // 隐藏或者启用
    public function hidden_edit() {

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $row =\Phpcmf\Service::M()->table($this->init['table'])->get($id);
        !$row && $this->_json(0, dr_lang('数据不存在'));

        $v = $row['disabled'] ? 0 : 1;
       \Phpcmf\Service::M()->table($this->init['table'])->update($id, ['disabled' => $v]);

        exit($this->_json(1, dr_lang($v ? '被禁用' : '被启用'), ['value' => $v]));
    }

    // 后台修改表单内容
    public function edit() {
        list($tpl) = $this->_Post(intval(\Phpcmf\Service::L('Input')->get('id')));
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台删除表单内容
    public function del() {
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            null,
           \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

}
