<?php namespace Phpcmf\Controllers\Admin;

class Goods extends \Phpcmf\Common
{

    public function __construct(...$params) {
        parent::__construct(...$params);
        \Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('Auth')->_admin_menu(
            [
                '新品页面' => ['mall/goods/index', 'fa fa-cog'],
            ]
        ));
    }

    public function index() {

        $page = intval(\Phpcmf\Service::L('Input')->get('page'));
        $data = \Phpcmf\Service::M('Mall', 'mall')->get_config('goods', SITE_ID);
        $field = [
            'banner' => [
                'ismain' => 1,
                'fieldtype' => 'Files',
                'fieldname' => 'banner',
                'setting' => ['option' => ['ext' => 'jpg,gif,png,jpeg', 'size' => 10, 'count' => 10]]
            ]
        ];

        if (IS_AJAX_POST) {
            $post = \Phpcmf\Service::L('Input')->post('data');
            \Phpcmf\Service::M('Mall', 'mall')->save_config('goods', SITE_ID, $post);
            // 附件归档
            if (SYS_ATTACHMENT_DB) {
                list($post, $return, $attach) = \Phpcmf\Service::L('form')->validation($post, null, $field);
                $attach && \Phpcmf\Service::M('Attachment')->handle($this->member['id'], \Phpcmf\Service::M()->dbprefix('mall'), $attach);
            }
            $this->_json(1, dr_lang('操作成功'));
        }

        \Phpcmf\Service::V()->assign([
            'page' => $page,
            'data' => $data,
            'form' => dr_form_hidden(['page' => $page]),
            'myfield' => dr_fieldform($field['banner'], $data['banner']),
        ]);
        \Phpcmf\Service::V()->display('goods_index.html');
    }


}
