<?php namespace Phpcmf\Controllers\Admin;

class Order extends \Phpcmf\Common
{

    public function __construct(...$params) {
        parent::__construct(...$params);
        \Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('Auth')->_admin_menu(
            [
                '订单设置' => ['mall/order/index', 'fa fa-cog'],
            ]
        ));
    }

    public function index() {

        $page = intval(\Phpcmf\Service::L('Input')->get('page'));
        $data =\Phpcmf\Service::M('Mall', 'mall')->get_config('order', SITE_ID);

        if (IS_AJAX_POST) {
            \Phpcmf\Service::M('Mall', 'mall')->save_config('order', SITE_ID, \Phpcmf\Service::L('Input')->post('data'));
            $this->_json(1, dr_lang('操作成功'));
        }

        \Phpcmf\Service::V()->assign([
            'data' => $data,
            'page' => $page,
            'form' => dr_form_hidden(['page' => $page]),
        ]);
        \Phpcmf\Service::V()->display('order_index.html');
    }


}
