<?php namespace Phpcmf\Controllers\Admin;

class Seo extends \Phpcmf\Common
{
    public function index() {

        $page = intval(\Phpcmf\Service::L('Input')->get('page'));
        $data = \Phpcmf\Service::M('mall', 'mall')->get_config('seo', SITE_ID);

        if (IS_AJAX_POST) {
            \Phpcmf\Service::M('mall', 'mall')->save_config('seo', SITE_ID, \Phpcmf\Service::L('Input')->post('data'));
            $this->_json(1, dr_lang('操作成功'));
        }

        \Phpcmf\Service::V()->assign([
            'data' => $data,
            'page' => $page,
            'form' => dr_form_hidden(['page' => $page]),
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    '店铺规则' => ['mall/seo/index', 'fa fa-cog'],
                ]
            ),
            'mall_page' => [
                'show' => [
                    'name' => dr_lang('店铺SEO'),
                    'icon' => 'fa fa-home',
                ],
                'goods' => [
                    'name' => dr_lang('商品SEO'),
                    'icon' => 'fa fa-square',
                ],
                'comment' => [
                    'name' => dr_lang('评论SEO'),
                    'icon' => 'fa fa-comments',
                ],
                'about' => [
                    'name' => dr_lang('介绍SEO'),
                    'icon' => 'fa fa-phone',
                ],
            ]
        ]);
        \Phpcmf\Service::V()->display('seo_index.html');
    }


}
