<?php namespace Phpcmf\Controllers;

class Comment extends \Phpcmf\Home\Module
{

    public function index() {

        define('MALL_SHOW_SEO', 1);

        $this->_module_init();
        $data = $this->_Show(
            (int)\Phpcmf\Service::L('input')->get('id'),
            [
                'field' => dr_safe_replace(\Phpcmf\Service::L('input')->get('field')),
                'value' => dr_safe_replace(\Phpcmf\Service::L('input')->get('value')),
            ],
            max(1, (int)\Phpcmf\Service::L('input')->get('page')),
            1
        );

        // 排序模式
        $type = (int)str_replace('#', '', \Phpcmf\Service::L('Input')->get('type'));
        $order = 'inputtime desc';
        switch ($type) {
            case 1:
                $order = 'inputtime asc';
                break;
            case 2:
                $order = 'support asc';
                break;
            case 3:
                $order = 'avgsort desc';
                break;
            case 4:
                $order = 'image desc';
                break;
            default:
                $_GET['order'] && $order = strtolower(dr_get_order_string($_GET['order'], $order));
                break;
        }

        // 判断排序字段是否可用
        !in_array(trim(str_replace([' asc', ' desc'], '', $order)), \Phpcmf\Service::L('cache')->get('table-'.SITE_ID, \Phpcmf\Service::M()->dbprefix($this->content_model->mytable.'_comment'))) && $order = 'inputtime desc';

        // 获取评论数据
        $comment = $data['comment'];
        !$comment && exit($this->_msg(0, dr_lang('内容【id#%s】评论索引数据读取失败',  $this->cid)));

        $page = max(1, (int)\Phpcmf\Service::L('Input')->get('page'));
        $total = (int)\Phpcmf\Service::L('Input')->get('total');
        $pagesize = max(10, (int)$this->module['comment']['pagesize']);

        // 查询数据
        list($list, $total) = $this->content_model->get_comment_result( $data['id'], $order, $page, $pagesize, $total);

        // ajax动态无刷新调用
        $js = 'dr_ajax_module_comment_'. $data['id'];

        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('seo')->mall('comment', $data));
        \Phpcmf\Service::V()->assign([
            'js' => $js,
            'type' => $type,
            'page' => $page,
            'list' => $list,
            'comment' => $comment,
            'commnets' => $total,
            'is_reply' => 0,
            'ajax_pages' => $this->_get_pages('javascript:'.$js.'('.$type.', {page})', $total, $pagesize),
        ]);

        if (empty($_GET['callback'])) {
            \Phpcmf\Service::V()->display('comment.html');
        } else {
            ob_start();
            \Phpcmf\Service::V()->display('comment_ajax.html');
            $html = ob_get_contents();
            ob_clean();
            $this->_jsonp(1, $html);
        }
    }

    protected function _call_show($data) {
        $data['comment'] = $this->content_model->get_comment_index( $data['id'], $data['catid']);
        $data['mall_page'] = \Phpcmf\Service::M('mall', 'mall')->get_mall_page($data);
        return $data;
    }

    /**
     * 评论ajax分页 方便二次开发和重写
     */
    protected function _get_pages($url, $total, $pagesize) {

        $config = [];

        $config['base_url'] = $url;
        $config['per_page'] = $pagesize;
        $config['total_rows'] = $total;
        $config['use_page_numbers'] = TRUE;
        $config['query_string_segment'] = 'page';

        // 分页要支持移动端
        if (is_file(WEBPATH.'config/page_ajax.php')) {
            $page = require WEBPATH.'config/page_ajax.php';
            $config = dr_array22array($config, $page);
        } else {
            $config['next_link'] = '>';
            $config['prev_link'] = '<';
            $config['last_link'] = '>|';
            $config['first_link'] = '|<';
            $config['cur_tag_open'] = '<a class="ds-current">';
            $config['cur_tag_close'] = '</a>';
        }

        return \Phpcmf\Service::L('Page')->initialize($config)->create_links();
    }
}
