<?php namespace Phpcmf\Controllers\Member;

class Api extends \Phpcmf\Common
{

    // 选择单个商品
    public function goods_one() {

        // 登陆判断
        !$this->uid && $this->_json(0, dr_lang('会话超时，请重新登录'));

        $cid = \Phpcmf\Service::L('Input')->post('cid');
        !$cid && $this->_json(0, dr_lang('没有选择项'));

        list($id, $sku) = explode('-', $cid);

        $rt = \Phpcmf\Service::M('Mall', 'mall')->get_goods_price_info($id, $sku);
        !$rt['code'] && $this->_json(0, $rt['msg']);

        $this->_json(1, dr_lang('操作成功'), $rt['data']);
    }

    // 选择多个商品
    public function goods_more() {

        // 登陆判断
        !$this->uid && $this->_json(0, dr_lang('会话超时，请重新登录'));

        $ids = \Phpcmf\Service::L('Input')->get_post_ids();
        !$ids && $this->_json(0, dr_lang('没有选择项'));

        $data = \Phpcmf\Service::M()->table(SITE_ID.'_goods')->where('uid', $this->uid)->where_in('id', $ids)->where('is_sale', 1)->getAll();
        !$data && $this->_json(0, dr_lang('无可用商品'));

        $this->_json(1, dr_lang('操作成功'), ['html' => dr_mall_goods_html($data)]);
    }

    // 用于选择商品
    public function goods() {

        // 登陆判断
        !$this->uid && $this->_json(0, dr_lang('会话超时，请重新登录'));

        // 模块缓存判断
        $module = $this->get_cache('module-'.SITE_ID.'-goods');
        !$module && $this->_json(0, dr_lang('模块（%s）不存在', 'goods'));

        $module['field']['id'] = array(
            'name' => 'Id',
            'ismain' => 1,
            'fieldtype' => 'Text',
            'fieldname' => 'id',
        );

        $data = $_GET;
        $builder = \Phpcmf\Service::M()->db->table(SITE_ID.'_goods')->where('uid', $this->uid)->where('is_sale', 1);

        if ($data['search']) {
            $catid = (int)$data['catid'];
            $catid && $builder->whereIn('catid', $module['category'][$catid]['catids']);
            if (isset($data['keyword']) && $data['keyword']
                && $data['field'] && isset($module['field'][$data['field']])) {
                if ($data['field'] == 'id') {
                    // id搜索
                    $id = array();
                    $ids = explode(',', $data['keyword']);
                    foreach ($ids as $i) {
                        $id[] = (int)$i;
                    }
                    $builder->whereIn('id', $id);
                } else {
                    // 其他模糊搜索
                    $builder->like($data['field'], urldecode($data['keyword']));
                }
            }
        }

        sort($module['field']);
        $more = intval($_GET['more']);
        $list = $builder->limit(50)->orderBy('updatetime DESC')->get()->getResultArray();

        \Phpcmf\Service::V()->assign(array(
            'more' => $more,
            'list' => $list,
            'param' => $data,
            'field' => $module['field'],
            'select' => \Phpcmf\Service::L('tree')->select_category(
                $module['category'],
                $data['catid'],
                'name="catid"',
                '--'
            ),
            'category' => $module['category'],
            'search' => dr_form_search_hidden(['search' => 1]),
        ));
        \Phpcmf\Service::V()->display($more ? 'api_goods_more.html' : 'api_goods.html');
        exit;
    }



}
