<?php namespace Phpcmf\Controllers\Member;

// 商品折扣
class Promotion extends \Phpcmf\Table
{

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->name = dr_lang('商品折扣');
        $this->is_data = 0;
        $this->tpl_prefix = 'promotion_';
        $field = [
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('活动'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'description' => array(
                'ismain' => 1,
                'name' => dr_lang('描述'),
                'fieldname' => 'description',
                'fieldtype' => 'Text',
            ),
        ];
        $this->_init([
            'table' => SITE_ID.'_goods_promotion',
            'field' => $field,
            'where_list' => 'uid='.$this->uid,
            'date_field' => 'inputtime',
            'show_field' => 'title',
            'order_by' => 'inputtime desc',
        ]);
        $this->ptype = [
            '1' => '折扣',
            '2' => '减价',
            '3' => '固定价',
            '4' => '返现金',
        ];
        \Phpcmf\Service::V()->assign([
            'module_memu' => [
                'index' => [
                    'name' => dr_lang('商品折扣'),
                    'icon' => 'fa fa-table',
                    'url' => dr_member_url('mall/promotion/index'),
                ],
                'add' => [
                    'name' => dr_lang('添加'),
                    'icon' => 'fa fa-plus',
                    'url' => dr_member_url('mall/promotion/add'),
                ],
            ],
            'mcid' => \Phpcmf\Service::L('router')->method,
            'field' => $field,
            'ptype' => $this->ptype,
        ]);
    }

    // 后台查看列表
    public function index() {
        $this->_List();
        \Phpcmf\Service::V()->display('promotion_index.html');
    }

    // 后台添加内容
    public function add() {

        list($tpl) = $this->_Post(0);

        \Phpcmf\Service::V()->assign([
            'type' => 0,
            'stime' => SYS_TIME,
            'etime' => SYS_TIME + 3600 * 24,
            'groups' => [],
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台修改内容
    public function edit() {

        list($tpl, $data) = $this->_Post(intval(\Phpcmf\Service::L('Input')->get('id')));
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台查看内容
    public function show() {

        list($tpl, $data) = $this->_Show(intval(\Phpcmf\Service::L('Input')->get('id')));

        $this->_init([
            'table' => 'member_paylog',
            'order_by' => 'inputtime desc',
            'where_list' => '`mid` = "gathering-'.$data['id'].'-'.$this->init['table'].'"',
            'date_field' => 'inputtime',
        ]);

        $this->_List();

        \Phpcmf\Service::V()->assign([
            'data' => $data,
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台删除表单内容
    public function del() {
        // 删除条件
        $this->delete_where = 'uid='.$this->uid;
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            null,
           \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

    /**
     * 获取内容
     * $id      内容id,新增为0
     * */
    protected function _Data($id = 0) {

        $row = parent::_Data($id);
        if ($row) {
            $data = \Phpcmf\Service::M()->table(SITE_ID.'_goods')->where('`id` IN (select cid from `'.\Phpcmf\Service::M()->dbprefix(SITE_ID.'_goods_promotion_item').'` where pid='.$id.')')->getAll();
            $row['goods_html'] = dr_mall_goods_html($data);
            $row['groups'] = dr_string2array($row['member']);
        }

        return $row;
    }

    // 格式化保存数据
    protected function _Format_Data($sid, $data, $old) {

        $data = \Phpcmf\Service::L('Input')->post('data');
        $value = \Phpcmf\Service::L('Input')->post('value');
        $goods = \Phpcmf\Service::L('Input')->post('goods');
        !$goods && $this->_json(0, dr_lang('没有选择商品'));
        !$data['title'] && $this->_json(0, dr_lang('活动主题必须填写'));
        !$data['type'] && $this->_json(0, dr_lang('促销类型必须选择'));

        $save = [
            'type' => (int)$data['type'],
            'title' => $data['title'],
            'description' => (string)$data['description'],
            'value' => (int)$value[$data['type']],
            'member' => '',
            'stime' => (int)strtotime($data['stime']),
            'etime' => (int)strtotime($data['etime']),
        ];
        $save['uid'] = $this->member['id'];
        $save['username'] = $this->member['username'];
        $save['stime'] > $save['etime'] && $this->_json(0, dr_lang('开始时间不能超过结束时间'));
        if (!$sid) {
            $save['nums'] = 0;
            $save['buy_num'] = 0;
            $save['inputtime'] = SYS_TIME;
        }

        return $save;
    }

    // 保存
    protected function _Save($id = 0, $data = [], $old = [], $func = null, $func2 = null) {
        return parent::_Save($id, $data, $old, null, function($id, $data, $old){
            $ids = array_unique(\Phpcmf\Service::L('Input')->post('goods'));
            \Phpcmf\Service::M()->table(SITE_ID.'_goods_promotion_item')->where('pid', $id)->delete();
            $c = 0;
            $goods = \Phpcmf\Service::M()->table(SITE_ID.'_goods')->where('uid', $this->uid)->where_in('id', $ids)->where('is_sale', 1)->getAll();
            foreach ($goods as $t) {
                $c++;
                \Phpcmf\Service::M()->table(SITE_ID.'_goods_promotion_item')->insert([
                    'pid' => $id,
                    'cid' => $t['id'],
                ]);
            }
            \Phpcmf\Service::M()->table(SITE_ID.'_goods_promotion')->update($id, [
                'nums' => $c,
            ]);
            return dr_return_data(1, 'ok');
        });
    }


}
