<?php namespace Phpcmf\Controllers\Member;

// 运费策略设置
class Shipping extends \Phpcmf\Table
{

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->name = dr_lang('运费策略');
        $this->is_data = 0;
        $this->tpl_prefix = 'shipping_';
        $this->_init([
            'table' => 'mall_shipping',
            'order_by' => 'id asc',
            'where_list' => 'uid='.$this->uid,
        ]);
        \Phpcmf\Service::V()->assign([
            'valuation_type' => \Phpcmf\Service::M('Mall', 'mall')->get_valuation(),
            'module_memu' => [
                'index' => [
                    'name' => dr_lang('运费策略'),
                    'icon' => 'fa fa-table',
                    'url' => dr_member_url('mall/shipping/index'),
                ],
                'add' => [
                    'name' => dr_lang('添加'),
                    'icon' => 'fa fa-plus',
                    'url' => dr_member_url('mall/shipping/add'),
                ],
            ],
            'mcid' => \Phpcmf\Service::L('router')->method,
        ]);
    }

    // 后台查看表单列表
    public function index() {
        $this->_List([], -1);
        \Phpcmf\Service::V()->display('shipping_index.html');
    }

    // 后台添加表单内容
    public function add() {

        list($tpl) = $this->_Post(0);

        $freight_id = $free_id = 0;
        \Phpcmf\Service::V()->assign([
            'free_id' => $free_id,
            'valuation' => 1,
            'freight_id' => $freight_id,
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台修改表单内容
    public function edit() {

        list($tpl, $data) = $this->_Post(intval(\Phpcmf\Service::L('Input')->get('id')));

        \Phpcmf\Service::V()->assign([
            'free_id' => count($data['free']),
            'freight_id' => count($data['freight']),
            'mcid' => 'index',
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 选择城市
    public function city_index() {

        if (IS_AJAX_POST) {
            $city = (int)$_POST['data']['city'];
            !$city && $this->_json(0, dr_lang('全国地区'));
            $this->_json($city, dr_linkagepos(FC_ADDRESS_CITY, $city, ' » '));
            exit;
        }

        \Phpcmf\Service::V()->assign('city', dr_fieldform([
            'fieldname' => 'city',
            'fieldtype' => 'Linkage',
            'setting' => [ 'option' => [ 'linkage' => FC_ADDRESS_CITY, ], ]
        ]));
        \Phpcmf\Service::V()->display('shipping_city.html');exit;
    }

    // 后台删除表单内容
    public function del() {
        // 删除条件
        $this->delete_where = 'uid='.$this->uid;
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            null,
           \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

    /**
     * 获取内容
     * $id      内容id,新增为0
     * */
    protected function _Data($id = 0) {

        $row = parent::_Data($id);
        if ($row) {
            $row['freight'] = dr_string2array($row['freight']);
            $row['free'] = dr_string2array($row['free']);
        }

        return $row;
    }

    // 格式化保存数据
    protected function _Format_Data($id, $data, $old) {

        $data['freight'] = dr_array2string($data['freight']);
        $data['free'] = dr_array2string($data['free']);

        $data['uid'] = $this->member['id'];
        $data['username'] = $this->member['username'];

        return $data;
    }


}
