<?php namespace Phpcmf\Model;

class Address extends \Phpcmf\Model
{

    // 我的收货地址数据
    public function my_address() {

        if (!$this->uid) {
            return [];
        }

        $data = $this->table('mall_address')->where('uid', $this->uid)->getAll();
        if (!$data) {
            return [];
        }

        $value = [];
        foreach ($data as $t) {
            $value[$t['id']] = dr_string2array($t['value']);
            $value[$t['id']]['id'] = $t['id'];
            $value[$t['id']]['default'] = $t['default'];
        }

        return $value;
    }

    // 收货地址数据
    public function info($id) {

        if (!$id) {
            return [];
        }

        $data = $this->table('mall_address')->where('id', $id)->where('uid', $this->uid)->getRow();
        if (!$data) {
            return [];
        }

        $value = dr_string2array($data['value']);
        $value['id'] = $id;
        $value['default'] = $data['default'];

        return $value;
    }

    // 保存地址
    public function save_info($id, $data) {

        $data['default'] && $this->db->table('mall_address')->where('uid', $this->uid)->update(['default' => 0]);

        if (!$id) {
            // add
            $rt = $this->table('mall_address')->insert([
                'uid' => $this->uid,
                'value' => dr_array2string($data),
                'default' => (int)$data['default'],
            ]);
            $data['id'] = $data['id'];
            $rt['data'] = $data;
        } else {
            // edit
            $rt = $this->table('mall_address')->update($id, [
                'value' => dr_array2string($data),
                'default' => (int)$data['default'],
            ]);
            $data['id'] = $id;
            $rt['data'] = $data;
        }

        return $rt;
    }

    public function delete_address($ids) {
        if (!$ids) {
            return;
        }
        $this->db->table('mall_address')->where('uid', $this->uid)->whereIn('id', $ids)->delete();
    }
    
}