<?php namespace Phpcmf\Model;

class Mall extends \Phpcmf\Model
{

    // 获取配置信息
    public function get_config($name, $siteid = 0) {

        $data = $this->db->table('mall_config')->where('name', $name)->get()->getRowArray();
        if ($data) {
            $data = dr_string2array($data['value']);
            return $siteid ? $data[$siteid] : $data;
        } else {
            $this->db->table('mall_config')->insert([
                'name' => $name,
                'value' => '',
            ]);
            return [];
        }
    }

    // 存储配置信息
    public function save_config($name, $siteid = 0, $post) {

        if ($siteid) {
            $data = $this->db->table('mall_config')->where('name', $name)->get()->getRowArray();
            $value = dr_string2array($data['value']);
            $value[$siteid] = $post;
        } else {
            $value = $post;
        }

        $this->db->table('mall_config')->where('name', $name)->update([
            'value' => dr_array2string($value)
        ]);
    }

    // 商铺子页面
    public function get_mall_page($data) {
        return [
            'show' => [
                'name' => dr_lang('店铺首页'),
                'url' => $data['url'],
                'icon' => 'fa fa-home',
            ],
            'goods' => [
                'name' => dr_lang('全部商品'),
                'url' => \Phpcmf\Service::L('router')->mall_url('goods', $data),
                'icon' => 'fa fa-square',
            ],
            'comment' => [
                'name' => dr_lang('信用评论'),
                'url' => \Phpcmf\Service::L('router')->mall_url('comment', $data),
                'icon' => 'fa fa-comments',
            ],
            'about' => [
                'name' => dr_lang('店铺介绍'),
                'url' => \Phpcmf\Service::L('router')->mall_url('about', $data),
                'icon' => 'fa fa-phone',
            ],
        ];
    }

    // 策略类型
    public function get_valuation() {
        return [
            1 => dr_lang('按数量'),
            2 => dr_lang('按重量'),
            3 => dr_lang('按体积'),
        ];
    }

    // 策略类型单位
    public function get_valuation_value() {
        return [
            1 => dr_lang('件'),
            2 => dr_lang('千克'),
            3 => dr_lang('立方'),
        ];
    }

    // 选择商品之后 获取商品价格信息
    public function get_goods_price_info($id, $sku = 0) {

        $data = $this->table(SITE_ID.'_goods')->get($id);
        if (!$data) {
            return dr_return_data(0, dr_lang('商品不存在'));
        } elseif (!$data['is_sale']) {
            return dr_return_data(0, dr_lang('商品已经下架'));
        }

        $rt = [
            'id' => $data['id'],
            'cid' => $id.'-'.$sku,
            'title' => $data['title'],
            'url' => $data['url'],
        ];

        $price_sku = dr_string2array($data['price_sku']);
        if ($price_sku) {
            if (!$price_sku['value'][$sku]) {
                return dr_return_data(0, dr_lang('商品规格不存在'));
            }
            $rt['sku'] = dr_sku_name($sku, $price_sku);
            $rt['price'] = $price_sku['value'][$sku]['price'];
            $rt['quantity'] = $price_sku['value'][$sku]['quantity'];
        } else {
            $rt['sku'] = '';
            $rt['price'] = $data['price'];
            $rt['quantity'] = $data['price_quantity'];
        }

        return dr_return_data(1, 'ok', $rt);
    }


    // 缓存
    public function cache($siteid = SITE_ID) {

        $data = $this->table('mall_config')->getAll();
        $cache = [];
        if ($data) {
            foreach ($data as $t) {
                $value = dr_string2array($t['value']);
                if ($t['name'] == 'config' && $value) {
                    foreach ($value as $i => $a) {
                        $cache[$i] = $a;
                    }
                } else {
                    $cache [$t['name']] = $value;
                }
                $t['name'] == 'order' && $cache[$t['name']] = $value[$siteid];
            }
        }

        $data = $this->table('mall_shipping')->getAll();
        $cache['shipping'] = [];
        if ($data) {
            foreach ($data as $t) {
                $t['free'] = dr_string2array($t['free']);
                $t['freight'] = dr_string2array($t['freight']);
                $cache['shipping'][$t['id']] = $t;
            }
        }

        \Phpcmf\Service::L('cache')->set_file('mall-'.$siteid, $cache);
        return;
    }

}