<?php namespace Phpcmf\Controllers;

class Address extends \Phpcmf\Common {

    // 添加或修改收货地址
	public function index() {

        !$this->uid && exit($this->_json(0, dr_lang('登录之后在操作')));

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $data = \Phpcmf\Service::M('Address', 'mall')->info($id);

        if (IS_POST) {
            $post = \Phpcmf\Service::L('Input')->post('data');
            if (!$post['name']) {
                $this->_json(0, dr_lang('姓名不能为空'), ['field' => 'name']);
            } elseif (!$post['city']) {
                $this->_json(0, dr_lang('请选择一个城市'), ['field' => 'city']);
            } elseif (!$post['address']) {
                $this->_json(0, dr_lang('详细地址不能为空'), ['field' => 'address']);
            } elseif (!$post['phone']) {
                $this->_json(0, dr_lang('手机号码不能为空'), ['field' => 'phone']);
            }
            $rt = \Phpcmf\Service::M('Address', 'mall')->save_info($data['id'], $post);
            if (!$rt['code']) {
                $this->_json(0, $rt['msg']);
            } else {
                $this->_json(1, dr_lang('操作成功'), $rt['data']);
            }
        }

        \Phpcmf\Service::V()->assign([
            'city' => dr_fieldform(array(
                'ismain' => 1,
                'name' => dr_lang('城市'),
                'fieldname' => 'city',
                'fieldtype' => 'Linkage',
                'setting' => array(
                    'option' => array(
                        'linkage' => FC_ADDRESS_CITY,
                    ),
                )
            ), (int)$data['city']),
            'address' => $data,
        ]);
        \Phpcmf\Service::V()->display('address.html');
        exit;
    }


}
