<?php namespace Phpcmf\Controllers\Admin;

class Home extends \Phpcmf\Table {

    public function __construct(...$params)
    {
        parent::__construct(...$params);


        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    '订单管理' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/'.(\Phpcmf\Service::L('Router')->method == 'edit' ? 'index' : \Phpcmf\Service::L('Router')->method), 'fa fa-shopping-cart'],
                    '详情' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ]
            ),
        ]);
    }


    public function edit() {

        // 表单显示名称
        $this->name = dr_lang('订单');
        $this->is_list_data = 0;

        // 初始化数据表
        $this->_init(['table' => SITE_ID.'_order']);

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_admin_msg(0, dr_lang('订单不存在'));

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'goods' => \Phpcmf\Service::M('Order', 'order')->goods($id),
            'comment' => \Phpcmf\Service::M('Order', 'order')->comment($data['mid'], $id),
            'review' => $this->get_cache('module-'.SITE_ID.'-goods', 'comment', 'review'),
            'op_log' => \Phpcmf\Service::M('Order', 'order')->log($id),
            'op_url' => \Phpcmf\Service::L('Router')->url(APP_DIR.'/home/add', ['id' => $id]),
            'my_money' => max(0, $data['money'] - $data['income_money'] - $data['give_money']),
        ]);
        \Phpcmf\Service::V()->display('order_show.html');
    }


    private function _list_data() {

        // 模板前缀(避免混淆)
        $this->my_field = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单编号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'id' => array(
                'ismain' => 1,
                'name' => dr_lang('订单ID'),
                'fieldname' => 'id',
                'fieldtype' => 'Text',
            ),
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('收货人'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
            ),
            'phone' => array(
                'ismain' => 1,
                'name' => dr_lang('电话'),
                'fieldname' => 'phone',
                'fieldtype' => 'Text',
            ),
            'email' => array(
                'ismain' => 1,
                'name' => dr_lang('邮箱'),
                'fieldname' => 'email',
                'fieldtype' => 'Text',
            ),
            'address' => array(
                'ismain' => 1,
                'name' => dr_lang('地址'),
                'fieldname' => 'address',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('备注'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('账户'),
                'fieldname' => 'username',
                'fieldtype' => 'Text',
            ),
            'uid' => array(
                'ismain' => 1,
                'name' => dr_lang('uid'),
                'fieldname' => 'uid',
                'fieldtype' => 'Text',
            ),
        );

        // 表单显示名称
        $this->name = dr_lang('订单');


        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order',
            'field' => $this->my_field,
            'sys_field' => [],
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
        ]);
        list($a, $data) = $this->_List();

        $list = [];
        foreach ($data['list'] as $t) {
            $t['goods'] = \Phpcmf\Service::M('Order', 'order')->goods($t['id']);
            $list[] = $t;
        }

        \Phpcmf\Service::V()->assign([
            'list' => $list,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('order_list.html');
    }

    public function index() {
        $this->_list_data();
    }



}
