<?php namespace Phpcmf\Controllers\Admin;

// 订单折扣
class Promotion extends \Phpcmf\Table
{

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->name = dr_lang('订单折扣');
        $this->is_data = 0;
        $this->tpl_prefix = 'promotion_';
        $field = [
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('主题'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'description' => array(
                'ismain' => 1,
                'name' => dr_lang('描述'),
                'fieldname' => 'description',
                'fieldtype' => 'Text',
            ),
        ];
        $this->_init([
            'table' => SITE_ID.'_order_promotion',
            'field' => $field,
            'date_field' => 'inputtime',
            'show_field' => 'title',
            'order_by' => 'inputtime desc',
        ]);
        $this->ptype = [
            '1' => '折扣',
            '2' => '减价',
            '4' => '返现金',
            '5' => '返金币',
        ];
        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    $this->name => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-opencart'],
                    '添加' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/add', 'fa fa-plus'],
                    '修改' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                    'help' => [245],
                ]
            ),
            'field' => $field,
            'ptype' => $this->ptype,
        ]);
    }

    // 后台查看列表
    public function index() {
        list($tpl) = $this->_List();
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台添加内容
    public function add() {

        list($tpl) = $this->_Post(0);

        \Phpcmf\Service::V()->assign([
            'type' => 0,
            'stime' => SYS_TIME,
            'etime' => SYS_TIME + 3600 * 24,
            'groups' => [],
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台修改内容
    public function edit() {

        list($tpl, $data) = $this->_Post(intval(\Phpcmf\Service::L('Input')->get('id')));
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台查看内容
    public function show() {

        list($tpl, $data) = $this->_Show(intval(\Phpcmf\Service::L('Input')->get('id')));

        $this->_init([
            'table' => 'member_paylog',
            'order_by' => 'inputtime desc',
            'where_list' => '`mid` = "gathering-'.$data['id'].'-'.$this->init['table'].'"',
            'date_field' => 'inputtime',
        ]);

        $this->_List();

        \Phpcmf\Service::V()->assign([
            'data' => $data,
        ]);
        \Phpcmf\Service::V()->display($tpl);
    }

    // 后台删除表单内容
    public function del() {
        $this->_Del(
            \Phpcmf\Service::L('Input')->get_post_ids(),
            null,
            null,
           \Phpcmf\Service::M()->dbprefix($this->init['table'])
        );
    }

    /**
     * 获取内容
     * $id      内容id,新增为0
     * */
    protected function _Data($id = 0) {

        $row = parent::_Data($id);
        if ($row) {
            $row['groups'] = dr_string2array($row['member']);
        }

        return $row;
    }

    // 格式化保存数据
    protected function _Format_Data($sid, $data, $old) {

        $data = \Phpcmf\Service::L('Input')->post('data');
        $value = \Phpcmf\Service::L('Input')->post('value');
        !$data['title'] && $this->_json(0, dr_lang('活动主题必须填写'));
        !$data['type'] && $this->_json(0, dr_lang('促销类型必须选择'));
        !$data['money'] && $this->_json(0, dr_lang('活动条件金额必须填写'));

        $save = [
            'type' => (int)$data['type'],
            'title' => $data['title'],
            'money' => (float)$data['money'],
            'description' => (string)$data['description'],
            'value' => (float)$value[$data['type']],
            'member' => dr_array2string($data['member']),
            'stime' => (int)strtotime($data['stime']),
            'etime' => (int)strtotime($data['etime']),
        ];
        $save['stime'] > $save['etime'] && $this->_json(0, dr_lang('开始时间不能超过结束时间'));
        if (!$sid) {
            $save['buy_num'] = 0;
            $save['inputtime'] = SYS_TIME;
        }

        return $save;
    }


}
