<?php namespace Phpcmf\Controllers\Admin;

class Score extends \Phpcmf\Table {

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 表单显示名称
        $this->name = dr_lang('积分购物');
// 模板前缀(避免混淆)
        $this->my_field = array(
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('商品'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('收货人'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
            ),
            'phone' => array(
                'ismain' => 1,
                'name' => dr_lang('电话'),
                'fieldname' => 'phone',
                'fieldtype' => 'Text',
            ),
            'email' => array(
                'ismain' => 1,
                'name' => dr_lang('邮箱'),
                'fieldname' => 'email',
                'fieldtype' => 'Text',
            ),
            'address' => array(
                'ismain' => 1,
                'name' => dr_lang('地址'),
                'fieldname' => 'address',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('备注'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('账户'),
                'fieldname' => 'username',
                'fieldtype' => 'Text',
            ),
            'uid' => array(
                'ismain' => 1,
                'name' => dr_lang('uid'),
                'fieldname' => 'uid',
                'fieldtype' => 'Text',
            ),
        );
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_score',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
        ]);

        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    '积分购物' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-diamond'],
                    '详情' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ]
            ),
            'field' => $this->my_field,
        ]);
    }

    public function index() {

        $this->_List();
        \Phpcmf\Service::V()->display('score_list.html');
    }

    public function edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_admin_msg(0, dr_lang('积分订单不存在'));

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'op_url' => \Phpcmf\Service::L('Router')->url(APP_DIR.'/score/add', ['id' => $id]),
        ]);
        \Phpcmf\Service::V()->display('score_edit.html');
    }


    // 发货操作
    public function add() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        list($tpl, $order) = $this->_Show($id);
        !$order && $this->_admin_msg(0, dr_lang('积分订单不存在'));

        // 订单发货
        $delivery_corp = \Phpcmf\Service::M('Order', 'order')->get_delivery_corp();

        if (IS_AJAX_POST) {

            if ($order['status'] == 2) {
                IS_AJAX_POST ? $this->_json(0, dr_lang('此订单已经发货')) : order_html_error(dr_lang('此订单已经发货'));
            }

            // 未发货，时后台为他发货
            $data = \Phpcmf\Service::L('input')->post('data');
            !$data['name'] && $this->_json(0, dr_lang('姓名必须填写'), ['field' => 'name']);
            !$data['phone'] && $this->_json(0, dr_lang('电话号码必须填写'), ['field' => 'phone']);
            !$data['address'] && $this->_json(0, dr_lang('详细地址必须填写'), ['field' => 'address']);
            // 创建发货记录
            $data['deliver_name'] = isset($delivery_corp[$data['id']]) ? $delivery_corp[$data['id']]['name'] : '';
            $rt = \Phpcmf\Service::M('score', 'order')->add_deliver($order, $data);
            !$rt['code'] && $this->_json(0, $rt['msg']);
            // 通知提醒
            \Phpcmf\Service::L('Notice')->send_notice('order_score_status_2', dr_array2string($order, $data));
            $this->_json(1, dr_lang('操作成功'));
        }
        \Phpcmf\Service::V()->assign([
            'order' => $order,
            'delivery' => $delivery_corp[$order['deliver_id']],
            'delivery_corp' => $delivery_corp,
        ]);

        \Phpcmf\Service::V()->display('api_score_delivery.html');exit;
    }





}
