<?php namespace Phpcmf\Controllers\Admin;

class Service extends \Phpcmf\Table {

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 表单显示名称
        $this->name = dr_lang('售后服务');
        // 模板前缀(避免混淆)
        $this->my_field = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('商品'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('账户'),
                'fieldname' => 'username',
                'fieldtype' => 'Text',
            ),
            'uid' => array(
                'ismain' => 1,
                'name' => dr_lang('uid'),
                'fieldname' => 'uid',
                'fieldtype' => 'Text',
            ),
        );
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_service',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
        ]);

        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('Auth')->_admin_menu(
                [
                    '售后服务' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-user-md'],
                    '详情' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit', 'fa fa-edit'],
                ]
            ),
            'field' => $this->my_field,
        ]);
    }

    public function index() {

        $this->_List();
        \Phpcmf\Service::V()->display('service_list.html');
    }

    public function edit() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_admin_msg(0, dr_lang('售后订单不存在'));

        $order = \Phpcmf\Service::M('Order', 'order')->info($data['oid']);
        !$order && $this->_admin_msg(0, dr_lang('订单不存在'));

        $data['images'] = dr_string2array($data['images']);
        $data['system'] = dr_string2array($data['system']);
        $data['myinfo'] = dr_string2array($data['myinfo']);

        \Phpcmf\Service::V()->assign([
            'item' => $data,
            'order' => $order,
            'delivery_corp' => \Phpcmf\Service::M('Order', 'order')->get_delivery_corp(),
            'address' => $data['system']['address'] ? $data['system']['address'] : $this->mall_info['order']['tui_address'],
        ]);
        \Phpcmf\Service::V()->display('service_edit.html');
    }

    // 删除
    public function del() {
        $this->_Del(\Phpcmf\Service::L('Input')->get_post_ids(), null, function($rows) {
            foreach ($rows as $t) {
                // 删除审核提醒
            }
            return dr_return_data(1, 'ok');
        });
    }


}
