<?php namespace Phpcmf\Controllers\Member;

class Home extends \Phpcmf\Table {

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        // 表单显示名称
        $this->name = dr_lang('订单');
        $this->is_list_data = 0;
    }

    // 订单详情
    public function show() {

        // 初始化数据表
        $this->_init(['table' => SITE_ID.'_order']);

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_msg(0, dr_lang('订单不存在'));
        $data['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));

        // 自动关闭订单
        $this->mall_info['order']['pay_endtime']
        && $data['status'] == 1 && $data['pay_status'] == 0
        && \Phpcmf\Service::M('ocron', 'order')->pay($data, $this->mall_info['order']['pay_endtime']);

        // 自动退款订单
        $this->mall_info['order']['deliver_endtime']
        && $data['status'] == 2 && $data['deliver_status'] == 0
        && \Phpcmf\Service::M('ocron', 'order')->deliver($data, $this->mall_info['order']['deliver_endtime']);

        // 自动收货订单
        $this->mall_info['order']['receipt_endtime']
        && $data['status'] == 2 && $data['deliver_status'] == 1
        && \Phpcmf\Service::M('ocron', 'order')->receipt($data, $this->mall_info['order']['receipt_endtime']);

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'goods' => \Phpcmf\Service::M('Order', 'order')->goods($id),
            'delivery' => \Phpcmf\Service::M('Order', 'order')->deliver_info($data['deliver_id']),
            'pay_endtime' => (int)$this->mall_info['order']['pay_endtime'],
            'deliver_endtime' => (int)$this->mall_info['order']['deliver_endtime'],
            'receipt_endtime' => (int)$this->mall_info['order']['receipt_endtime'],
        ]);
        \Phpcmf\Service::V()->display('order_show.html');
    }

    // 订单评论
    public function comment() {

        // 初始化数据表
        $this->_init(['table' => SITE_ID.'_order']);

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_msg(0, dr_lang('订单不存在'));
        $data['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));
        $data['status'] != 9 && $this->_msg(0, dr_lang('无权限评论此订单'));

        $mall = \Phpcmf\Service::M('Order', 'order')->get_mall_info_id($data['mall_cid']);
        $goods = \Phpcmf\Service::M('Order', 'order')->goods($id);
        $config =  $this->get_cache('module-'.SITE_ID.'-'.$data['mid'], 'comment');
        $mall_config =  $this->get_cache('module-'.SITE_ID.'-mall', 'comment');

        if (IS_POST) {

            $post = \Phpcmf\Service::L('Input')->post('data');
            $review = \Phpcmf\Service::L('Input')->post('review');
            $content = \Phpcmf\Service::L('Input')->post('content');
            $data['comment'] && $this->_msg(0, dr_lang('该订单已经评论过了'));

            // 店铺整合到一起提交评论
            $goods[] = [
                'id' => 'mall',
                'content' => $mall,
            ];

            $call = [];

            foreach ($goods as $t) {

                // 定义模块目录
                $mid = $t['id'] == 'mall' ? 'mall' : $data['mid'];
                $this->_module_init($mid);
                $review_option = $mid == 'mall' ? $mall_config['review']['option'] : $config['review']['option'];

                // 评论状态
                $status = dr_member_auth($this->member_authid, $this->member_cache['auth_module'][SITE_ID][$mid]['comment']['verify']) ? 0 : 1;

                $itemid = $t['id'];
                // 评论入库索引
                $comment = $this->content_model->get_comment_index(
                    (int)$t['content']['id'],
                    (int)$t['content']['catid']
                );
                if (!$comment) {
                    // 评论失败
                    \Phpcmf\Service::M('Order', 'order')->call_comment($call); // 回滚评论
                    $this->_json(0, dr_lang('【%s】评论索引数据读取失败', $t['content']['title']));
                }
                // 判断评分
                $comment = [];
                foreach ($review_option as $i => $name) {
                    $comment['review'][$i] = (int)$review[$itemid][$i];
                    if (!$comment['review'][$i]) {
                        \Phpcmf\Service::M('Order', 'order')->call_comment($call); // 回滚评论
                        $this->_json(0, dr_lang('【%s】%s未评分', $t['content']['title'], $name));
                    }
                }
                $comment['content'] = $content[$itemid];
                !$comment['content'] && $comment['content'] = dr_lang('此用户未做评价');
                // 晒图自定义字段
                $attach = [
                    'del' => [],
                    'add' => []
                ];
                #用于附件UI当
                foreach ($post as $name => $value) {
                    list($name, $iid) = explode('_', $name);
                    if ($iid == $itemid) {
                        if ($name == 'image') {
                            // 晒图字段
                            $image = [];
                            if ($value) {
                                foreach ($value['title'] as $fid => $title) {
                                    $image['file'][$fid] = $value['id'][$fid] ? $value['id'][$fid] : $value['file'][$fid];
                                    $image['title'][$fid] = $title;
                                }
                            }
                            $attach['add'] = dr_array2array($attach['add'], $value['id']);
                            $comment['my'][$name] = dr_array2string($image);
                        }

                    }
                }
                // 提交评论
                $rt = $this->content_model->insert_comment(
                    [
                        'index' => $t['content'],
                        'member' => $this->member,
                        'orderid' => $id,
                        'reply_id' => 0,
                        'status' => $status,
                    ],
                    [
                        'review' => $comment['review'],
                        'content' => $comment['content'],
                    ],
                    $comment['my']
                );

                // 评论失败
                if (!$rt['code']) {
                    \Phpcmf\Service::M('Order', 'order')->call_comment($call); // 回滚评论
                    $this->_json(0, dr_lang('【%s】%s', $t['content']['title'], $rt['msg']));
                }

                $call[] = [
                    'mid' => $mid,
                    'eid' => $rt['code'],
                ];

                // 附件归档
                SYS_ATTACHMENT_DB && $attach && \Phpcmf\Service::M('Attachment')->handle(
                    $this->member['id'],
                   \Phpcmf\Service::M()->dbprefix($this->content_model->mytable.'_comment').'-'.$rt['code'],
                    $attach
                );
            }

            // 更新订单状态
            \Phpcmf\Service::M('Order', 'order')->save_comment($id);

            $this->_json(1, dr_lang('操作成功'));
        }


        if (isset($config['field']['image']) && $config['field']['image']) {
            $config['field']['image']['fieldname'] = 'finecmscommentimagefield';
        }

        $mall_config['field']['image']['fieldname'] = 'finecmscommentimagefield';

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'goods' => $goods,
            'comment' => \Phpcmf\Service::M('Order', 'order')->comment($data['mid'], $id),
            'review' => $config['review'],
            'mall' => $mall,
            'mall_review' => $mall_config['review'],
            'mall_comment' => \Phpcmf\Service::M('Order', 'order')->comment('mall', $id),
            'imagefield' => dr_fieldform($config['field']['image']),
        ]);
        \Phpcmf\Service::V()->display('order_comment.html');
    }


    public function index() {

        // 分类
        $type = [
            0 => [
                'name' => dr_lang('所有订单'),
                'icon' => '<i class="fa fa-shopping-cart"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/home/index', ['tid' => 0]),
            ],
            1 => [
                'name' => dr_lang('待付款'),
                'icon' => '<i class="fa fa-rmb"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/home/index', ['tid' => 1]),
            ],
            2 => [
                'name' => dr_lang('待发货'),
                'icon' => '<i class="fa fa-truck"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/home/index', ['tid' => 2]),
            ],
            3 => [
                'name' => dr_lang('待评价'),
                'icon' => '<i class="fa fa-comments"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/home/index', ['tid' => 3]),
            ],
        ];

        $tid = (int)$_GET['tid'];
        switch ($tid) {

            case 1:
                $where = '`uid`='.$this->uid.' AND `status` = 1';
                break;

            case 2:
                $where = '`uid`='.$this->uid.' AND `status` = 2';
                break;

            case 3:
                $where = '`uid`='.$this->uid.' AND `status` = 9 AND `comment` = 0';
                break;

            default:
                $where = '`uid`='.$this->uid;
                break;
        }

        $this->my_field = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单编号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('收货人'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
            ),
            'phone' => array(
                'ismain' => 1,
                'name' => dr_lang('电话'),
                'fieldname' => 'phone',
                'fieldtype' => 'Text',
            ),
            'email' => array(
                'ismain' => 1,
                'name' => dr_lang('邮箱'),
                'fieldname' => 'email',
                'fieldtype' => 'Text',
            ),
            'address' => array(
                'ismain' => 1,
                'name' => dr_lang('地址'),
                'fieldname' => 'address',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('备注'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
            'mall_name' => array(
                'ismain' => 1,
                'name' => dr_lang('店铺名称'),
                'fieldname' => 'mall_name',
                'fieldtype' => 'Text',
            ),
        );
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => $where,
        ]);
        list($a, $data) = $this->_List(['tid' => $tid]);

        $list = [];
        foreach ($data['list'] as $t) {
            $t['goods'] = \Phpcmf\Service::M('Order', 'order')->goods($t['id']);
            $list[] = $t;
        }

        \Phpcmf\Service::V()->assign([
            'type' => $type,
            'list' => $list,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('order_index.html');
    }

}
