<?php namespace Phpcmf\Controllers\Member;

class Operation extends \Phpcmf\Common {

    private $order;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $this->order = \Phpcmf\Service::M('Order', 'order')->info($id);
        !$this->order && exit($this->_json(0, dr_lang('订单不存在')));
        $this->uid != $this->order['uid'] && exit($this->_json(0, dr_lang('无权限操作此订单')));
    }

    // 收货
    public function delivery() {

        $this->order['deliver_status'] != 1 && exit($this->_json(0, dr_lang('此订单还未发货')));

        $rt = \Phpcmf\Service::M('Order', 'order')->receipt($this->order, dr_lang('买家确认收货'));
        $rt && !$rt['code'] && $this->_json(0, $rt['msg']);
        $this->_json(1, dr_lang('操作成功'));
    }

    // 关闭订单
    public function close() {

        if (IS_POST) {

            $this->order['status'] != 1 && exit($this->_json(0, dr_lang('无权限关闭订单')));
            $this->order['pay_status'] == 1 && exit($this->_json(0, dr_lang('订单已经付款，请申请退款')));

            $note = \Phpcmf\Service::L('Input')->post('note');
            !$note && $this->_json(0, dr_lang('关闭原因必须填写'), ['field' => 'note']);
            $rt = \Phpcmf\Service::M('Order', 'order')->close($this->order, $note);
            $rt && !$rt['code'] && $this->_json(0, $rt['msg']);
            $this->_json(1, dr_lang('操作成功'));
        } else {

            \Phpcmf\Service::V()->assign([
                'order' => $this->order,
                'value' => @explode(PHP_EOL, $this->mall_info['order']['data_close']),
            ]);
            \Phpcmf\Service::V()->display('opt_close.html');exit;
        }
    }

    // 退款订单
    public function refund() {

        if (IS_POST) {

            $this->order['status'] != 2 && exit($this->_json(0, dr_lang('无权限退款订单')));
            $this->order['pay_status'] == 0 && exit($this->_json(0, dr_lang('订单未付款，请关闭订单')));

            $note = \Phpcmf\Service::L('Input')->post('note');
            !$note && $this->_json(0, dr_lang('退款原因必须填写'), ['field' => 'note']);
            $rt = \Phpcmf\Service::M('Order', 'order')->refund($this->order, $note);
            $rt && !$rt['code'] && $this->_json(0, $rt['msg']);
            $this->_json(1, dr_lang('操作成功'));
        } else {

            \Phpcmf\Service::V()->assign([
                'order' => $this->order,
                'value' => @explode(PHP_EOL, $this->mall_info['order']['data_refund']),
            ]);
            \Phpcmf\Service::V()->display('opt_refund.html');exit;
        }

    }

}
