<?php namespace Phpcmf\Controllers\Member;

class Score extends \Phpcmf\Table {

    public function index() {

        // 分类
        $type = [
            0 => [
                'name' => dr_lang('全部'),
                'icon' => '<i class="fa fa-diamond"></i>',
                'url' => dr_member_url('order/score/index', ['tid' => 0]),
            ],
            1 => [
                'name' => dr_lang('待发货'),
                'icon' => '<i class="fa fa-truck"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/score/index', ['tid' => 1]),
            ],
            2 => [
                'name' => dr_lang('已发货'),
                'icon' => '<i class="fa fa-check-circle-o"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/score/index', ['tid' => 2]),
            ],
        ];

        $tid = (int)$_GET['tid'];
        switch ($tid) {

            case 1:
                $where = '`uid`='.$this->uid.' AND `status` = 1';
                break;

            case 2:
                $where = '`uid`='.$this->uid.' AND `status` = 2';
                break;

            default:
                $where = '`uid`='.$this->uid;
                break;
        }

        $this->my_field = array(
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('商品'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('收货人'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
            ),
            'phone' => array(
                'ismain' => 1,
                'name' => dr_lang('电话'),
                'fieldname' => 'phone',
                'fieldtype' => 'Text',
            ),
            'email' => array(
                'ismain' => 1,
                'name' => dr_lang('邮箱'),
                'fieldname' => 'email',
                'fieldtype' => 'Text',
            ),
            'address' => array(
                'ismain' => 1,
                'name' => dr_lang('地址'),
                'fieldname' => 'address',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('备注'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
        );
        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_score',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => $where,
        ]);
        list($a, $data) = $this->_List(['tid' => $tid]);

        \Phpcmf\Service::V()->assign([
            'type' => $type,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('score_index.html');
    }

    // 详情
    public function show() {

        // 初始化数据表
        $this->_init(['table' => SITE_ID.'_order_score']);

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_msg(0, dr_lang('订单不存在'));
        $data['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));

        $delivery_corp = \Phpcmf\Service::M('Order', 'order')->get_delivery_corp();

        \Phpcmf\Service::V()->assign([
            'data' => $data,
            'delivery' => $delivery_corp[$data['deliver_id']],
        ]);
        \Phpcmf\Service::V()->display('score_show.html');
    }


}
