<?php namespace Phpcmf\Controllers\Member;

class Sell extends \Phpcmf\Table {

    public function __construct(...$params)
    {
        parent::__construct(...$params);

    }

    public function add() {

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        $order = \Phpcmf\Service::M('Order', 'order')->info($id);
        if (!$order) {
            IS_AJAX_POST ? $this->_json(0, dr_lang('订单不存在')) : order_html_error(dr_lang('订单不存在'));
        } elseif ($order['sell_uid'] != $this->uid) {
            IS_AJAX_POST ? $this->_json(0, dr_lang('无权限操作')) : order_html_error(dr_lang('无权限操作'));
        }

        $at = \Phpcmf\Service::L('Input')->get('at');
        \Phpcmf\Service::V()->assign([
            'order' => $order,
        ]);

        switch ($at) {


            case 'delivery':
                // 订单发货
                if (!$order['pay_status']) {
                    IS_AJAX_POST ? $this->_json(0, dr_lang('此订单还未付款')) : order_html_error(dr_lang('此订单还未付款'));
                }
                $delivery_corp = \Phpcmf\Service::M('Order', 'order')->get_delivery_corp();
                if (IS_AJAX_POST) {
                    if ($order['deliver_status'] == 0) {
                        // 未发货，时后台为他发货
                        $data = \Phpcmf\Service::L('Input')->post('data');
                        !$data['note'] && $this->_json(0, dr_lang('备注信息必须填写'), ['field' => 'note']);
                        !$data['name'] && $this->_json(0, dr_lang('姓名必须填写'), ['field' => 'name']);
                        !$data['phone'] && $this->_json(0, dr_lang('电话号码必须填写'), ['field' => 'phone']);
                        !$data['address'] && $this->_json(0, dr_lang('详细地址必须填写'), ['field' => 'address']);
                        // 创建发货记录
                        $data['deliver_name'] = isset($delivery_corp[$data['id']]) ? $delivery_corp[$data['id']]['name'] : '';
                        $rt = \Phpcmf\Service::M('Order', 'order')->add_deliver_goods(0, $order, $data);
                        !$rt['code'] && $this->_json(0, $rt['msg']);
                        $this->_json(1, dr_lang('操作成功'));
                    } else {
                        // 定金付款
                        $this->_json(0, dr_lang('未开放'));
                    }
                }
                \Phpcmf\Service::V()->assign([
                    'delivery' => \Phpcmf\Service::M('Order', 'order')->deliver_info($order['deliver_id']),
                    'delivery_corp' => $delivery_corp,
                ]);
                break;



            case 'log':
                // 订单备注
                if (IS_AJAX_POST) {
                    $note = \Phpcmf\Service::L('Input')->post('note');
                    !$note && $this->_json(0, dr_lang('备注内容必须填写'), ['field' => 'note']);
                    // 订单备注
                    \Phpcmf\Service::M('Order', 'order')->add_log($order, $note);
                    $this->_json(1, dr_lang('操作成功'));
                }
                break;

            case 'close':
                // 订单关闭
                if ($order['status'] == 0) {
                    IS_AJAX_POST ? $this->_json(0, dr_lang('此订单已经关闭')) : order_html_error(dr_lang('此订单已经关闭'));
                } elseif ($order['status'] == 9) {
                    IS_AJAX_POST ? $this->_json(0, dr_lang('此订单已经交易完成')) : order_html_error(dr_lang('此订单已经交易完成'));
                }

                if (IS_AJAX_POST) {
                    $note = \Phpcmf\Service::L('Input')->post('note');
                    !$note && $this->_json(0, dr_lang('关闭原因必须填写'), ['field' => 'note']);
                    $order['deliver_status'] == 1 && (IS_AJAX_POST ? $this->_json(0, dr_lang('此订单已经发货，无法关闭')) : order_html_error(dr_lang('此订单已经发货，无法关闭')));
                    // 订单备注
                    \Phpcmf\Service::M('Order', 'order')->close($order, $note);
                    // 判断是否付款
                    if ($order['status'] == 2 && $order['money'] > 0) {
                        // 退款到用户
                        \Phpcmf\Service::M('member')->add_money($order['uid'], $order['money']);
                        \Phpcmf\Service::M('Pay')->add_paylog([
                            'uid' => $order['uid'],
                            'username' => $order['username'],
                            'touid' => 0,
                            'tousername' => '',
                            'mid' => 'order',
                            'title' => dr_lang('订单%s退款', $order['sn']),
                            'value' => $order['money'],
                            'type' => 'admin',
                            'status' => 1,
                            'url' => '',
                            'result' => $order['sn'],
                            'paytime' => SYS_TIME,
                            'inputtime' => SYS_TIME,
                        ]);
                    }
                    $this->_json(1, dr_lang('操作成功'));
                }

                break;

        }
        \Phpcmf\Service::V()->display('sell_'.$at.'.html');exit;
    }

    public function show() {

        // 表单显示名称
        $this->name = dr_lang('订单');
        $this->is_list_data = 0;

        // 初始化数据表
        $this->_init(['table' => SITE_ID.'_order']);

        $id = (int)\Phpcmf\Service::L('Input')->get('id');
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_admin_msg(0, dr_lang('订单不存在'));
        $data['sell_uid'] != $this->uid && $this->_admin_msg(0, dr_lang('无权限查看此订单'));

        \Phpcmf\Service::V()->assign([
            'order' => $data,
            'goods' => \Phpcmf\Service::M('Order', 'order')->goods($id),
            'comment' => \Phpcmf\Service::M('Order', 'order')->comment($data['mid'], $id),
            'review' => $this->get_cache('module-'.SITE_ID.'-goods', 'comment', 'review'),
            'op_log' => \Phpcmf\Service::M('Order', 'order')->log($id),
            'op_url' => \Phpcmf\Service::L('Router')->member_url('order/sell/add', ['id' => $id]),
            'my_money' => max(0, $data['money'] - $data['income_money'] - $data['give_money']),
        ]);
        \Phpcmf\Service::V()->display('sell_show.html');
    }


    public function index() {

        // 模板前缀(避免混淆)
        $this->my_field = array(
            'sn' => array(
                'ismain' => 1,
                'name' => dr_lang('订单编号'),
                'fieldname' => 'sn',
                'fieldtype' => 'Text',
            ),
            'id' => array(
                'ismain' => 1,
                'name' => dr_lang('订单ID'),
                'fieldname' => 'id',
                'fieldtype' => 'Text',
            ),
            'name' => array(
                'ismain' => 1,
                'name' => dr_lang('收货人'),
                'fieldname' => 'name',
                'fieldtype' => 'Text',
            ),
            'phone' => array(
                'ismain' => 1,
                'name' => dr_lang('电话'),
                'fieldname' => 'phone',
                'fieldtype' => 'Text',
            ),
            'email' => array(
                'ismain' => 1,
                'name' => dr_lang('邮箱'),
                'fieldname' => 'email',
                'fieldtype' => 'Text',
            ),
            'address' => array(
                'ismain' => 1,
                'name' => dr_lang('地址'),
                'fieldname' => 'address',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('备注'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('买家账号'),
                'fieldname' => 'username',
                'fieldtype' => 'Text',
            ),
        );

        // 表单显示名称
        $this->name = dr_lang('订单');

        // 分类
        $type = [
            0 => [
                'name' => dr_lang('所有订单'),
                'icon' => '<i class="fa fa-shopping-cart"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/sell/index', ['tid' => 0]),
            ],
            1 => [
                'name' => dr_lang('待付款'),
                'icon' => '<i class="fa fa-rmb"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/sell/index', ['tid' => 1]),
            ],
            2 => [
                'name' => dr_lang('待发货'),
                'icon' => '<i class="fa fa-truck"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/sell/index', ['tid' => 2]),
            ],
            3 => [
                'name' => dr_lang('待评价'),
                'icon' => '<i class="fa fa-comments"></i>',
                'url' => \Phpcmf\Service::L('Router')->member_url('order/sell/index', ['tid' => 3]),
            ],
        ];

        $tid = (int)$_GET['tid'];
        switch ($tid) {

            case 1:
                $where = '`sell_uid`='.$this->uid.' AND `status` = 1';
                break;

            case 2:
                $where = '`sell_uid`='.$this->uid.' AND `status` = 2';
                break;

            case 3:
                $where = '`sell_uid`='.$this->uid.' AND `status` = 9 AND `comment` = 0';
                break;

            default:
                $where = '`sell_uid`='.$this->uid;
                break;
        }

        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order',
            'field' => $this->my_field,
            'sys_field' => [],
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'list_field' => [],
            'where_list' => $where,
        ]);
        list($a, $data) = $this->_List(['tid' => $tid]);

        $list = [];
        foreach ($data['list'] as $t) {
            $t['goods'] = \Phpcmf\Service::M('Order', 'order')->goods($t['id']);
            $list[] = $t;
        }

        \Phpcmf\Service::V()->assign([
            'list' => $list,
            'type' => $type,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('sell_index.html');
    }



}
