<?php namespace Phpcmf\Controllers\Member;

class Sell_service extends \Phpcmf\Table {

    public function index() {

        // 分类
        $type = [
            0 => [
                'name' => dr_lang('全部'),
                'url' => dr_member_url('order/sell_service/index', ['tid' => 0]),
            ],
        ];
        $otype = order_service_type();
        foreach ($otype as $i => $t) {
            $type[$i] = [
                'name' => $t,
                'url' => dr_member_url('order/sell_service/index', ['tid' => $i]),
            ];
        }

        $tid = (int)$_GET['tid'];
        $where = $tid ? '`sell_uid`='.$this->uid.' AND `type` = '.$tid : '`sell_uid`='.$this->uid;

        $this->my_field = array(
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('商品'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('账号'),
                'fieldname' => 'username',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('说明'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
        );

        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_service',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => $where,
        ]);
        $this->_List(['tid' => $tid]);

        \Phpcmf\Service::V()->assign([
            'type' => $type,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('sell_service_index.html');
    }

    public function show() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');

        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_service',
        ]);
        list($tpl, $data) = $this->_Show($id);
        !$data && $this->_admin_msg(0, dr_lang('售后订单不存在'));
        $data['sell_uid'] != $this->uid && $this->_admin_msg(0, dr_lang('无权限查看'));

        $order = \Phpcmf\Service::M('Order', 'order')->info($data['oid']);
        !$order && $this->_admin_msg(0, dr_lang('订单不存在'));

        $data['images'] = dr_string2array($data['images']);
        $data['system'] = dr_string2array($data['system']);
        $data['myinfo'] = dr_string2array($data['myinfo']);

        if (IS_POST) {

            $data['status'] == 3 && $this->_json(0, dr_lang('本订单已完成'));

            // 售后状态0关闭1已提交2商家同意3完成4商家拒绝5已邮寄
            $post = \Phpcmf\Service::L('input')->post('data',true);
            $system = \Phpcmf\Service::L('input')->post('system',true);

            $status = (int)\Phpcmf\Service::L('input')->post('status');
            !$status && $this->_json(0, dr_lang('请选择处理状态'));

            $post['status'] = $data['status'];

            switch ($data['type']) {

                case 1:
                    // 仅退款
                    if ($status == 1) {
                        // 通过
                        $post['status'] = 3;
                        // 退钱
                        $this->_tuikuan($post['money'], $data);
                    } else {
                        // 拒绝
                        $post['status'] = 4;
                    }
                    break;

                case 2:
                    // 退货退款
                    if ($data['status'] == 5 || $data['myinfo']['kdmc']) {
                        // 表示邮寄了
                        if ($status == 1) {
                            // 通过
                            $post['status'] = 3;
                            // 退钱
                            $this->_tuikuan($post['money'], $data);
                        } else {
                            // 拒绝
                            $post['status'] = 4;
                        }
                    } else {
                        if ($status == 1) {
                            // 通过
                            $post['status'] = 2;
                        } else {
                            // 拒绝
                            $post['status'] = 4;
                        }
                    }

                    break;

                case 3:
                    // 换货

                    if ($data['status'] == 5 || $data['myinfo']['kdmc']) {
                        // 表示邮寄了
                        if ($status == 1) {
                            // 通过
                            $post['status'] = 3;
                            // 换货

                        } else {
                            // 拒绝
                            $post['status'] = 4;
                        }
                    } else {
                        if ($status == 1) {
                            // 通过
                            $post['status'] = 2;
                        } else {
                            // 拒绝
                            $post['status'] = 4;
                        }
                    }
                    break;
            }

            $rt = \Phpcmf\Service::M()->table_site('order_service')->update($id, [
                'status' => $post['status'],
                'sysnote' => $post['sysnote'],
                'money' => $post['money'],
                'system' => dr_array2string($system),
            ]);
            !$rt['code'] && $this->_json(0, $rt['msg']);

            // 删除审核提醒
            \Phpcmf\Service::M('member')->delete_admin_notice('order/service/edit:id/'.$id, SITE_ID);

            // 通知提醒
            if (in_array($post['status'], [2,3,4])) {
                $data['status'] = $post['status'];
                $data['sysnote'] = $post['sysnote'];
                $data['money'] = $post['money'];
                $data['system'] = $system;
                \Phpcmf\Service::L('Notice')->send_notice('order_service_status_'.$post['status'], $data);
            }

            $this->_json(1, dr_lang('操作成功'));
        }

        \Phpcmf\Service::V()->assign([
            'item' => $data,
            'order' => $order,
            'delivery_corp' => \Phpcmf\Service::M('Order', 'order')->get_delivery_corp(),
            'address' => $data['system']['address'] ? $data['system']['address'] : $this->mall_info['order']['tui_address'],
        ]);
        \Phpcmf\Service::V()->display('sell_service_show.html');
    }

    // 退款
    private function _tuikuan($value, $item) {

        if ($value > 0) {

            // 扣除商家的钱
            if ($this->member['money'] - $value < 0) {
                $this->_json(0, dr_lang('商家账号余额不足，无法扣除'));
            }

            // 扣除自己的钱
            \Phpcmf\Service::M('Pay')->add_money($this->member['id'], -$value);
            // 增加一条记录
            \Phpcmf\Service::M('Pay')->add_paylog([
                'uid' => $this->member['id'],
                'username' => $this->member['username'],
                'touid' => '0',
                'tousername' => '',
                'mid' => 'order',
                'title' => dr_lang('商品['.$item['title'].']退款'),
                'value' => -$value,
                'type' => 'system',
                'status' => 1,
                'result' => '订单编号：'.$item['sn'],
                'paytime' => SYS_TIME,
                'inputtime' => SYS_TIME,
            ]);

            // 为买家增加钱
            \Phpcmf\Service::M('Pay')->add_money($item['uid'], $value);
            // 增加一条记录
            \Phpcmf\Service::M('Pay')->add_paylog([
                'uid' => $item['uid'],
                'username' => $item['username'],
                'touid' => '0',
                'tousername' => '',
                'mid' => 'order',
                'title' => dr_lang('商品['.$item['title'].']退款成功'),
                'value' => $value,
                'type' => 'system',
                'status' => 1,
                'result' => '订单编号：'.$item['sn'],
                'paytime' => SYS_TIME,
                'inputtime' => SYS_TIME,
            ]);

            $item['money'] = $value;
            \Phpcmf\Service::L('Notice')->send_notice('order_service_tuikuan', $item);
        }

    }


}
