<?php namespace Phpcmf\Controllers\Member;

class Service extends \Phpcmf\Table {

    public function index() {

        // 分类
        $type = [
            0 => [
                'name' => dr_lang('全部'),
                'url' => dr_member_url('order/service/index', ['tid' => 0]),
            ],
        ];
        $otype = order_service_type();
        foreach ($otype as $i => $t) {
            $type[$i] = [
                'name' => $t,
                'url' => dr_member_url('order/service/index', ['tid' => $i]),
            ];
        }

        $tid = (int)$_GET['tid'];
        $where = $tid ? '`uid`='.$this->uid.' AND `type` = '.$tid : '`uid`='.$this->uid;

        $this->my_field = array(
            'title' => array(
                'ismain' => 1,
                'name' => dr_lang('商品'),
                'fieldname' => 'title',
                'fieldtype' => 'Text',
            ),
            'remark' => array(
                'ismain' => 1,
                'name' => dr_lang('说明'),
                'fieldname' => 'remark',
                'fieldtype' => 'Text',
            ),
        );

        // 初始化数据表
        $this->_init([
            'table' => SITE_ID.'_order_service',
            'field' => $this->my_field,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => $where,
        ]);
        $this->_List(['tid' => $tid]);

        \Phpcmf\Service::V()->assign([
            'type' => $type,
            'field' => $this->my_field,
        ]);
        \Phpcmf\Service::V()->display('service_index.html');
    }

    // 详情
    public function show() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $service = \Phpcmf\Service::M('Order', 'order')->service_id($id);
        !$service && $this->_msg(0, dr_lang('售后订单不存在'));
        $service['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));

        $order = \Phpcmf\Service::M('Order', 'order')->info($service['oid']);
        !$order && $this->_msg(0, dr_lang('订单不存在'));

        if (IS_POST) {

            if ($service['status'] == 2) {
                // 接受提交
                $post = \Phpcmf\Service::L('input')->post('data',true);
                !$post['kdmc'] && $this->_json(0, dr_lang('快递名称必须填写'));
                $rt = \Phpcmf\Service::M()->table_site('order_service')->update($id, [
                    'status' => 5,
                    'myinfo' => dr_array2string($post),
                ]);
                !$rt['code'] && $this->_json(0, $rt['msg']);
            } else {
                $this->_json(0, dr_lang('状态异常'));
            }

            $this->_json(1, dr_lang('提交成功，等待商家处理'), [
                'url' => dr_member_url('order/service/show', ['id' => $id]),
            ]);
        }

        \Phpcmf\Service::V()->assign([
            'item' => $service,
            'order' => $order,
            'delivery' => \Phpcmf\Service::M('Order', 'order')->service_deliver_info($service['system']['id']),
        ]);
        \Phpcmf\Service::V()->display('service_show.html');
    }


    // 订单服务管理
    public function order() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $order = \Phpcmf\Service::M('Order', 'order')->info($id);
        !$order && $this->_msg(0, dr_lang('订单不存在'));
        $order['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));
        !$order['status'] && $this->_msg(0, dr_lang('该订单状态不支持售后'));

        $goods = \Phpcmf\Service::M('Order', 'order')->goods($id);
        !$goods && $this->_msg(0, dr_lang('此订单无可用商品'));

        foreach ($goods as $i => $item) {
            // 查询该订单的售后服务记录
            $goods[$i]['service'] = \Phpcmf\Service::M('Order', 'order')->service($item['id']);
        }

        \Phpcmf\Service::V()->assign([
            'order' => $order,
            'goods' => $goods,
        ]);
        \Phpcmf\Service::V()->display('service_order.html');
    }

    // 发起售后服务申请
    public function add() {

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $oid = (int)\Phpcmf\Service::L('input')->get('oid');
        $type = (int)\Phpcmf\Service::L('input')->get('type');
        $item = \Phpcmf\Service::M('Order', 'order')->item($id);
        !$item && $this->_msg(0, dr_lang('订单商品不存在'));
        $item['uid'] != $this->uid && $this->_msg(0, dr_lang('无权限查看此订单'));

        $order = \Phpcmf\Service::M('Order', 'order')->info($oid);
        !$order && $this->_msg(0, dr_lang('订单不存在'));
        !$order['status'] && $this->_msg(0, dr_lang('该订单状态不支持售后'));

        if ($this->mall_info['order']['service_endtime']) {
            $etime = $order['receipt_time'] + (int)$this->mall_info['order']['service_endtime'] * 3600 * 24;
            if ($etime < SYS_TIME) {
                $this->_msg(0, dr_lang('已经超过售后申请的时间'));
            }
        }

        $service = \Phpcmf\Service::M('Order', 'order')->service($item['id']);
        if ($service) {
            // 跳转到服务页面
            IS_POST && $this->_json(0, dr_lang('已经提交过申请'));
            $url = dr_member_url('order/service/show', ['id'=>$service['id']]);
            dr_redirect($url);exit;
        }

        $images = [
            'ismain' => 1,
            'fieldtype' => 'Files',
            'fieldname' => 'images',
            'setting' => array(
                'option' => array(
                    'ext' => 'jpg,png,jpeg,gif',
                    'input' => 1,
                    'size' => 10,
                    'count' => 5,
                ),
            )
        ];

        if (IS_POST) {

            $post = \Phpcmf\Service::L('input')->post('data', true);
            !$post['remark'] && $this->_json(0, dr_lang('申请理由未填写'));

            // 上传字段
            $image = [];
            if ($post['images']) {
                $attach = [
                    'del' => [],
                    'add' => []
                ]; #用于附件UI当
                // 上传字段
                foreach ($post['images']['title'] as $fid => $title) {
                    $image['file'][$fid] = $post['images']['id'][$fid] ? $post['images']['id'][$fid] : $post['images']['file'][$fid];
                    $image['title'][$fid] = $title;
                }
                $attach['add'] = dr_array2array($attach['add'], $post['images']['id']);
            }

            $rt = \Phpcmf\Service::M('Order', 'order')->post_service($item, [
                'type' => $type,
                'remark' => $post['remark'],
                'images' => $image,
                'sn' => $order['sn'],
                'sell_uid' => $order['sell_uid'],
                'sell_username' => $order['sell_username'],
            ]);

            if ($image) {
                // 附件归档
                SYS_ATTACHMENT_DB && $attach && \Phpcmf\Service::M('Attachment')->handle(
                    $this->member['id'],
                    \Phpcmf\Service::M()->dbprefix(SITE_ID.'_order_service').'-'.$rt['code'],
                    $attach
                );
            }

            $this->_json(1, dr_lang('提交成功，等待商家处理'), [
                'url' => dr_member_url('order/service/show', ['id' => $rt['code']]),
            ]);
        }


        \Phpcmf\Service::V()->assign([
            'item' => $item,
            'type' => $type,
            'order' => $order,
            'type_name' => order_service_type($type),
            'images_field' => dr_field_form($images, ''),
        ]);
        \Phpcmf\Service::V()->display('service_add.html');
    }


}
