<?php namespace Phpcmf\Controllers;

class Score extends \Phpcmf\Common {

	// 积分购物
	public function index() {

        !$this->uid && exit($this->_msg(0, '你还没有登录'));

        $id = (int)\Phpcmf\Service::L('input')->get('id');
        $mid = (string)\Phpcmf\Service::L('input')->get('mid');
        !$id && exit($this->_msg(0, dr_lang('内容id不存在')));
        !$mid && exit($this->_msg(0, dr_lang('模块mid不存在')));

        $this->_module_init($mid);
        \Phpcmf\Service::V()->module(APP_DIR);
        $data = $this->content_model->get_row( $id);
        !$data && $this->_msg(0, dr_lang('内容【id#%s】不存在',  $id));
        !isset($data['score']) && $this->_msg(0, dr_lang('此模块没有找到score字段'));

        $data['score_sku'] = dr_string2array($data['score_sku']);
        if ($data['score_sku']) {
            $price = [];
            foreach ($data['score_sku'] as $gid => $v) {
                if (in_array($gid, $this->member['groupid'])) {
                    $price[] = $v;
                }
            }
            !$price && $this->_msg(0, dr_lang('当前用户组无权限购买'));
            $score = intval(min($price));
        } else {
            $score = intval($data['score']);
        }

        if ($score > 0) {
            // 扣积分
            if ((float)$this->member['score'] <= 0 ) {
                $this->_msg(0, dr_lang('账户余额不足'));
            } elseif ($this->member['score'] - $score < 0) {
                $this->_msg(0, dr_lang('账户可用余额不足'));
            }
        }

        if (IS_POST) {
            // 收货地址
            if ($this->mall_info['order']['buy_address']) {
                $address = \Phpcmf\Service::M('Address', 'mall')->info((int)\Phpcmf\Service::L('input')->post('address'));
                !$address && exit($this->_json(0, dr_lang('收货人信息不存在')));
                $address['address'] = dr_linkagepos(FC_ADDRESS_CITY, $address['city'], '', '').$address['address'];
            } else {
                $address = [];
            }
            // 购买记录
            $rt = \Phpcmf\Service::M('score', 'order')->buy(
                $mid,
                $data,
                $score,
                $address,
                dr_safe_replace(\Phpcmf\Service::L('input')->post('remark')));
            if (!$rt['code']) {
                $this->_msg(0, $rt['msg']);exit;
            }
            $this->_json(1, dr_lang('购买成功'), ['url' => dr_member_url('order/score/index')]);
            exit;
        } else {
            \Phpcmf\Service::V()->assign([
                'data' => $data,
                'score' => $score,
                'is_address' => $this->mall_info['order']['buy_address'],
                'address' => $this->mall_info['order']['buy_address'] ? \Phpcmf\Service::M('address', 'mall')->my_address() : [],
                'meta_title' => dr_lang('积分付款').SITE_SEOJOIN.SITE_NAME,
                'meta_keywords' => $this->get_cache('site', SITE_ID, 'config', 'SITE_KEYWORDS'),
                'meta_description' => $this->get_cache('site', SITE_ID, 'config', 'SITE_DESCRIPTION')
            ]);
            \Phpcmf\Service::V()->display('score.html');
        }
    }

}
