<?php namespace Phpcmf\Model;
/**
 * 订单任务计划
 *
 */

class Ocron extends \Phpcmf\Model
{

    // 付款验证自动关闭订单
    public function pay($order, $time) {

        if (!$time) {
            return;
        }

        isset($order['_inputtime']) && is_numeric($order['_inputtime']) && $order['inputtime'] = $order['_inputtime'];

        // 超时
        SYS_TIME - $order['inputtime'] > $time
        && $order['status'] == 1 && $order['pay_status'] == 0
        && \Phpcmf\Service::M('order', 'order')->close($order, '付款超时，自动关闭订单');

        return;
    }

    // 发货验证自动退款订单
    public function deliver($order, $time) {

        if (!$time) {
            return;
        }

        // 超时
        SYS_TIME - $order['pay_time'] > $time
        && $order['status'] == 2 && $order['deliver_status'] == 0
        && \Phpcmf\Service::M('order', 'order')->refund($order, '发货超时，自动退款');

        return;
    }

    // 自动收货订单
    public function receipt($order, $time) {

        if (!$time) {
            return;
        }

        // 超时
        SYS_TIME - $order['deliver_time'] > $time
        && $order['status'] == 2 && $order['deliver_status'] == 1
        && \Phpcmf\Service::M('order', 'order')->receipt($order, '系统自动收货');

        return;
    }

}