<?php namespace Phpcmf\Model;

// 积分
class Score extends \Phpcmf\Model
{

    public function buy($mid, $data, $score, $address, $remark) {

        $order = [
            'mid' => $mid,
            'uid' => $this->member['uid'],
            'username' => $this->member['username'],
            'score' => (int)$score,
            'cid' => (int)$data['id'],
            'title' => (string)$data['title'],
            'url' => (string)$data['url'],
            'num' => 1,

            'name' => (string)$address['name'],
            'email' => (string)$this->member['email'],
            'phone' => (string)$address['phone'],
            'address' => (string)$address['address'],

            'deliver_id' => 0, // 发货ID
            'deliver_time' => 0, // 发货时间
            'deliver_name' => '', // 物流名称
            'deliver_sn' => '', // 运单编号

            'remark' => (string)$remark, // 订单备注
            'status' => 1, //   订单状态, 1未发货 2 已发货
            'inputtime' => SYS_TIME, //下单时间

        ];

        $rt = $this->table_site('order_score')->insert($order);
        if (!$rt['code']) {
            return $rt;
        }

        // 扣款
        $score > 0 && \Phpcmf\Service::M('member')->add_score($this->uid, -$score, '积分购物消费');

        return dr_return_data($rt['code'], 'ok');
    }

    // 订单执行发货操作
    public function add_deliver($order, $data) {

        $save = [
            'name' => $data['name'],
            'phone' => $data['phone'],
            'address' => $data['address'],
            'deliver_id' => (int)$data['id'],
            'deliver_sn' => $data['sn'],
            'deliver_name' => $data['deliver_name'],
            'deliver_time' => SYS_TIME,
            'status' => 2,
        ];
        $rt = $this->table_site('order_score')->update($order['id'], $save);
        if (!$rt['code']) {
            return $rt;
        }


        return dr_return_data($order['id'], 'ok');
    }

}