DROP TABLE IF EXISTS `{dbprefix}mall_delivery_corp`;
CREATE TABLE IF NOT EXISTS `{dbprefix}mall_delivery_corp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '快递名称',
  `code` varchar(255) NOT NULL COMMENT '快递公司代码',
  `url` varchar(255) NOT NULL COMMENT '订单查询网址',
  `disabled` int(10) DEFAULT 0 COMMENT '禁止使用',
  `displayorder` TINYINT(1) DEFAULT 0 COMMENT '排序值',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `displayorder` (`displayorder`),
  KEY `disabled` (`disabled`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商城配送快递公司';

DROP TABLE IF EXISTS `{dbprefix}mall_config`;
CREATE TABLE IF NOT EXISTS `{dbprefix}mall_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '配置名称',
  `value` TEXT NOT NULL COMMENT '配置值',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商城配置表';

DROP TABLE IF EXISTS `{dbprefix}mall_address`;
CREATE TABLE IF NOT EXISTS `{dbprefix}mall_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '作者',
  `value` TEXT NOT NULL COMMENT '详情数组',
  `default` TINYINT(1) unsigned NOT NULL COMMENT '是否默认',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `default` (`default`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商城收货地址';


DROP TABLE IF EXISTS `{dbprefix}mall_shipping`;
CREATE TABLE IF NOT EXISTS `{dbprefix}mall_shipping` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `uid` int(10) unsigned NOT NULL COMMENT 'uid',
  `username` varchar(255) NOT NULL COMMENT '商家',
  `name` varchar(100) DEFAULT NULL COMMENT '运费名称',
  `valuation` tinyint(1) DEFAULT NULL COMMENT '计价方式：1数量，2重量，3体积',
  `freight` text COMMENT '运费详情',
  `free` text COMMENT '包邮策略',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商城运费配置';


REPLACE INTO `{dbprefix}member_group` VALUES(1, '买家', '0.00', 0, 0, 1, 1, '{\"level\":{\"auto\":\"1\",\"unit\":\"0\",\"price\":\"0\"},\"verify\":\"0\"}', 0);
REPLACE INTO `{dbprefix}member_group` VALUES(2, '商家', '0.00', 0, 0, 1, 1, '{\"level\":{\"auto\":\"0\",\"unit\":\"0\",\"price\":\"0\"},\"verify\":\"0\"}', 0);
