
DROP TABLE IF EXISTS `{dbprefix}order`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `sn` varchar(100) NOT NULL COMMENT '订单流水',
  `mid` varchar(100) NOT NULL COMMENT '模块目录',
  `uid` int(10) unsigned NOT NULL COMMENT '购买者',
  `username` varchar(100) NOT NULL COMMENT '购买者账号',
  `sell_uid` int(10) unsigned NOT NULL COMMENT '卖家',
  `sell_username` varchar(100) NOT NULL COMMENT '卖家账号',
  `mall_cid` int(10) unsigned NOT NULL COMMENT '店铺',
  `mall_url` varchar(200) NOT NULL COMMENT '店铺地址',
  `mall_name` varchar(200) NOT NULL COMMENT '店铺名称',
  `money` decimal(10,2) NOT NULL COMMENT '该付款金额',
  `income_money` decimal(10,2) NOT NULL COMMENT '平台分成金额',
  `freight` decimal(10,2) NOT NULL COMMENT '运费',
  `discount` decimal(10,2) NOT NULL COMMENT '优惠的金额',
  `coupon` int(10) unsigned NOT NULL COMMENT '优惠券id',
  `give_score` int(10) unsigned NOT NULL COMMENT '赠送积分',
  `give_money` decimal(10,2) unsigned NOT NULL COMMENT '赠送金额',
  `source` TINYINT(1) unsigned NOT NULL COMMENT '下单来源设备',
  `name` varchar(255) NOT NULL COMMENT '收货人姓名',
  `email` varchar(255) NOT NULL COMMENT '收货人email',
  `phone` varchar(255) NOT NULL COMMENT '收货人phone',
  `address` varchar(255) NOT NULL COMMENT '收货人address',
  `pay_id` int(10) NOT NULL COMMENT '付款ID',
  `pay_time` int(10) NOT NULL COMMENT '付款时间',
  `pay_type` varchar(255) NOT NULL COMMENT '付款方式',
  `pay_status` TINYINT(2) NOT NULL COMMENT '付款状态',
  `deliver_id` int(10) NOT NULL COMMENT '发货ID',
  `deliver_time` int(10) NOT NULL COMMENT '发货时间',
  `deliver_status` TINYINT(2) NOT NULL COMMENT '发货状态',
  `receipt_time` int(10) NOT NULL COMMENT '收货时间',
  `comment` TINYINT(1) NOT NULL COMMENT '是否评论',
  `comment_time` int(10) NOT NULL COMMENT '评论时间',
  `remark` text NOT NULL COMMENT '订单备注',
  `promotion_name` varchar(255) NOT NULL COMMENT '优惠活动名称',
  `promotion_info` varchar(255) NOT NULL COMMENT '优惠详情',
  `status` TINYINT(2) NOT NULL COMMENT '订单状态',
  `inputtime` int(10) NOT NULL COMMENT '下单时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`),
  KEY `sell_uid` (`sell_uid`),
  KEY `uid` (`uid`),
  KEY `mid` (`mid`),
  KEY `username` (`username`),
  KEY `phone` (`phone`),
  KEY `status` (`status`),
  KEY `pay_status` (`pay_status`),
  KEY `deliver_status` (`deliver_status`),
  KEY `comment` (`comment`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单数据表';


DROP TABLE IF EXISTS `{dbprefix}goods_promotion`;
CREATE TABLE IF NOT EXISTS `{dbprefix}goods_promotion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '创建',
  `username` varchar(100) NOT NULL COMMENT '创建账号',
  `type` tinyint(1) NOT NULL COMMENT '活动类型',
  `title` varchar(255) NOT NULL COMMENT '活动主题',
  `description` varchar(255) NOT NULL COMMENT '活动描述',
  `value` varchar(255) NOT NULL COMMENT '参数设置',
  `member` varchar(255) NOT NULL COMMENT '面向的用户',
  `nums` int(10) unsigned NOT NULL COMMENT '商品数',
  `buy_num` int(10) unsigned NOT NULL COMMENT '已购买人数',
  `stime` int(10) unsigned NOT NULL COMMENT '开始时间',
  `etime` int(10) unsigned NOT NULL COMMENT '结束时间',
  `inputtime` int(10) unsigned NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `inputtime` (`inputtime`),
  KEY `stime` (`stime`),
  KEY `etime` (`etime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商品活动';

DROP TABLE IF EXISTS `{dbprefix}goods_promotion_item`;
CREATE TABLE IF NOT EXISTS `{dbprefix}goods_promotion_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL COMMENT '活动id',
  `cid` int(10) unsigned NOT NULL COMMENT '商品id',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='商品活动的商品';

DROP TABLE IF EXISTS `{dbprefix}order_promotion`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_promotion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '创建',
  `username` varchar(100) NOT NULL COMMENT '创建账号',
  `type` int(10) NOT NULL COMMENT '活动类型',
  `money` decimal(10,2) NOT NULL COMMENT '活动条件',
  `title` varchar(255) NOT NULL COMMENT '活动主题',
  `description` varchar(255) NOT NULL COMMENT '活动描述',
  `value` varchar(255) NOT NULL COMMENT '参数设置',
  `member` varchar(255) NOT NULL COMMENT '面向的用户',
  `buy_num` int(10) unsigned NOT NULL COMMENT '已购买人数',
  `stime` int(10) unsigned NOT NULL COMMENT '开始时间',
  `etime` int(10) unsigned NOT NULL COMMENT '结束时间',
  `inputtime` int(10) unsigned NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `inputtime` (`inputtime`),
  KEY `stime` (`stime`),
  KEY `etime` (`etime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单活动';

DROP TABLE IF EXISTS `{dbprefix}order_cart`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_cart` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT '购买者',
  `cid` varchar(255) NOT NULL COMMENT '购物车ID号',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单下单记录表';


DROP TABLE IF EXISTS `{dbprefix}order_goods`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_goods` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `oid` BIGINT(18) unsigned NOT NULL COMMENT '订单id',
  `mid` varchar(100) NOT NULL COMMENT '支付mid',
  `uid` int(10) unsigned NOT NULL COMMENT '购买者',
  `num` int(10) unsigned NOT NULL COMMENT '购买数量',
  `total` decimal(10,2) NOT NULL COMMENT '购买总价（优惠后）',
  `price` decimal(10,2) NOT NULL COMMENT '商品单价',
  `yuan` decimal(10,2) NOT NULL COMMENT '商品原价（优惠时）',
  `promotion_name` varchar(255) NOT NULL COMMENT '优惠名称',
  `promotion_info` varchar(255) NOT NULL COMMENT '优惠详情',
  `sn` varchar(255) NOT NULL COMMENT '商品货号',
  `sku_name` text NOT NULL COMMENT '商品属性名称',
  `sku_value` varchar(255) NOT NULL COMMENT '商品属性参数',
  `title` varchar(255) NOT NULL COMMENT '商品名称',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `url` varchar(255) NOT NULL COMMENT '商品地址',
  `status` TINYINT(2) NOT NULL COMMENT '订单状态',
  `table` varchar(255) NOT NULL COMMENT '表名',
  `content` text NOT NULL COMMENT '商品内容快照详情',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `mid` (`mid`),
  KEY `oid` (`oid`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单商品关联';

DROP TABLE IF EXISTS `{dbprefix}order_log`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_log` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `oid` BIGINT(18) unsigned NOT NULL COMMENT '订单id',
  `uid` int(10) unsigned NOT NULL COMMENT '操作人uid',
  `username` varchar(255) NOT NULL COMMENT '操作人name',
  `log` text NOT NULL COMMENT '操作日志',
  `deliver_status` TINYINT(2) NOT NULL COMMENT '发货状态',
  `pay_status` TINYINT(2) NOT NULL COMMENT '付款状态',
  `status` TINYINT(2) NOT NULL COMMENT '订单状态',
  `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `oid` (`oid`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单操作日志';

DROP TABLE IF EXISTS `{dbprefix}order_service`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_service` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL COMMENT 'uid',
  `username` varchar(255) NOT NULL COMMENT '购买者',
  `sell_uid` int(10) unsigned NOT NULL COMMENT 'uid',
  `sell_username` varchar(255) NOT NULL COMMENT '商家',
  `oid` BIGINT(18) unsigned NOT NULL COMMENT '订单id',
  `sn` varchar(100) NOT NULL COMMENT '订单流水',
  `cid` int(10) unsigned NOT NULL COMMENT '商品id',
  `title` varchar(255) NOT NULL COMMENT '商品名称',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `url` varchar(255) NOT NULL COMMENT '商品地址',
  `type` TINYINT(2) NOT NULL COMMENT '服务类型1仅退款2退货款3换货',
  `money` decimal(10,2) NOT NULL COMMENT '退款金额',
  `status` TINYINT(2) NOT NULL COMMENT '处理状态0关闭1已提交2商家同意3完成4商家拒绝',
  `remark` text NOT NULL COMMENT '买家备注说明',
  `images` text NOT NULL COMMENT '买家上传图片',
  `system` text NOT NULL COMMENT '商家处理信息',
  `sysnote` text NOT NULL COMMENT '平台审核备注',
  `myinfo` text NOT NULL COMMENT '买家信息',
  `inputtime` int(10) unsigned NOT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `sell_uid` (`sell_uid`),
  KEY `oid` (`oid`),
  KEY `type` (`type`),
  KEY `cid` (`cid`),
  KEY `status` (`status`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单售后服务处理';

DROP TABLE IF EXISTS `{dbprefix}order_deliver_goods`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_deliver_goods` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `tid` TINYINT(1) NOT NULL COMMENT '发货类型发0换1',
  `oid` BIGINT(18) unsigned NOT NULL COMMENT '订单id',
  `sn` varchar(255) NOT NULL COMMENT '订单编号',
  `uid` int(10) unsigned NOT NULL COMMENT '购买者id',
  `username` varchar(255) NOT NULL COMMENT '购买者name',
  `sell_uid` int(10) unsigned NOT NULL COMMENT 'uid',
  `sell_username` varchar(255) NOT NULL COMMENT '商家',
  `name` varchar(255) NOT NULL COMMENT '发货姓名',
  `phone` varchar(255) NOT NULL COMMENT '发货电话',
  `address` varchar(255) NOT NULL COMMENT '发货详细地址',
  `admin_uid` int(10) unsigned NOT NULL COMMENT '操作人uid',
  `admin_username` varchar(255) NOT NULL COMMENT '操作人name',
  `note` text NOT NULL COMMENT '备注信息',
  `deliver_id` int(5) NOT NULL COMMENT '物流id',
  `deliver_sn` varchar(255) NOT NULL COMMENT '运单编号',
  `deliver_name` varchar(255) NOT NULL COMMENT '物流名称',
  `inputtime` int(10) unsigned NOT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `oid` (`oid`),
  KEY `sn` (`sn`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='订单发货记录';

DROP TABLE IF EXISTS `{dbprefix}cart`;
CREATE TABLE IF NOT EXISTS `{dbprefix}cart` (
  `id` BIGINT(18) unsigned NOT NULL AUTO_INCREMENT,
  `mid` varchar(100) NOT NULL COMMENT '支付mid',
  `uid` int(10) unsigned NOT NULL COMMENT '购买者',
  `price` decimal(10,2) NOT NULL COMMENT '售价',
  `quantity` int(10) NOT NULL COMMENT '数量',
  `sku_name` text NOT NULL COMMENT '商品属性名称',
  `sku_value` varchar(255) NOT NULL COMMENT '商品属性参数',
  `title` varchar(255) NOT NULL COMMENT '商品名称',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `url` varchar(255) NOT NULL COMMENT '商品地址',
  `mall_uid` int(10) unsigned NOT NULL COMMENT '商家uid',
  `mall_cid` int(10) unsigned NOT NULL COMMENT '商铺id',
  `mall_name` varchar(255) NOT NULL COMMENT '商铺名称',
  `mall_url` varchar(255) NOT NULL COMMENT '商铺地址',
  `inputtime` int(10) NOT NULL COMMENT '加入时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `mid` (`mid`),
  KEY `price` (`price`),
  KEY `sku_value` (`sku_value`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='我的购物车表';

DROP TABLE IF EXISTS `{dbprefix}order_score`;
CREATE TABLE IF NOT EXISTS `{dbprefix}order_score` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mid` varchar(50) NOT NULL COMMENT '模块目录',
  `cid` int(10) NOT NULL COMMENT '内容id',
  `title` varchar(255) NOT NULL COMMENT '相关商品',
  `url` varchar(255) NOT NULL COMMENT '相关地址',
  `num` int(10) NOT NULL COMMENT '数量',
  `score` int(10) NOT NULL COMMENT '积分',
  `username` varchar(255) NOT NULL COMMENT '购买者账号',
  `uid` int(10) NOT NULL COMMENT '购买者id',
  `name` varchar(255) NOT NULL COMMENT '收货人姓名',
  `email` varchar(255) NOT NULL COMMENT '收货人email',
  `phone` varchar(255) NOT NULL COMMENT '收货人phone',
  `address` varchar(255) NOT NULL COMMENT '收货人address',
  `remark` text NOT NULL COMMENT '备注信息',
  `deliver_id` int(5) NOT NULL COMMENT '物流id',
  `deliver_sn` varchar(255) NOT NULL COMMENT '运单编号',
  `deliver_name` varchar(255) NOT NULL COMMENT '物流名称',
  `deliver_time` int(10) NOT NULL COMMENT '发货时间',
  `status` TINYINT(2) NOT NULL COMMENT '订单状态',
  `inputtime` int(10) NOT NULL COMMENT '购买时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `mid` (`mid`),
  KEY `cid` (`cid`),
  KEY `status` (`status`),
  KEY `inputtime` (`inputtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='虚拟币购物';



REPLACE INTO `{dbprefix}share_category` VALUES(1, 2, 0, '', '0', '优惠促销', 'youhuicuxiao', '', 0, '1', '', '', '', 1, '', '{\"urlrule\":\"0\",\"seo\":{\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"10\",\"page\":\"page.html\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"},\"linkurl\":\"\\/index.php?s=mall&c=goods\"}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(2, 1, 0, 'jifen', '0', '积分商城', 'jfsc', '', 1, '2,8,9,10,11,12', '', '', '', 1, '', '{\"linkurl\":\"\",\"urlrule\":\"0\",\"seo\":{\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"10\",\"page\":\"page.html\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(3, 1, 0, 'news', '0', '购物指南', 'gouwuzhinan', '', 1, '3,4,5,6,7', '', '', '', 1, '', '{\"linkurl\":\"\",\"urlrule\":\"0\",\"seo\":{\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"10\",\"page\":\"page.html\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(4, 1, 3, 'news', '0,3', '新手入门', 'xinshourumen', 'gouwuzhinan/', 0, '4', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(5, 1, 3, 'news', '0,3', '配送方式', 'peisongfangshi', 'gouwuzhinan/', 0, '5', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(6, 1, 3, 'news', '0,3', '支付方式', 'zhifufangshi', 'gouwuzhinan/', 0, '6', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(7, 1, 3, 'news', '0,3', '售后服务', 'shouhoufuwu', 'gouwuzhinan/', 0, '7', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(8, 1, 2, 'jifen', '0,2', '服饰、内衣、配件', 'fushineiyipeijian', 'jfsc/', 0, '8', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(9, 1, 2, 'jifen', '0,2', '箱包皮具、钟表奢品', 'xiangbaopijuzhongbiaoshepin', 'jfsc/', 0, '9', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(10, 1, 2, 'jifen', '0,2', '汽车用品、运动户外', 'qicheyongpinyundonghuwai', 'jfsc/', 0, '10', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(11, 1, 2, 'jifen', '0,2', '美妆个护、面膜、洗护', 'meizhuanggehumianmoxihu', 'jfsc/', 0, '11', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(12, 1, 2, 'jifen', '0,2', '数码、手机、家电', 'shumashoujijiadian', 'jfsc/', 0, '12', NULL, NULL, '', 1, '', '{\"edit\":1,\"template\":{\"list\":\"list.html\",\"show\":\"show.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"pagesize\":20},\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{name}{join}{modname}{join}{SITE_NAME}\",\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catname}{join}{modname}{join}{SITE_NAME}\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(13, 0, 0, '', '0', '关于我们', 'guanyuwomen', '', 0, '13', '', '', '', 1, '<p><span style=\"color: rgb(119, 119, 119); font-family: Hind, sans-serif;\"></span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 30px; color: rgb(119, 119, 119); font-family: Hind, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">商家CMS是一款基于PHP7CMS框架的多用户网上商城解决方案，商家CMS是商店CMS的姊妹篇，她除了延续商店CMS的众多优点之外，还增加了商家入驻功能，使操作更加简单，功能更加完善，性能更加稳定的多用户商城建设系统。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 30px; color: rgb(119, 119, 119); font-family: Hind, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">多用户商城系统，如类似淘宝天猫一样的平台，即B2B2C模式，提供“总站&gt;&gt;商家&gt;&gt;买家”交易模式平台。该系统不仅能建立一个强大的商城，同时自身网站上又可开设无数的子店铺商家网站。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 30px; color: rgb(119, 119, 119); font-family: Hind, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\">系统拥有完善的商家与平台的分成系统，也有完整的售后业务流程管控。帮助客户降低成本、提升效率、简化运维、提高系统可靠性和安全性，助力中大型企业在互联网领域取得卓越绩效。</p><p><br/></p><p><strong>PHP7CMS架构</strong></p><p>以强大的内容管理系统为基础，CI框架+Zend框架+高性能PHP7语言，性能优越</p><p><br/></p><p><strong>内容管理</strong></p><p>自定义内容模块、自定义字段、自定义表单和模块表单、网站单页系统、模块内容评论等</p><p><br/></p><p><strong>会员用户系统</strong></p><p>自定义用户组模型、单点登录系统、微信/微博/QQ登录，一个用户可同时拥有多个用户组</p><p><br/></p><p><strong>API开放接口</strong></p><p>全站读写接口权限，增删改、上传、注册、登录等，自定义创建接口数据规则</p><p><br/></p><p><strong>任务通知</strong></p><p>微信、邮件、短信、站内信通知一键设置，让消费者有直观全面的了解网站数据情况</p><p><br/></p><p><strong>微信系统</strong></p><p>微信接入可对不同的子站单独设置，文章同步发送微信，自定义菜单，消息同步，微信付款接口</p><p><br/></p><p><strong>商品管理</strong></p><p>多元化商品管理、商品限时促销、折扣优惠、库存预警、新品推送、支持SKU模式定价、积分购物</p><p><br/></p><p><strong>订单系统</strong></p><p>一键下单、批量下单付款、快递单号查询、微信通知进度、订单统计报表、商品收货流程</p><p><br/></p><p><strong>商品评分</strong></p><p>商品评价、分数点评、晒图等，对商品按照评分排序筛选，评分排行榜</p><p><span style=\"color: rgb(119, 119, 119); font-family: Hind, sans-serif; background-color: rgb(255, 255, 255);\"></span><br/></p>', '{\"linkurl\":\"\",\"urlrule\":\"0\",\"seo\":{\"show_title\":\"[\\u7b2c{page}\\u9875{join}]{title}{join}{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"10\",\"page\":\"page.html\",\"list\":\"page.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"}}', 0);
REPLACE INTO `{dbprefix}share_category` VALUES(14, 2, 0, '', '0', '商铺大全', 'shangpu', '', 0, '14', '', '', '', 1, '', '{\"linkurl\":\"\\/index.php?s=mall\",\"urlrule\":\"0\",\"seo\":{\"list_title\":\"[\\u7b2c{page}\\u9875{join}]{catpname}{join}{modname}{join}{SITE_NAME}\",\"list_keywords\":\"\",\"list_description\":\"\"},\"template\":{\"pagesize\":\"10\",\"page\":\"page.html\",\"list\":\"list.html\",\"category\":\"category.html\",\"search\":\"search.html\",\"show\":\"show.html\"}}', -1);


REPLACE INTO `{dbprefix}share_index` VALUES(1, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(2, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(3, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(4, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(5, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(6, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(7, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(8, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(9, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(10, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(11, 'news');
REPLACE INTO `{dbprefix}share_index` VALUES(12, 'news');
