<?php

// 星级显示
function dr_mall_star_level($num) {

    $lv = 5;
    $int = min(floor($num), $lv);
    if (!$int) {
        return '<i title="'.$num.'" class="fa fa-star-o"></i><i title="'.$num.'" class="fa fa-star-o"></i><i title="'.$num.'" class="fa fa-star-o"></i><i title="'.$num.'" class="fa fa-star-o"></i><i title="'.$num.'" class="fa fa-star-o"></i>';
    }

    // 实心
    $shi = [];
    for ($i=0; $i<$int; $i++) {
        $shi[] = '<i title="'.$num.'" class="fa fa-star"></i>';
    }

    // 五星返回
    if (count($shi) >= $lv) {
        return @implode('', $shi);
    }

    // 剩下的心
    if ($num - $int > 0.5) {
        $shi[]= '<i title="'.$num.'" class="fa fa-star-half-o"></i>';
    } else {
        $shi[] = '<i title="'.$num.'" class="fa fa-star-o"></i>';
    }
    $sx = $lv - count($shi);
    if ($sx > 0) {
        for ($i=1; $i< $lv - $int; $i++) {
            $shi[] = '<i title="'.$num.'" class="fa fa-star-o"></i>';
        }
    }

    return @implode('', $shi);
}


// 获取客户端来源 1电脑 2手机 3微信
function dr_mall_order_source($id) {

    switch ($id) {

        case 1:
            return '<a href="javascript:dr_layer_tips(\'来自电脑\');"><i class="fa fa-desktop"></i></a>';
            break;
        case 2:
            return '<a href="javascript:dr_layer_tips(\'来自手机\');"><i class="fa fa-mobile"></i></a>';
            break;
        case 3:
            return '<a href="javascript:dr_layer_tips(\'来自微信\');"><i class="fa fa-weixin"></i></a>';
            break;
    }
}

// 新品URL
function dr_mall_goods_url($day) {
    return 'index.php?s=mall&c=goods&id='.$day;
}

// 抢购商品URL
function dr_mall_flash_url($id, $sku) {
    return 'index.php?s=mall&c=flash&m=buy&id='.$id.'&sku='.$sku;
}

// 选择多个商品结果集
function dr_mall_goods_html($data) {

    if (!$data) {
        return '';
    }

    $html = '';
    foreach ($data as $t) {

        $html.= '<tr id="dr_items_goods_'.$t['id'].'">';
        $html.= '<input type="hidden" name="goods[]" value="'.$t['id'].'">';
        $html.= '<td>'.$t['id'].'</td>';
        $html.= '<td><a href="'.$t['url'].'" target="_blank">'.$t['title'].'</a></td>';
        $html.= '<td>'.$t['price_quantity'].'</td>';
        $html.= '<td><span class="price">￥'.(!$t['price_sku'] ? number_format($t['price'],2) : dr_sku_price($t['price_sku'], 2, ' ~ ')).'元</span></td>';
        $html.= '<td style="text-align:center"><a href="javascript:$(\'#dr_items_goods_'.$t['id'].'\').remove();" class="btn btn-xs red"> <i class="fa fa-trash"></i></a></td>';
        $html.= '</tr>';

    }

    return $html;
}

// 分析商品sku值并归类数组
function dr_mall_sku_array($string) {

    if (!$string) {
        return [];
    }

    $i = 0;
    $array = explode('_', $string);
    $return = [];
    foreach ($array as $k => $t) {
        $i%2 == 0 && $return[$t] = isset($array[$k+1]) ? $array[$k+1] : '';
        $i ++;
    }

    return $return;
}


// 输出错误信息显示
function order_html_error($msg) {
    echo '<div class="alert alert-danger">'.$msg.'</div>';exit;
}

// 默认订单常见短信用语
function order_default_order_message() {
    return explode(PHP_EOL, \Phpcmf\Service::C()->mall_info['order']['data_sms']);
}

// 生成订单流水号
function order_get_order_sn() {

    mt_srand((double) microtime() * 1000000);

    return 'FC'.date('Ymd').str_pad(mt_rand(1, 999999), 6, '0', STR_PAD_LEFT);
}



// 获取付款方式
function order_get_pay_type() {

    $pay_type = [];
    $pay_default = 'finecms';
    $pay_type['finecms'] = require WEBPATH.'api/pay/finecms/config.php';

    if (\Phpcmf\Service::C()->member_cache['payapi']) {
        foreach (\Phpcmf\Service::C()->member_cache['payapi'] as $name => $t) {
            if (!is_file(WEBPATH.'api/pay/'.$name.'/config.php')) {
                continue; // 排除是否存在配置文件
            }
            $pay_type[$name] = require WEBPATH.'api/pay/'.$name.'/config.php';
        }
    }

    return [$pay_type, $pay_default];
}


// 获取客户端来源 1电脑 2手机 3微信
function order_get_agent_name() {

    if (IS_PC) {
        return 1;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')) {
        return 3;
    }

    return 2;
}

// 订单状态 0关闭 1已下单 2已付款 3已退货 4退货中 5换货中 9 已完成
function order_order_status($data) {

    switch ($data['status']) {

        case 0:
            return '<span class="label label-default"> '.dr_lang('已关闭').' </span>';
            break;

        case 1:
            return '<span class="label label-info"> '.dr_lang('已下单').' </span>';
            break;

        case 2:
            return '<span class="label label-primary"> '.dr_lang('已付款').' </span>';
            break;

        case 3:
            return '<span class="label label-danger"> '.dr_lang('已退货').' </span>';
            break;

        case 4:
            return '<span class="label label-warning"> '.dr_lang('退货中').' </span>';
            break;

        case 5:
            return '<span class="label label-warning"> '.dr_lang('换货中').' </span>';
            break;

        case 9:
            return '<span class="label label-success"> '.dr_lang('已完成').' </span>';
            break;
    }

}

// 付款状态 付款状态 1已付款 2已退款　0未付款
function order_pay_status($data) {

    switch ($data['pay_status']) {

        case 0:
            return '<span class="label label-danger"> '.dr_lang('未付款').' </span>';
            break;

        case 1:
            return '<span class="label label-success"> '.dr_lang('已付款').' </span>';
            break;

        case 2:
            return '<span class="label label-warning"> '.dr_lang('已退款').' </span>';
            break;
    }

}

// 发货状态 0未发货 1发货 2确认收货 3退货成功 4换货成功
function order_deliver_status($data) {

    switch ($data['deliver_status']) {

        case 0:
            return '<span class="label label-default"> '.dr_lang('未发货').' </span>';
            break;

        case 1:
            return '<span class="label label-info"> '.dr_lang('已发货').' </span>';
            break;

        case 2:
            return '<span class="label label-success"> '.dr_lang('已收货').' </span>';
            break;

        case 3:
            return '<span class="label label-danger"> '.dr_lang('已退货').' </span>';
            break;

        case 4:
            return '<span class="label label-warning"> '.dr_lang('已换货').' </span>';
            break;
    }
}

// 积分订单状态
function order_score_status($t) {

    switch ($t) {

        case 1:
            return '<span class="label label-default"> '.dr_lang('未发货').' </span>';
            break;

        case 2:
            return '<span class="label label-info"> '.dr_lang('已发货').' </span>';
            break;
    }
}
// 售后状态0关闭1已提交2商家同意3完成4商家拒绝5已邮寄
function order_service_status($t) {

    switch ($t) {

        case 0:
            return '<span class="label label-default"> '.dr_lang('已关闭').' </span>';
            break;

        case 1:
            return '<span class="label label-info"> '.dr_lang('已提交').' </span>';
            break;

        case 2:
            return '<span class="label label-warning"> '.dr_lang('已同意').' </span>';
            break;

        case 3:
            return '<span class="label label-success"> '.dr_lang('已完成').' </span>';
            break;

        case 4:
            return '<span class="label label-danger"> '.dr_lang('被拒绝').' </span>';
            break;

        case 5:
            return '<span class="label label-warning"> '.dr_lang('已邮寄').' </span>';
            break;
    }
}

// 售后类型
function order_service_type($id = 0) {

    $data = [
        1 => dr_lang('仅退款'),
        2 => dr_lang('退货退款'),
        3 => dr_lang('换货'),
    ];

    return $id ? $data[$id] : $data;
}

// 订单详细状态
function order_info_status($data) {

    return dr_clearhtml(order_order_status($data).','.order_pay_status($data).','.order_deliver_status($data));
}

function dr_is_mall_favorite($id) {
    return 0;
}
