<?php namespace My\Library;

// 路由及url处理类

class Router extends \Phpcmf\Library\Router
{

    // 重写通用模块规则
    function show_url($mod, $data, $page = 0) {

        if ($mod['dirname'] == 'mall') {
            return $this->mall_url('show', $data, [], $mod);
        }

        return parent::show_url($mod, $data, $page);
    }

    /**
     * 商铺子商品URL地址
     */
    public function mall_url($type, $data, $param = [], $mod = []) {

        if ($type == 'goods' && $param) {
            $rule = isset(\Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule']['search'])
            && \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule']['search'] ? \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule']['search'] : '';
        } else {
            $rule = isset(\Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule'][$type])
            && \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule'][$type] ? \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['rule'][$type] : '';
        }

        if ($rule) {
            // URL模式为自定义，且已经设置规则
            !$mod && $mod = \Phpcmf\Service::C()->module;
            $cat = $mod['category'][$data['catid']];
            $data['modname'] = $mod['dirname'];
            $cat['pdirname'].= $cat['dirname'];
            $data['dirname'] = $cat['dirname'];
            $inputtime = isset($data['_inputtime']) ? $data['_inputtime'] : $data['inputtime'];
            $data['y'] = date('Y', $inputtime);
            $data['m'] = date('m', $inputtime);
            $data['d'] = date('d', $inputtime);
            $data['pdirname'] = $cat['pdirname'];
            $data['param'] = dr_rewrite_encode($param, '-');
            $url = ltrim($rule, '/');
            $rep = new \php5replace($data);
            $url = preg_replace_callback("#{([a-z_0-9]+)}#Ui", array($rep, 'php55_replace_data'), $url);
            $url = preg_replace_callback('#{([a-z_0-9]+)\((.*)\)}#Ui', array($rep, 'php55_replace_function'), $url);
            return $this->url_prefix('rewrite', $mod, $cat).$url;
        } else {
            return '/index.php?s=mall&c='.$type.'&id='.$data['id'].($param ? '&'.http_build_query($param) : '');
        }
    }

}