<?php namespace My\Library;

class Seo extends \Phpcmf\Library\Seo
{
    
    public function show($mod, $data, $page = 1) {
        if ($mod['dirname'] == 'mall') {
            // 防止二次重复
            if (defined('MALL_SHOW_SEO')) {
                return;
            }
            return $this->mall('show', $data);
        } else {
            return parent::show($mod, $data, $page);
        }
    }


    public function mall($type, $data) {

        $title = '{title}';
        $keywords = '{keywords}';
        $description = '{description}';

        isset(\Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['title']) && \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['title'] && $title = \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['title'];
        isset(\Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['keywords']) && \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['keywords'] && $keywords = \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['keywords'];
        isset(\Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['description']) && \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['description'] && $description = \Phpcmf\Service::C()->mall_info['seo'][SITE_ID]['seo'][$type]['description'];

        $rep = new \php5replace($data);

        $seo = [];
        $seo['meta_title'] = $title;
        $seo['meta_title'] = preg_replace_callback('#{([A-Z_]+)}#U', array($rep, 'php55_replace_var'), $seo['meta_title']);
        $seo['meta_title'] = preg_replace_callback('#{([a-z_0-9]+)}#U', array($rep, 'php55_replace_data'), $seo['meta_title']);
        $seo['meta_title'] = str_replace($data['join'].$data['join'], $data['join'], $seo['meta_title']);

        $seo['meta_keywords'] = $keywords;
        $seo['meta_keywords'] = preg_replace_callback('#{([A-Z_]+)}#U', array($rep, 'php55_replace_var'), $seo['meta_keywords']);
        $seo['meta_keywords'] = preg_replace_callback('#{([a-z_0-9]+)}#U', array($rep, 'php55_replace_data'), $seo['meta_keywords']);


        $seo['meta_description'] = $description;
        $seo['meta_description'] = preg_replace_callback('#{([A-Z_]+)}#U', array($rep, 'php55_replace_var'), $seo['meta_description']);
        $seo['meta_description'] = preg_replace_callback('#{([a-z_0-9]+)}#U', array($rep, 'php55_replace_data'), $seo['meta_description']);
        $seo['meta_description'] = htmlspecialchars(dr_clearhtml($seo['meta_description']));

        return $seo;
    }


}