<?php
class dev_docbuilder_dd{
    public $__content = '';
    public $__tables_outline = array();

    public function export(){
        $this->export_database();
    }

    public function export_tables_outline() {
        $out = "数据库词典\n\n\n";
        $out .= "= 数据库tables列表 =\n";
        $columns_title = array('Name', 'Comment');
        $out .=$this->gen_table($columns_title, $this->__tables_outline)."\n\n";
        return $out;
    }

    private function get_all_apps(){
        $d = dir(APP_DIR);
        while (false !== ($entry = $d->read())) {
            if ($entry!='.' && $entry!='..') {
                if (is_dir(APP_DIR.'/'.$entry)) {
                    $apps[] = $entry;                                    
                }
            }
        }
        $d->close();
        return $apps;
    }

    public function export_database() {
        foreach($this->get_all_apps() as $app){
            $this->__content .= $this->export_app_tables($app);
        }
        $this->__content = $this->export_tables_outline().$this->__content;
    }

    public function output(){
        echo $this->__content;
    }

    private function export_table_header($table_name, $comment){
        $out = '= '.$table_name." =\n";
        $out .= sprintf("```\n%s\n```\n", $comment);
        return $out;
    }

    private function export_table_main($columns){
        $out = "- 表结构\n";
        $columns_title = array('colname','describe','type','null','extra','pkey');
        foreach($columns as $cname=>$row){
			if ($cname == 'disabled') {
				$row_comment = '是否失效';
			}elseif(!empty($row['comment'])) {
                $row_comment = $row['comment'];
            }elseif (!empty($row['label'])){
                $row_comment = $row['label'];
            }else{
				$row_comment = $cname;
			}

            if (is_array($row['type'])) {
                $row_comment_enum_describe = ' ';                
                foreach($row['type'] as $e_k => $e_v) {
                    
                    $row_comment_enum_describe .= $e_k.':'.$e_v.';';
                }
                $row_comment .= $row_comment_enum_describe;
            }
            $out_columns[] = array($cname
                               ,$row_comment
                               ,$row['realtype']
                               ,$row['required']?'Y':'N'
                               ,$row['extra']
                               ,$row['pkey']?'Y':'N'
                               );
        }

        $out .= $this->gen_table($columns_title,$out_columns)."\n";
        return $out;
    }
    

    private function export_table_index($indexes){
        if (empty($indexes)) {
            return;
        }
        $out = "- 索引\n";
        $columns_title = array('indexname', 'columns');
        foreach($indexes as $index_name => $index){
            $out_indexes[] = array(
                                   $index_name,
                                   implode($index['columns'], ' '),
                                   );
        }
        $out .= $this->gen_table($columns_title, $out_indexes);
        return $out;
    }
    
    public function export_app_tables($app_id){
        foreach(kernel::single('base_application_dbtable')->detect($app_id) as $name=>$item){
            $define = $item->load();
            $out .= sprintf("%s%s%s\n\n",
                           $this->export_table_header($item->real_table_name(), $define['comment']),
                           $this->export_table_main($define['columns']),
                           $this->export_table_index($define['index']));
            $this->__tables_outline[] = array(
                                            'name' => $item->real_table_name(),
                                            'comment' => $define['comment']);
        }
        return $out;
    }    
    
    function gen_table($titles,$rows){
        $out  = '';
        $out .= '|| '.implode(' | ',$titles)." ||\n";
        foreach($rows as $row){
            $out .=  '| '.implode(' | ',$row)." |\n";
        }
        return $out;
    }
   
}