<?php
/**
 * ShopEx licence
 *
 * @copyright  Copyright (c) 2005-2010 ShopEx Technologies Inc. (http://www.shopex.cn)
 * @license  http://ecos.shopex.cn/ ShopEx License
 */
 

class stats_data_storager
{
    /**
     * 构造方法，初始化此类的某些对象
     * @param object 此应用的对象
     * @return null
     */
    public function __construct($app)
    {
        $this->app = $app;
    }
    
    /**
     * 统计信息存储
     * @param string key value
     * @param array 数据
     */
    public function save($key='ORDERINFO', &$arr_data=array())
    {
        if (isset($arr_data) && $arr_data)
        {
            if ($arr_data['_u_make'] == 'font')
            {
                setcookie('S[SHOPEX_STATINFO]', json_encode($arr_data), 0, '/');
            }
            else
            {
                if (is_array($key))
                    $str_key = array_shift($key);
                else
                    $str_key = $key;
                   
                if ($this->app->getConf('SHOPEX_STAT_ADMIN'))
                {                        
                    $arr_info = unserialize($this->app->getConf('SHOPEX_STAT_ADMIN'));
                    
                    if ($arr_info)
                    {
                        if (isset($arr_info[$str_key]) && $arr_info[$str_key])
                        {
                            if (is_array($arr_info[$str_key]) && $arr_info[$str_key])
                                $arr_info[$str_key][count($arr_info[$str_key])] = $arr_data;
                            else
                                $arr_info[$str_key][0] = $arr_data;
                        }
                        else
                        {
                            $arr_info[$str_key][0] = $arr_data;
                        }
                        
                        $this->app->setConf('SHOPEX_STAT_ADMIN', serialize($arr_info));
                    }
                    else
                    {
                        $arr_info = array();
                        if (!isset($arr_info[$str_key]) || !$arr_info[$str_key])
                        {
                            $arr_info[$str_key] = array();
                        }
                        
                        $arr_info[$str_key][0] = $arr_data;
                        $this->app->setConf('SHOPEX_STAT_ADMIN', serialize($arr_info));
                    }
                }
                else
                {
                    $arr_info = array();
                    if (!isset($arr_info[$str_key]) || !$arr_info[$str_key])
                    {
                        $arr_info[$str_key] = array();
                    }
                    
                    $arr_info[$str_key][0] = $arr_data;
                    $this->app->setConf('SHOPEX_STAT_ADMIN', serialize($arr_info));
                }
            }
        }
    }
    
    /**
     * 统计信息的获取，参数为空时取到所有的信息
     * @param array 需要获取的信息的key
     * @return array 统计的信息
     */
    public function get($arr_keys=array())
    {
        $arr_storager_session = array();
        $arr_data = array();
        
        if ($_COOKIE['S']['SHOPEX_STATINFO'])
        {
            $arr_data['FRONT_STATS'] = json_decode($_COOKIE['S']['SHOPEX_STATINFO']);
            setcookie('S[SHOPEX_STATINFO]', '', time() - 3600);
        }
        else
        {
            $arr_data['FRONT_STATS'] = array();
        }
        
        if ($arr_keys)
        {
            if ($this->app->getConf('SHOPEX_STAT_ADMIN'))
            {
                $arr_storager_session = unserialize($this->app->getConf('SHOPEX_STA0T_ADMIN'));
                
                if ($arr_storager_session)
                {
                    foreach ($arr_keys as $key)
                    {
                        if (is_array($key))
                            $str_key = array_shift($key);
                        else
                            $str_key = $key;
                    
                        if (isset($arr_storager_session[$str_key]) && $arr_storager_session[$str_key])
                        {
                            if (is_array($arr_storager_session[$str_key]))
                            {
                                $arr_data['BACKEND_STATS'][$str_key] = array_shift($arr_storager_session[$str_key]);
                            }
                        }
                    }
                    
                    if (!$arr_data['BACKEND_STATS'])
                        $arr_data['BACKEND_STATS'] = array();
                }
                else
                {
                    $arr_data['BACKEND_STATS'] = array();
                }                
                
                $this->app->setConf('SHOPEX_STAT_ADMIN', serialize($arr_storager_session));
            }
            else
            {
                $arr_data['BACKEND_STATS'] = array();
            }
        }
        else
        {
            if ($arr_storager_session = $this->app->getConf('SHOPEX_STAT_ADMIN'))
            {
                $arr_data['BACKEND_STATS'] = $arr_storager_session;
            }
            else
            {
                $arr_data['BACKEND_STATS'] = array();
            }
        }
        
        return $arr_data;
    }
}