<?php
namespace Home\Controller;

use Think\Controller;


class DistributionController extends CommonController
{
    /**
     * 分销记录
     */
    public function index()
    {
        $uid = zhong_decrypt(I('post.app_user_id'));
        //总金额
        $info = M('distribution as d') -> field('COUNT(*) as count , sum(price) as sumprice')->where(['p_id'=>$uid])->find();

        //正在提现
        $now = M('withdrawal')->where(['uid'=>$uid,'status'=>['in',('0,1')]])->getField('sum(money)');
        //已提现
        $have = M('withdrawal')->where(['uid'=>$uid,'status'=>2])->getField('sum(money)');
        //可提现
        $balance = $info['sumprice'] - M('withdrawal')->where(['uid'=>$uid,'status'=>['in',('0,1,2')]])->getField('sum(money)');
        //本月返利
        $start=strtotime(date('Y-m-01 00:00:00'));
        $end = strtotime(date('Y-m-d H:i:s'));
        $where['time'] = array('between',array($start,$end));
        $where['p_id'] = zhong_decrypt(I('post.app_user_id'));
        $where['status'] = 0;
        $month = M('distribution')->where($where)->getField('sum(price)');
        //上月返利
        $lastmonth_start=mktime(0,0,0,date('m')-1,1,date('Y'));
        $lastmonth_end=mktime(0,0,0,date('m'),1,date('Y'))-24*3600;
        $cond['time'] = array('between',array($lastmonth_start,$lastmonth_end));
        $cond['p_id'] = zhong_decrypt(I('post.app_user_id'));
        $cond['status'] = 0;
        $lastmonth = M('distribution')->where($cond)->getField('sum(price)');
        //计算消费
        $consum = $this->getConsum($uid);

        $money = [
            'money'      => $info['sumprice'],
            'balance'    => $balance,
            'now' => $now,
            'have'     => $have,
            'month'    => $month,
            'lastmonth'=> $lastmonth,
            'selfConsum'=> $consum['selfConsum'],
            'childrenConsum'=> $consum['childrenConsum'],
        ];
        foreach($money as &$v){
            if($v == ''){
                $v = 0;
            }
        }
        S('balance'.$uid,$balance,180);

        $this->returnMessage( 1,'返回成功',$money );

    }

    /*
     * 获取会员消费金额
     */
    public function getConsum($id){
        $selfConsum = M( 'order' )->where( [ 'user_id' => $id  ,'order_status' => '4' ] )->getField( "SUM(price_sum)" );

        $cid = M('user')->field('id')->where(['p_id'=>$id])->select();
        $idstr = array_column($cid,'id');
        $children = M( 'order' )->where( [ 'user_id' => [ 'IN', $idstr ] ,'order_status' => '4' ] )->group( 'user_id' )->getField( "user_id,SUM(price_sum)" );
        $childrenConsum = array_sum($children);

        $data['selfConsum'] = $selfConsum?$selfConsum:0;
        $data['childrenConsum'] = $childrenConsum?$childrenConsum:0;

        return $data;
    }

    /**
     * 我的团队
     */
    public function Myteam()
    {
        $uid = zhong_decrypt(I('post.app_user_id'));

        $count =  M( 'user' )->where( [ 'p_id' => $uid ] )->getField( 'COUNT(*)' );
        if(!$count){
            $this->returnMessage( 0,'暂无下级',$count );
        }
        $users = M('user') -> where(['p_id' => $uid]) ->field('id,user_name,mobile,create_time')->select();
        foreach($users as &$v){
            $v['create_time'] = date("Y-m-d H:i",$v['create_time']);
        }
        $data['data'] = $users;
        $data['count'] = $count;


        $this->returnMessage( 1,'返回成功',$data );

    }

    public function getInfo()
    {

        if(!isset($_POST['id']) || empty($_POST['id'])){
            die;
        }
        $id = I('post.id','','intval');
        $data = M('user') -> where(['p_id' => $id])->field('id,nick_name')->select();
        if(empty($data)){
            die;
        }
        $this->ajaxReturn($data);
    }

    /**
     * @description 前台提现列表页
     */
    public function withdrawalList()
    {
        $uid = zhong_decrypt(I('post.app_user_id'));
        $data = M('withdrawal')->field('id,money,bank_num,create_time,status,drawal_id,last_time')->where([ 'uid' => $uid ])->order('id desc')->select();

        foreach($data as $k=>$v){
            switch($v['status']){
                case -1:
                    $data[$k]['status'] = '未通过';
                    break;
                case 0:
                    $data[$k]['status'] = '待审批';
                    break;
                case 1:
                    $data[$k]['status'] = '待打款';
                    break;
                case 2:
                    $data[$k]['status'] = '已打款';
                    break;
            }

            if($v['bank_num'] == 0){
                $data[$k]['type'] = '支付宝';
            }else{
                $data[$k]['type'] = '银行卡';
            }
            $data[$k]['create_time'] = date("Y-m-d H:i",$v['create_time']);
        }

        $this->returnMessage( 1,'返回成功',$data );
    }

    public function addWithdrawal()
    {
        $post = I( 'post.' );
        $post['uid'] = \zhong_decrypt( $post['uid'] );
        //支付宝银行卡有一个即可,金额不能为空
        if( !(float)$post[ 'money' ] || ( !$post[ 'bank_num' ] && !$post[ 'ali_account' ] ) ){
            $this->returnMessage( 0,'请将页面填写完整,支付宝与银行卡填写一个即可','');
        }
        //银行卡16 或19位数字
        if( $post[ 'bank_num' ] ) \preg_match( '/^[1-9](\d{15})|(\d{18})$/',$post[ 'bank_num' ] ) || $this->returnMessage( 0,'银行卡号不正确','');
        //支付宝账号 邮箱或者手机号码
        if( $post[ 'ali_account' ] ) \preg_match( '/([a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+)|(1\d{10})/',$post[ 'ali_account' ] ) || $this->returnMessage( 0,'支付宝账号不正确','');

        $balance = S('balance'.$post['uid']);
        if($post['money'] > $balance ){
            $this->returnMessage( 0,'超出可提现金额','');
        }

        //提交申请记录
        $status = $this->besInsert($post);
        if($status){
            $this->returnMessage( 1,'申请成功',$status);
        }else{
            $this->returnMessage( 0,'申请失败',$status);
        }

    }
    //保存返利申请数据到表
    public function besInsert($data)
    {
        $time                  = time();
        $data[ 'drawal_id' ]   = $this->guid($data['uid']);
        $data[ 'status' ]      = 0;
        $data[ 'create_time' ] = $time;
        $data[ 'last_time' ]   = $time;
        return M( 'withdrawal' )->add( $data );
    }

    public function guid()
    {
        $uuid = date('Ymd').substr(implode(NULL, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
        return $uuid;
    }

}