<?php
namespace Home\Controller;

//use Common\Model\OrderModel;
use Common\Tool\QRcode;
use Common\Tool\Extend\CURL;
use Home\Model\ClassModel;
use Home\Model\GroupModel;
use Home\Model\OrderModel;
use Think\Controller;
use Home\Model\IntegralUseModel;
use Common\Model\BaseModel;
use Home\Model\FreightModeModel;
use Home\Model\FreightsModel;
use Home\Model\FreightConditionModel;
use Common\Strategy\FreightContent;
use Home\Logical\Model\FreightSendAreaLogic;
use Common\Tool\Tool;
use Home\Logical\Model\FreightAreaLogic;
use Common\Tool\Extend\ArrayParse;

/**
 * 团购控制器
 */
class GroupController extends CommonController
{

    /**
     * 团活动首页列表
     * 必须满足两条件 1 库存大于开团人数
     *               2 团活动时间未结束的
     *
     */
    public function index()
    {
        $user_id = zhong_decrypt(I('post.app_user_id/s'));

         // $user_id = 3;
        $page    = I('post.page/d');
        if(empty($user_id)){
            $this->returnMessage(0,'请先登录','');
        }
         $field = "p.id,p.goods_id,p.title,p.price,p.group_person_num,p.end_time,s.price_market";
        $groupList = M('group')
                    ->alias('p')
                    ->join("db_goods s on p.goods_id=s.id")
                    ->where(['p.goods_num'=>['EGT','group_person_num'],'p.end_time'=>['gt',time()],'p.status'=>['eq',1]])
                    ->field($field)
                    ->order('p.update_time desc')
                    ->page($page,10)
                    ->select();

            // echo strtotime('2030-03-10 10:10:10');
            // var_dump(M('group')->getLastSql());
//        $goodsPid[] = M('goods')
//            ->where(['goods_id' =>['in',array_column($groupList,"goods_id")]])
//            ->getField('p_id');
//
//        $img[]['img'] = M('goods_images')
//            ->where(['goods_id' => ['in',$goodsPid]])
//           ->getField('pic_url');
        foreach ($groupList as $k => $v) {
            $goodsPid = M('goods')
                ->where(['id' =>$v['goods_id']])
                ->getField('p_id');
            $img['img'] = M('goods_images')
                            ->where(['goods_id' => $goodsPid])
                            ->getField('pic_url');
            $arr[]=array_merge($v,$img);
        }

        $this->isEmpty( $groupList );
        $this->returnMessage( 1,'获取成功',$arr );

    }
    /**
     * 根据团活动id  判断团活动是否已结束
     */
    public function isGroupOver($id)
    {
        $groupObj = new GroupModel();
        $groupDetail = $groupObj->where(['id'=>$id,'end_time'=>['gt',time()]])->find();

        if(empty($groupDetail)){
            $this->returnMessage(0,'团活动已结束','');
        }
    }


    /**
     * 团活动详情   参团、开团详情、我的团购详情（三个页面）  .前台需要写出团活动结束倒计时
     */
    public function groupDetail()
    {
        // $user_id = zhong_decrypt(I('post.app_user_id'));
         $user_id = 3;
        $groupId = I('post.id');
        // $groupId = 2;
        $_SESSION['user_id'] = $user_id;
       if(empty($user_id)){
           $this->returnMessage(0,'请先登录','');
       }
        $this->isGroupOver($groupId);

        $groupObj = new GroupModel();
        //列表页进入增加点击量
        if(!empty($groupId)){
            $res = $groupObj->where(['id'=>$groupId])->setInc ('look_num',1);
        }

        //团活动商品详情
        $groupGoodsDetail = $groupObj->getDetail($groupId);
        //团活动图片  一张
        $goodsPid    = M('goods')->where(['id' =>$groupGoodsDetail['goods_id']])->getField('p_id');
        $goodsImg    = M('goods_images')->field('pic_url')->where(['goods_id'=>$goodsPid])->select();
        $detail      = M('goods_detail')->where(['goods_id'=>$goodsPid])->getField('detail');
        $groupGoodsDetail['detail'] = preg_replace('/(<img.+?src=")(.*?)/','$1'.__SERVER__.'$2', html_entity_decode( $detail ));
        //显示这个团活动的最先支付的一个团购主订单数据
        $showOrderData =  $groupObj->showOrder($groupId);
        $groupGoods = [
            'groupGoodsDetail'=> $groupGoodsDetail,
            'goodsImg'        => $goodsImg,
            'showOrderData'     => $showOrderData,
        ];

        $this->isEmpty( $groupGoods );
        $this->returnMessage( 1,'获取成功',$groupGoods );

    }
    /**
     * 参团限制   1团单有效期  2参团过活动（不包括开团）
     */
    public function LimitJoinGroup($orderId){
        $arr = M('order')
            ->field("group_id,overdue_time")
            ->where(['id'=>$orderId,'is_host'=>1])
            ->find();
        if(empty($arr)){
            $this->returnMessage(0,'信息错误','');
        }
        if(time() >= $arr['overdue_time'] ){
            $this->returnMessage(0,'该订单已失效','');
        }
        if($arr['group_id']){

            $res = M('order')
                ->where(['user_id'=>$_SESSION['user_id'],'group_id'=>$arr['group_id'],'group_status'=>['eq',1],'is_host'=>['neq',1]])
                ->select();
            if($res){
                $this->returnMessage(0,'您已经参加过了该活动，还未结束','');
            }
        }else{
            $this->returnMessage(0,'信息错误','');
        }
    }
    /**
     * 直接参团  邀请好友参团
     *
     */
    public function joinGroup(){
        $user_id = zhong_decrypt(I('post.app_user_id'));
        $groupId = I('post.group_id');   //带这个参数，说明参团 增加点击量
        $orderId    = I('post.id');  //主团单id 或者我的团单id
        $_SESSION['user_id'] = $user_id;
        if(empty($user_id)){
            $this->returnMessage(0,'请先登录','');
        }
        //参团验证
        $arr = M('order')
            ->field("group_id,overdue_time,group_status")
            ->where(['id'=>$orderId,'is_host'=>1])
            ->find();
        if(empty($arr)){
            $this->returnMessage(0,'信息错误','');
        }
        if(empty($arr['group_id'])){
            $this->returnMessage(0,'信息错误','');
        }
        //增加点击量
        $groupObj = new GroupModel();
        if(!empty($groupId)){
            $res = $groupObj->where(['id'=>$groupId])->setInc ('look_num',1);
        }else{
            $groupId=M('order')->where(['id'=>$orderId])->getField("group_id");
        }
        //根据订单id获取成功参团成员详情
        $userData = $groupObj->getGroupOrderAllUser($orderId);

        //根据订单id获取商品数据以及团单情况
        $goodsData = $groupObj->getGroupGoods($orderId);

        //返回订单状态    (在此方法主要配合前端使用)
        $orderModel  = new OrderModel();
        $orderStatus = $orderModel->myGroupOrderDetails($orderId);

        //显示不同按钮 分享 参团 查看
        $userRes = M('order')->field("order_status,group_status")->where(['user_id'=>$_SESSION['user_id'],'group_id'=>$groupId])->select();
        $oStatus = array_column($userRes,"order_status");
        $gStatus = array_column($userRes,"group_status");

        if(in_array("0",$oStatus) || in_array(1,$gStatus)){  //查看
            $user['is_user'] = "2";  //参加过该活动未完成的，只能查看
        }elseif(in_array($user_id,array_column($userData,"id"))){
            $user['is_user'] = "1";  //如果该用户在该团中，分享
        }else{
            $user['is_user'] = "0";  //我要参团
        };



//        //还差几人以及团购剩余时间
//        $group_person_num = M('group')->where(['id' => $groupId])->getField("group_person_num");
//        $orderData = M('order')->field("pid,group_person_num,is_host,overdue_time")->where(['id' => $orderId])->find();
//        if($orderData['is_host'] == 1){
//            $tp['lack_person'] = $group_person_num - $orderData['group_person_num'];
//            $tp['time'] = time() - $orderData['overdue_time'];
//        }else{
//            $tmp = M('order')->field("group_person_num,overdue_time")->where(['id' => $orderData['pid']])->find();
//            $tp['lack_person'] = $group_person_num - $tmp['group_person_num'];
//            $tp['time'] = time() - $tmp['overdue_time'];
//        }

        $groupGoods = [
            'goodsData'   => $goodsData,
            'userData'   => $userData,
            'orderStatus'     => $orderStatus,
            'isUser'     => $user
        ];

        $this->isEmpty( $groupGoods );
        $this->returnMessage( 1,'获取成功',$groupGoods );

    }



    /**
     *  发起开团 团购订单支付   I('post.group_id')需再提交两个参数group_id  order_id（不用json数组goods中传）
     *                      参团时主订单order_id，存入了缓存，下页面用到
     */
    public function buyGroup()
    {
        if(IS_POST){
            $user_id=zhong_decrypt(I('post.app_user_id'));
            $orderId = I('post.order_id');
            $groupId=I('post.group_id');
            $_SESSION['user_id']=$user_id;
            $_SESSION['group_id']=$groupId;

            // 用户开团限制
            $groupObj = new GroupModel();
            $res=$groupObj->startGruopLimit($groupId);
            if($res === false){
                $this->returnMessage(0,'您已经参加了该活动,还未结束！',''); die;
            }

            $list=M('user_address')
                ->field(
                    'id,realname,mobile,prov,city,dist,address'
                )
                ->where(
                    ['user_id'=>$user_id]
                )
                ->find();
            if(empty($list)){
                $this->returnMessage(0,'请完善收货地址','');
            }

            $goods_model=M('goods');
            $goods_images_model=M('goods_images');
            $goods=json_decode($_POST['goods'],true);
            $this->isGroupOver($groupId);
            $goods_num=0;
            $total_price=0;
            $integral=0;
            $goods_id = '';
            foreach($goods as $k=>$vo)
            {
                $goods_id .= $vo['id'].',';
                $goods[$k]['attr']=$this->selfAttr($vo['id']);
                $fatherId=$goods_model
                    ->where(array('id'=>$vo['id']))
                    ->getField('p_id');
                $fatherImg=$goods_images_model
                    ->where(array('goods_id'=>$fatherId))
                    ->getField('pic_url');
                $goods[$k]['fatherImg']=$fatherImg;
                $price=$goods_model
                    ->where(array('id'=>$vo['id']))
                    ->field('price_member,title,send_address,freights_id,good_rebate,self_rebate,weight')
                    ->find();
//                $goods[$k]['title']=$price['title'];
                $goods[$k]['title']=M('group')
                    ->where(['id'=>$groupId,'goods_id'=>$vo['id']])
                    ->getField('title');;
                $goods[$k]['send_address']=$price['send_address'];

                //团购商品时 1修改为团购价  2总价等于单价(数量为一个)    ---meng
                if($groupId){
                    $priceTmp=M('group')
                        ->where(['id'=>$groupId,'goods_id'=>$vo['id']])
                        ->getField('price');
                    $goods[$k]['price_member']=$priceTmp;
                    $total_price=$priceTmp;
                }


                //拼接session
                $goodsData[$vo['id']]['goods_id'] = $vo['id'];
                $goodsData[$vo['id']]['goods_price'] = $priceTmp;
                $goodsData[$vo['id']]['goods_num'] = $vo['num'];
                $goodsData[$vo['id']]['good_rebate'] = $price['good_rebate'];
                $goodsData[$vo['id']]['self_rebate'] = $price['self_rebate'];
                $goodsData[$vo['id']]['freights_id'] = $price['freights_id'];
                $goodsData[$vo['id']]['weight'] = $price['weight'];
                $goodsData[$vo['id']]['send_address'] = $price['send_address'];
                $goodsData[$vo['id']]['ware_id'] = $price['send_address'];
                $goodsData[$vo['id']]['user_id'] = $user_id;
                $goodsData[$vo['id']]['space_id'] = M('spec_goods_price')->where(array('goods_id' =>$vo['id']))->getField('id');//商品规格


                $goodsData[$vo['id']]['space_id']['group_id'] = $groupId;             //团购id 必填参数
                $goodsData[$vo['id']]['space_id']['order_id'] = $orderId;             //主订单id 可选

            }
            S('buyByCartGoodsGroup'.$user_id, $goodsData);

            $region_model=M('region');
            $address=M('user_address')
                ->where(array('user_id'=>$user_id,'status'=>1))
                ->field('id,realname,mobile,prov,city,dist,address,status')
                ->find();//地址
            //如果没有默认地址选最新添加的
            if(!$address['id']){
                $address=M('user_address')
                    ->field('id,realname,mobile,prov,city,dist,address,status')
                    ->where(array('user_id'=>$user_id))
                    ->order('id desc')
                    ->select()[0];
            }

            $address['prov']=$region_model
                ->where(array('id'=>$address['prov']))
                ->getField('name');
            $address['city']=$region_model
                ->where(array('id'=>$address['city']))
                ->getField('name');
            $address['dist']=$region_model
                ->where(array('id'=>$address['dist']))
                ->getField('name');


            //查询发货仓
            $sendAddress =M('goods')->field('send_address')->where(['id'=>['IN',rtrim($goods_id,',')]])->group('send_address')->select();
            foreach($sendAddress as $add_vo){
                $sendAddr .= $add_vo['send_address'].',';
            }
            $sendAddrData = M('send_address')->field('id,stock_name')->where(['id'=>['IN',rtrim($sendAddr,',')]])->select();

            //团购商品时 改变数据


            $data=array(
                'goods'=>$goods,
                'total_price'=>$total_price,
                'address'=>$address,
                'send_address' =>$sendAddrData
            );
            $this->returnMessage(1,'获取成功',$data);
        }
    }

    //防止表单多次提交
    public function getcheck(){
        $user_id=zhong_decrypt(I('post.app_user_id'));
        $check = mt_rand(0,1000000);
        S('check'.$user_id,$check);
        $this->returnMessage(1,'获取成功',$check);
    }


    //计算运费
    public function sumFreight2()
    {

        // $user_id  = zhong_decrypt(I('post.app_user_id'));\
        $user_id = 3;
        // $addressId = I('post.addressId');
        $addressId   = 95;
        $goods = S('buyByCartGoodsGroup'.$user_id);
        $freiTotal = 0;
        $flag = [];

        foreach($goods as $k=>&$v){
            S('user_goods_monery1'.$user_id,$v['goods_price']*$v['goods_num']);
            S('alone_goods_money1'.$user_id,$v['goods_price']*$v['goods_num']);
            S('user_goods_number1'.$user_id,$v['goods_num']);
            S('user_goods_weight1'.$user_id,$v['weight'] * $v['goods_num']);
            $_SESSION['user_goods_number1'] = $v['num'];
            //获取收货地址
            $areaId = M('user_address')->field('city,prov')->where(['id'=>$addressId])->select()[0];

            $this->promptPjax($areaId, '请选择收货地址');

            //首先获取 此运送方式的所有运费设置
            $freightModel = BaseModel::getInstance(FreightModeModel::class);
            $freightModeList = $freightModel->getShipModeConfig2($v['freights_id']);

            $this->promptPjax($freightModeList, '运费方式没有对应的收费标准~~~');

            Tool::connect('parseString');

            //筛选是否在运送地区内
            $freightSendAreaModel  = new FreightSendAreaLogic($freightModeList);

            $freightSendAreaModel->setAreaId($areaId);

            $freightModeInAreaList = $freightSendAreaModel->isInclude($freightModel);


            $this->promptPjax($freightModeInAreaList, '该快递不包含该运送地区');

            //筛选是否包邮
            $freightConditionModel = BaseModel::getInstance(FreightConditionModel::class);

            $freightConditionList  = $freightConditionModel->IsInFreeShipingArea($freightModeInAreaList, $freightModel);


            //获取运费模板数据
            $freightTemplateModel = BaseModel::getInstance(FreightsModel::class);

            $freightConditionList = $freightTemplateModel->isFreeShipping($freightConditionList, $freightModel);


            //是否在包邮地区内
            $freightAreaModel = new FreightAreaLogic($freightConditionList);

            $freightAreaModel->setAreaId($areaId);

            $freightMonery  = $freightAreaModel->isInclude(); //在包邮地区内

            if (empty($freightMonery)) {

                $freightMonery = $freightTemplateModel->isFreeShipping($freightModeInAreaList, $freightModel);

            }
            $receive = array();

            $freightMonery = (new ArrayParse([]))->oneArray($receive, $freightMonery);

            // 计算运费
            $type = FreightContent::parseCall($receive[FreightsModel::$valuationMethod_d]);

            $obj = FreightContent::getInstance($type, $receive)->newInstance();

            $obj->setDiscount(100);

            $money = $obj->acceptCash1();

//            $freiTotal += $money;
//
//            $goods[$k]['freiMonery'] = $money;

            //flag过滤同仓库商品，并取最低运费
            if(!array_key_exists($v['send_address'],$flag)){
                $flag[$v['send_address']] = ['money'=>$money,'id'=>$v['id'],'key'=>$k];
                $v['freiMonery'] = $money;
                $freiTotal += $money;
            }else{
                if($flag[$v['send_address']]['money']>$money){
                    $v['freiMonery'] = $money;
                    $goods[ $flag[ $v['send_address'] ]['key'] ]['freiMonery'] = 0;

                    $num = $flag[$v['send_address']]['money'] - $money;
                    $freiTotal = $freiTotal - $num ;
                }else{
                    $v['freiMonery'] = 0 ;
                    $freiTotal += 0;
                }
            }

        }

        S('buyByCartGoodsGroup'.$user_id, $goods);

        $this->ajaxReturnData(['money' => $freiTotal]);

    }




    /**
     * 支付配送     需要多传两个参数group_id  order_id
     */
    public function orderBegin(){
        if(IS_POST){
            //防止表单多次提交
            $user_id=zhong_decrypt(I('post.app_user_id'));
             // $user_id = 3;
            $_SESSION['user_id'] = $user_id;
            $check  = I('post.gcheck');
            // $check = '28560';

            $scheck = S('check'.$user_id);

            if($check == $scheck){
                S('check'.$user_id,null);
            }else{
                $this->returnMessage(3,'请勿多次提交','');
            }
            $order_goods_model = M('order_goods');
            $order_model = M('order');
            $spec_goods_price=M('spec_goods_price');
            $cart_model = M('goods_cart');
            $db_coupon_list=M('coupon_list');
            $goodsModel=M('goods');
            if($user_id == 0 || $user_id == ''){
                $this->returnMessage(0,'请登录','');
            }else{
                $_SESSION['user_id'] = $user_id;
            }
            //团单验证
            // $groupId=I('post.group_id');
            $groupId = 4;
            $_SESSION['group_id']=$groupId;
            if(empty($groupId)) {
                $this->returnMessage(0,'信息错误','');
            }
            //验证团情况
            $this->isGroupOver($groupId);
            $groupObj = new GroupModel();

//            $res=$groupObj->isJoinGroupOrder();     //用户有无权限 开、参团
//            if(empty($res)){
//                $this->returnMessage(0,'您已经参加了该活动！',''); die;
//            }

//            $endTime = $groupObj->where(['id'=>$groupId])->getField('end_time');
            //如果是参团,验证参团数据
            $orderId = I('post.order_id','');

            if(!empty($order_id)){
                $hostOrderData = M('order')->where(['id'=>$orderId,'group_id'=>$groupId,'order_status'=>1])->find();
                if(empty($hostOrderData)){
                    $this->returnMessage(0,'信息错误','');
                }
                //参团限制
                $this->LimitJoinGroup($order_id);
                //判断团活动库存，判断主团单人数
                $groupGoods = $groupObj->where(['id'=>$groupId])->find();
                if($groupGoods['goods_num'] <= 0){
                    $this->returnMessage(0,'库存不足，请选购其他商品！','');
                    exit;
                }
                $personNum = (int)$groupGoods['group_person_num'] - (int)$hostOrderData['group_person_num'];
                if($personNum <= 0){
                    $this->returnMessage(0,'此团人数已满','');
                    exit;
                }
            }
           else{   //开团，判断活动是否结束
               if(time() >= $endTime){
                   $this->returnMessage(0,'团活动已结束','');
                   exit;
               }
           }
                 // I('post.address_id')
            $address = M('user_address')
                ->field(
                    'id,realname,mobile,prov,city,dist,address'
                )
                ->where(
                    ['id'=>I('post.address_id'),'user_id'=>$user_id]
                )
                ->find();
            if(empty($address)){
                $this->returnMessage(0,'收货地址有误','');
            }
           $post = $_POST;
            // $json = array('num'=>1,'id'=>'3433','goods_price'=>'100.00','send_address'=>null,);
            // $c = json_encode($json);

             // $_POST['goods']
            $post['goods'] = json_decode($_POST['goods'],true);

            $goods = S('buyByCartGoodsGroup'.$user_id);
            S('buyByCartGoodsGroup'.$user_id,null);
            // $goods[] = array('goods_id'=>"3433",'goods_price'=>"100.00",'goods_num'=>1,'good_rebate'=>NULL,'self_rebate'=>NULL,'freights_id'=>NULL,'weight'=>NULL,'send_address'=>null,'ware_id'=>NULL,'user_id'=>'3','space_id'=>4426);
            //处理数据
            $sendAddress = array_column($goods,'send_address');
            //构造加入订单详情数据          核实价格
            $orderGoodssmall = (new OrderModel())->orderGoodsSmall($groupId);
            
            //调整数据结构
            $ss = '';
            $price = 0;
            $rebate = 0;
            $selfrebate = 0;
            $freight = 0;
            foreach($goods as $gk=>$gv){
                $goodsData [$gv['send_address']]['goods'][] = $gv;
                if($ss != $gv){
                    unset($price);
                    unset($rebate);
                    unset($selfrebate);
                    unset($freight);
                }
//              $price += $gv['goods_num']*$gv['goods_price'] + $gv['freiMonery'];           ---meng  注释
                $price += $orderGoodssmall['goods_price']+ $gv['freiMonery'];
                $rebate += $gv['goods_num']*$gv['good_rebate'] ;
                $selfrebate += $gv['goods_num']*$gv['self_rebate'] ;
                $freight += $gv['freiMonery'] ;
                $goodsData [$gv['send_address']]['price'] += $price;
                $goodsData [$gv['send_address']]['rebate'] += $rebate;
                $goodsData [$gv['send_address']]['self_rebate'] += $selfrebate;
                $goodsData [$gv['send_address']]['freiMonery'] += $freight;
                $ss = $gv;
            }

            foreach($sendAddress as $k=>$v){
                $data[$v]['order_sn_id'] = $this->toGUID();
                // $data[$v]['address_id'] = I('post.address_id');//收货地址
                $data[$v]['address_id'] = I('post.address_id');
                $data[$v]['user_id'] = $user_id; //购买者
                $data[$v]['create_time'] = time();          //创建时间
                $data[$v]['order_status'] = 0;//默认为0：未支付状态     //订单状态
                $data[$v]['pay_type'] = I('post.pay_type');//支付类型
                if(!empty(I('post.shipping'))){

                    $data[$v]['shipping']=I('post.shipping');//配送方式

                }else{

                    $shipping=$this->_getShipping($user_id,"");
                    $data[$v]['shipping']=$shipping[0]['name'];//默认配送方式

                }
                $data[$v]['remarks'] = I('post.remarks');//备注
                $data[$v]['translate'] =I('post.translate');//是否需要发票
                $data[$v]['shipping_monery'] =$goodsData[$v]['freiMonery'];//订单运费
                $data[$v]['platform']=2;//1:代表pc,2:代表移动
                $data[$v]['goods'] = $orderGoodssmall;
//                $data[$v]['goods_rebate'] = $goodsData[$v]['rebate']; //返利金
//                $data[$v]['self_rebate'] = $goodsData[$v]['self_rebate']; //返利金
                $data[$v]['price_sum'] = $goodsData[$v]['price'];                                 //修改  订单的总价
                // $data[$v]['ware_id'] = $v;                       仓库地址（可以不要）   

                $data[$v]['group_id'] = $groupId;                  //团订单  只有一个商品的
                if ($orderId){   //参团
                    $data[$v]['pid'] = $orderId;                       //团订单  只有一个商品的
                }else{           //开团
                    //$data[$v]['overdue_time'] = time() + 259140;           //团订单  只有一个商品的 团单过期时间72小时
                    $data[$v]['is_host'] = 1;           //团订单  只有一个商品的 团单过期时间72小时
                }

            }

            //开启事物
            $Model = M();
            $Model->startTrans();
            if($orderId){
                $orderRes = $order_model->lock(true)->where(['id'=>$orderId])->find();//加锁查询
            }else{
                $groupRes = $groupObj->lock(true)->where(['id'=>$_SESSION['group_id']])->find();//加锁查询
            }
            $str = '';
            $priceSum = 0;

            foreach($data as $k=>$v){
                $order_big = $order_model->add($v);
                if ($order_big) {              //添加成功--开始生成小订单号
                    $arr2['order_id'] = $order_big;            //订单号
                    $arr2['price_sum'] = $v['price_sum'];  //订单总价
                    $arr2['goods_num'] = 1;
                    $arr2['user_id'] = $v['user_id'];;
                    $arr2['ware_id'] = $v['ware_id'];;

                    $order_small = $order_goods_model->add(array_merge($v['goods'],$arr2));


                }
                $str .= $order_big.',';
                $priceSum += $v['price_sum'];
            }

            //修改库存
            $res1 = $groupObj->where(['id'=>$_SESSION['group_id']])->getField('goods_num');
            if($res1>=1){   //库存大于1
                $res2 = $groupObj->where(['id'=>$_SESSION['group_id']])->setDec('goods_num',1);     //团单每人限购一件
            }else{
                $Model->rollback();
                $this->returnMessage(0,'下单失败,库存不足','');
            }

            $str = rtrim($str,',');

            $payOrder['pay_order_id'] = $this->toGUID();
            $payOrder['order_id_str'] = $str;
            $payOrder['create_time'] = time();
            $payOrder['price_sum'] = implode("",array_column($data,'price_sum'));
           
            $payId = M('order')->add($payOrder);
        //修改订单状态 成为辅助订单
            if($payId && $order_small ){
                $Model->commit();
                $this->returnMessage(1,'创建订单成功',$payId);
            }else{
                $Model->rollback();
                $this->returnMessage(0,'创建订单失败','');
            }
        }
    }
    /**
     * 获取团购商品海报图
     */

    public function getSharePicture(){
        $userId = \zhong_decrypt( I( 'get.app_user_id/s' ) );
        $groupId = I('get.group_id/d');
        $orderId = I('get.id/d');
        if(!$userId || !$groupId || !$orderId){
            $this->returnMessage(0,'获取失败','');
        }

        //生成二维码
        $url2    = M( 'system_config' )->where( 'id=12' )->getField( 'config_value' );
        $url2    = unserialize( $url2 );
        $pcUrl = M('system_config')->where(['parent_key'=>'pc_url'])->getField('config_value');
        $pc_url = unserialize($pcUrl)['pcUrl'];

        $path = $pc_url.'/Uploads/group/'.$groupId;
        if(!file_exists($path)){
            mkdir($path,0777,true);
        }
        //图片资源
        $backImg = $pc_url.'/Public/conf/pintuanbk.jpg';
        $new = $path.'/'.$groupId.'-'.$orderId.'-'.I( 'get.app_user_id/s' ).'.jpg';
        if(file_exists($new)){
            $res = '/Uploads/group/'.$groupId.'/'.$groupId.'-'.$orderId.'-'.I( 'get.app_user_id/s' ).'.jpg';
            $this->returnMessage(1,'获取成功',$res);
        }
        $codeImg = $path.'/'.$groupId.'-'.$orderId.I( 'get.app_user_id/s' ).'.jpg';
        $url = 'http://'.$url2[ 'internet_url' ].'/mobile/index.html#/groupDetail?id=' . $orderId . '&group_id='.$groupId;
        QRcode::png( $url,$codeImg,QR_ECLEVEL_H,4 );

        //拼接数据
        $goodsInfo = M('group')->field('id,title,goods_id,price')->where(['id'=>$groupId])->find();
        $goodsData = M('goods')->field("price_market,p_id")->where(['id'=>$goodsInfo['goods_id']])->find();
        $goodsImg = M('goods_images')->where(['goods_id'=>$goodsData['p_id']])->getField('pic_url');

        $backImg = $pc_url.'/Public/conf/pintuanbk.jpg';
        $new = $path.'/'.$groupId.'-'.$orderId.'-'.I( 'get.app_user_id/s' ).'.jpg';

        $data = [
            'title' =>$goodsInfo['title'],
            'price_market'  => '￥'.$goodsData['price_market'],
            'price_member'  => '￥'.$goodsInfo['price'],
            'goods_img'     => 'http://'.$url2[ 'internet_url' ].$goodsImg,
            'new_img'       => $new,
        ];

        $result =D('GoodsImages')->createImg($data,$codeImg,$backImg);

        $res = '/Uploads/group/'.$groupId.'/'.$groupId.'-'.$orderId.'-'.I( 'get.app_user_id/s' ).'.jpg';

        $this->returnMessage(1,'获取成功',$res);

    }
    

    /**
     * 人中心团订单详情展示
     *
     *
     */
    public function joinGroupOne(){
        $user_id = zhong_decrypt(I('post.app_user_id'));
        $groupId = I('post.group_id');   //带这个参数，说明参团 增加点击量
        $orderId    = I('post.id');  //主团单id 或者我的团单id
        $_SESSION['user_id'] = $user_id;
        if(empty($user_id)){
            $this->returnMessage(0,'请先登录','');
        }

        $groupObj = new GroupModel();
        //根据订单id获取成功参团成员详情
        $userData = $groupObj->getGroupOrderAllUser($orderId);


        //根据订单id获取商品数据以及团单情况
        $goodsData = $groupObj->getGroupGoods($orderId);

        //个人中心拼购详情需要参数  ---1，订单状态 2，团单状态
        $orderModel  = new OrderModel();
        $orderStatus = $orderModel->myGroupOrderDetails($orderId);



//        //还差几人以及团购剩余时间
//        $group_person_num = M('group')->where(['id' => $groupId])->getField("group_person_num");
//        $orderData = M('order')->field("pid,group_person_num,is_host,overdue_time")->where(['id' => $orderId])->find();
//        if($orderData['is_host'] == 1){
//            $tp['lack_person'] = $group_person_num - $orderData['group_person_num'];
//            $tp['time'] = time() - $orderData['overdue_time'];
//        }else{
//            $tmp = M('order')->field("group_person_num,overdue_time")->where(['id' => $orderData['pid']])->find();
//            $tp['lack_person'] = $group_person_num - $tmp['group_person_num'];
//            $tp['time'] = time() - $tmp['overdue_time'];
//        }

        $groupGoods = [
            'goodsData'   => $goodsData,
            'userData'   => $userData,
            'orderStatus'     => $orderStatus,
        ];

        $this->isEmpty( $groupGoods );
        $this->returnMessage( 1,'获取成功',$groupGoods );

    }

}