<?php
namespace Home\Controller;

use Common\Tool\Extend\CURL;
use Home\Model\ClassModel;
use Home\Model\GroupModel;
use Home\Model\OrderModel;
use Think\Controller;
use Home\Model\IntegralUseModel;
use Common\Model\BaseModel;
use Home\Model\FreightModeModel;
use Home\Model\FreightsModel;
use Home\Model\FreightConditionModel;
use Common\Strategy\FreightContent;
use Home\Logical\Model\FreightSendAreaLogic;
use Common\Tool\Tool;
use Home\Logical\Model\FreightAreaLogic;
use Common\Tool\Extend\ArrayParse;

/**
 * 团购订单控制器
 */
class GroupOrderController extends CommonController
{
    /**
     * 个人中心，拼购订单      ---meng
     */
    public function index(){
        // $user_id=zhong_decrypt(I('post.app_user_id'));

        $user_id = zhong_decrypt('MDAwMDAwMDAwMIGCb3M');
        $groupStatus=I('post.status');
       
        $page = I('post.page'); 
        if ( empty( $user_id ) ) {
            $this->returnMessage( 0,'请先登录','' );
        }

        if($groupStatus == 0){   //未付款
            $orderLists= M('order')
                ->where(['user_id'=>$user_id,'order_status'=>'0','pid'=>['egt',0],'group_id'=>['gt',0]])
                ->select();

        }else{                       //其他状态
            $orderLists= M('order')
                ->where(['user_id'=>$user_id,'group_status'=>$groupStatus,'pid'=>['egt',0],'group_id'=>['gt',0]])
                ->select();
        }

        $orderModel = new OrderModel();
       
        if($page == 1){
            $orderData  = $orderModel->getMyGroupGoods($orderLists);
        }else{
            $this->returnMessage( 1,'已经获取全部数据','');
        }
        


        $this->isEmpty( $orderData );
        $this->returnMessage( 1,'获取成功',$orderData);
    }


    /**
     * 获取图片
     */
    private function selfImg($goods_model,$goods_images_model,$goods_id){
        $fatherId=$goods_model
            ->where(array('id'=>$goods_id))
            ->getField('p_id');
        $fatherImg=$goods_images_model
            ->where(array('goods_id'=>$fatherId))
            ->getField('pic_url');
        return $fatherImg;
    }
    /**
     * 获取本产品的属性
     */
    private function selfAttribute($goods_model,$goods_id){
        $goods_spec_item_model=M('goods_spec_item');
        $join='db_goods_spec ON db_goods_spec.id=db_goods_spec_item.spec_id';
        $join1='db_spec_goods_price ON db_spec_goods_price.goods_id=db_goods.id';
        $chlidattr=$goods_model
            ->join($join1)
            ->field('key')
            ->where(array('db_goods.id'=>$goods_id))
            ->find();
        $chlidattra=explode("_",$chlidattr['key']);//得到每个子类有的产品属性
        $condition['db_goods_spec_item.id']=array('in',$chlidattra);
        $chlidattrdetal=$goods_spec_item_model
            ->join($join)
            ->field('item,name')
            ->where($condition)
            ->select();
        return $chlidattrdetal;
    }
    /**
     * 团购订单 订单详情显示  ---0102     ---meng
     *
     *
     */
    public function groupCouponInformation()
    {
        if(IS_POST){
            $order_id=I('post.order_id');
            $goods_model=M('goods');
            $goods_images_model=M('goods_images');
            $order_model=M('order');
            $order_goods_model=M('order_goods');
            $db_user_address=M('user_address');
            $region_model=M('region');

            //获取得大订单号
            $result=$order_model
                ->where(array('id'=>$order_id))
                ->field(
                    'id,order_sn_id,address_id,remarks,pay_type,order_type,price_sum,pay_time,shipping,shipping_monery,create_time,pay_time,delivery_time,express_id,exp_id,coupon_amount,order_status,group_id'
                )
                ->find();

            //根据大订单号获取小订单号
            $list=$order_goods_model
                ->where(
                    array('order_id'=>$result['id'])
                )
                ->field(
                    'goods_id,goods_num,goods_price'
                )
                ->find();
            $result['goods_id'] = $list['goods_id'];
            $result['goods_num'] = $list['goods_num'];
            $result['goods_price'] = $list['goods_price'];
            //title img 属性
            $result['img'] = $this->selfImg($goods_model,$goods_images_model,$list['goods_id']);
            $result['attribute'] = $this->selfAttribute($goods_model,$list['goods_id']);
            $result['title'] = M('group')->where(['id'=>$result['group_id']])->getField("title");

            //拼接收货地址
            $exp_name = M('express')->where(['id'=>$result['exp_id']])->getField('name');
            $result['shipping'] = $exp_name . ' : ' . $result['express_id'];   // 快递及单号


            //获取收货人详情地址信息等
            $address=$db_user_address
                ->field(
                    'realname,mobile,prov,city,dist,address'
                )
                ->where(
                    array('id'=>$result['address_id'])
                )
                ->find();
            $address['prov']=$region_model->where(array('id'=>$address['prov']))->getField('name');
            $address['city']=$region_model->where(array('id'=>$address['city']))->getField('name');
            $address['dist']=$region_model->where(array('id'=>$address['dist']))->getField('name');
            $result['address_id']=$address;
            //获取发票类型
            $result['invoice']=M('invoice')
                ->where(
                    ['order_id'=>$order_id]
                )
                ->getField('invoice_type');

            if($result['pay_type']=="0"){
                $result['pay_type_z']='未支付';
            }elseif($result['pay_type']=="1"){
                $result['pay_type_z']='微信支付';
            }elseif($result['pay_type']=="2"){
                $result['pay_type_z']='支付宝支付';
            }elseif($result['pay_type']=="3"){
                $result['pay_type_z']='银联支付';
            }elseif($result['pay_type']=="4"){
                $result['pay_type_z']='余额支付';
            }

//            //判断是否关闭售后
//            $result['close_after_sale'] = $this->closeAfterSale($result['create_time']);
//            //判断是否售后
//            if($result['order_status']>6){
//                $result['return_exp'] = 1;
//                $res = M('order_return_goods')->where(['order_id'=>$result['id']])->getField('exp');
//                if($res){
//                    $result['return_exp'] = 0;
//                }
//            }

            if(!empty($result))
                $this->returnMessage(1,'获取成功',$result);
            else
                $this->returnMessage(0,'暂无数据',"");
        }

    }


    /**
     *  订单列表 - 团购订单列表详情  ---显示团成员      ---meng
     */
//    public function groupCouponInformation()
//    {
//        $orderId=I("get.order_id");
//        $orderModel = new OrderModel();
//        $groupOrderUserData = $orderModel->getGroupOrderUser($orderId);  //全团成员简要
//        $orderStatus= [
//            '-1'=>'取消订单',
//            '0'=>'未支付',
//            '1'=>'发货中',
//            '2'=>'已收货',
//            '3'=>'发货',
//            '4'=>'退货审核中',
//            '5'=>'审核失败',
//            '6'=>'审核成功',
//            '7'=>'审核成功',
//            '8'=>'退款中',
//            '9'=>'退款成功',
//        ];
////        showData($groupOrderUserData);
//        //订单数据
//        $orderData = $orderModel->where(['id'=>$orderId])->find();
//        $expName  = M('express')->where(['id'=>$orderData['exp_id']])->getField('name');
//        $user_address  = M('user_address')->where(['id'=>$orderData['address_id']])->find();
//        $goods  = M('group')->field('title,price,goods_id')->where(['id'=>$orderData['group_id']])->find();
//        $user  = M('user')->where(['id'=>$orderData['user_id']])->find();
//
//        $this->assign('user',$user);
//        $this->assign('goods',$goods);
//        $this->assign('user_address',$user_address);
//        $this->assign('expName',$expName);
//        $this->assign('orderData',$orderData);
//        $this->assign('UserData',$groupOrderUserData);
//        $this->assign('orderStatus',$orderStatus);
//        $this->display();
//    }



    /**
     *   crontab定时任务   扫描团订单状态，根据订单状态，团单过期时间，自动退款
     *                     拼团失败的两种情况处理
     *                     以主团单为线索开始找
     */
    public function groupOrderCrontab()
    {
        //a,此段修改支付超时的子团订单的数据 (子订单下订单后30分钟内未支付，取消订单)
        $payExpTiems = time() - 1800;
        $orderDataOne = M('order')
            ->field("id,group_id")
            ->where(['group_id'=>['neq',0],'pid'=>['neq',0],'is_host'=>['eq',0],'order_status'=>'0','create_time'=>['elt',$payExpTiems]])
            ->select();
        if(count($orderDataOne)){
            $tmpArray['group_status'] = 3;
            $tmpArray['order_status'] = "-1";
            $tmpArray['group_cause'] = "逾期未支付，拼团失败，取消订单,还原库存";
            $trans = M();
            $trans->startTrans();
            $resOne = M('order')->where(['id'=>['in',array_column($orderDataOne,'id')]])->save($tmpArray);
            if($resOne){
                foreach ($orderDataOne as $k => $v){
                    $resTwo[$k] = M('group')->where(['id'=>$v['group_id']])->setInc('goods_num',1);
                }
                if(!in_array(0,$resTwo)){
                    $trans->commit();
                }else{
                    $trans->rollback();
                }
            }else{
                $trans->rollback();
            }
        }


        //b,所有的主团单
        $orderData = M('order')
            ->field("id,order_sn_id,trade_no,create_time,group_id,price_sum,overdue_time,order_status,group_person_num,pay_type,pay_time")
            ->where(['group_id'=>['neq',0],'pid'=>0,'is_host'=>1])    //group_status固定开团中的
            ->select();
        $payExpTime = time() - 1800; //支付过期时间为30分钟
        $successTime = time() - 259140; //成团时间72小时
        foreach ($orderData as $k=>$v){
            if($v['order_status'] == 0 && $v['create_time'] <= $payExpTime ){
                $orderData1[] = $v;     //过期，未支付
            }elseif($v['order_status'] == '1' && $v['group_status'] == 1 &&  $v['pay_time'] <= $successTime  && $v['pay_type'] == 1){
                $orderData2[] = $v;     //过期，wx已支付
                $orderDataA[] = $v;     //不能合并2 3
            }elseif ($v['order_status'] == '1' && $v['group_status'] == 1 &&  $v['pay_time'] <= $successTime  && $v['pay_type'] == 2){
                $orderData3[] = $v;     //过期，支付宝已支付
                $orderDataA[] = $v;
            }
        }

        //b1,逾期未支付的所有主团单，修改数据（主订单下订单后30分钟内未支付，取消订单）
        if(count($orderData1)){
            $tmpArr['group_status'] = 3;
            $tmpArr['order_status'] = "-1";
            $tmpArr['group_cause'] = "逾期未支付，拼团失败，取消订单,还原库存";

            $trans1 = M();
            $trans1->startTrans();
            $res1 = M('order')->where(['id'=>['in',array_column($orderData1,'id')]])->save($tmpArr);
            if($res1){
                foreach ($orderData1 as $k=>$v){
                    $res2[$k] = M('group')->where(['id'=>$v['group_id']])->setInc('goods_num',1);
                }
                if(!in_array(0,$res2)){
                    $trans1->commit();
                }else{
                    $trans1->rollback();
                }
            }else{
                $trans1->rollback();
            }
        }



        //b2,已经支付成功，过期团单，还原库存,修改为退款中，拼团失败
        if(count($orderDataA)){
            foreach ($orderDataA as $k=>$v){
                $childOrderNum = M('order')
                    ->where(['pid'=>$v['id'],'order_status'=>['eq','1'],'group_status'=>['eq',1]])
                    ->count();
                $orderDataA[$k]['group_goods_num'] = (int)$childOrderNum + 1; //所有子团单个数+主团单
            }
            $data=[];
            $data['group_cause']  = "人数不足，拼团失败,取消订单,还原库存，自动退款";
            $data['order_status'] = "8";
            $data['group_status'] = 3;
            $trans2 = M();
            $trans2->startTrans();
            foreach ($orderDataA as $k=>$v){
                //还原库存
                $res3[$k] = M('group')->where(['id'=>$v['group_id']])->setInc('goods_num',$v['group_goods_num']);
                //修改订单数据
                if(!empty($res3) && !in_array(0,$res3)){
                    $res4[$k] = M('order')->where(['id'=>$v['id']])->save($data);//主订单    有些团单可能没子团单 所以$res5可能为0
                    $res5[$k]=1;
                    if($v['group_goods_num'] != 1){
                        $res5[$k] = M('order')->where(['pid'=>$v['id'],'order_status'=>['eq','1'],'group_status'=>['eq',1]])->save($data);//子订单
                    }
                }
            }
            if(!empty($res3) && !empty($res4) && !empty($res5)){
                if(!in_array(0,$res3) && !in_array(0,$res4) && !in_array(0,$res5)){
                    $trans2->commit();
                }else{
                    $trans2->rollback();
                }
            }else{
                $trans2->rollback();
            }
        }


        //c，微信退款
        if(count($orderData2)){
            foreach ($orderData2 as $k=>$v) {
                $childOrder = M('order')
                    ->field("id,order_sn_id,trade_no,price_sum")
                    ->where(['pid'=>$v['id'],'order_status'=>1])
                    ->select();
            }
            $orderDataAll=array_merge($orderData2,$childOrder);

            $Pay = A('Pay');
            foreach($orderDataAll as $k=>$v){
                $wxRes[$v['id']] = $Pay->doRefund($v['trade_no'],$v['price_sum'],$v['price_sum'],$v['order_sn_id']);
            }
            foreach($wxRes as $k=>$v){
                $data2['order_status'] = '9';
                if($v === true){
                    M('order')->where(['id'=>$k])->save($data2);
                }else{
                    file_put_contents( './Uploads/group/wxRefund.txt', date( 'Y-m-d H:i:s',time() ) ."订单号". $k . "<----退款失败-\r\n",FILE_APPEND );
                }
            }
        }


        //d,支付宝退款
        if(count($orderData3)){
            foreach ($orderData3 as $k=>$v) {
                $childOrder11 = M('order')
                    ->field("id,order_sn_id,trade_no,price_sum")
                    ->where(['pid'=>$v['id'],'order_status'=>1])
                    ->select();
            }
            $orderDataAll11=array_merge($orderData3,$childOrder11);

            $Alipay = A('AlipayMobile');
            foreach($orderDataAll11 as $k=>$v){
                $aliRes[$v['id']] = $Alipay->newrefund($v['trade_no'],$v['price_sum']);
            }

            foreach($aliRes as $k=>$v){
                $data3['order_status'] = '9';
                if($v == true){                 //失败时，退款已打印结果
                    M('order')->where(['id'=>$k])->save($data3);
                }
            }
        }


    }


}