<?php

namespace Home\Model;

use Think\Model;

class GroupModel extends Model
{

    /**
     * 获取团购商品详情      商品的图片   商品的详情
     *
     */
    public function getDetail($id)
    {
        $groupDetail = $this->where(['id' => $id])->find();
        $goodsM = M('goods')->field("price_market,send_address")->where(['goods_id'=>$groupDetail['goods_id']])->find();
        $groupDetail['price_market'] =  $goodsM['price_market'];
        $groupDetail['send_address'] =  $goodsM['send_address'];
        $groupDetail['time'] = time();      //前台团活动参与时间用
        return $groupDetail;
    }



    /**
     * 根据订单ID获取团购商品数据
     *
     */
    public function getGroupGoods($orderId)
    {
        $GorupOrder = M('order')->where(['id'=>$orderId])->find();
        if($GorupOrder['is_host'] == 1){
            $buyGroupNum = $GorupOrder['group_person_num'];
            $time =  $GorupOrder['overdue_time'];
        }else{
            $res = M('order')->field("group_person_num,overdue_time")->where(['id'=>$GorupOrder['pid']])->find();
            $buyGroupNum = $res['group_person_num'];
            $time =  $res['overdue_time'];
        }
        $field = "p.id,p.title,p.price,p.title,p.goods_id,p.group_person_num";
        $data = $this
            ->alias('p')
//            ->join("db_goods_images s on p.goods_id=s.goods_id")
            ->where("p.id=".$GorupOrder['group_id'])
            ->field($field)
            ->find();

        $goodsData = M('goods')->field("price_market,p_id")->where(['id'=>$data['goods_id']])->find();
        $data1['price_market'] = $goodsData['price_market'];
        $data1['images'] = M('goods_images')->where(['goods_id'=>$goodsData['p_id']])->getField("pic_url");
        $data1['price_sum'] = $data['price'];
        $data1['title'] = $data['title'];
        $data1['goods_id'] = $data['goods_id'];
        $data1['group_id'] = $data['id'];
        $data1['group_person_num'] = $data['group_person_num'];
        $data1['buy_num'] = $buyGroupNum;
        $data1['overdue_time'] = $time;
        $data1['time'] = time();
        $data1['id'] = $orderId;
        return $data1;

    }

    /**
     * 参团详情
     * 根据订单id获取已参团用户信息
     * $data 二维数组  0为团长信息
     */
    public function getGroupOrderUser($hostGroupOrderId)
    {
        $data = [];

        $hostOrderData = M('order')->where(['id' => $hostGroupOrderId, 'pid' => 0])->find();

        if ($hostOrderData) {
            //团长头像 名称  参团时间
            $filed = "db_user.id,db_user.nick_name,db_user_header.user_header";
            $HostUserData = M("user")
                ->join("db_user_header ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => $_SESSION['user_id']])
                ->field($filed)
                ->find();
            $HostUserData['pay_time'] = $hostOrderData['pay_time'];

            //已付款团成员数据
            $childOrderData = M('order')
                ->where(['pid' => $hostOrderData['id'], 'order_status' => ['egt', 1]])
                ->order('pay_time')
                ->field("user_id,pay_time")
                ->select();

            $userIdArr = array_column($childOrderData, "user_id");
            $childUserData = M("user")
                ->join("LEFT JOIN db_user_header  ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => ['in', $userIdArr]])
                ->field($filed)
                ->select();
            foreach ($childUserData as $k => $v) {
                $childUserData[$k]['pay_time'] = $childOrderData[$k]['pay_time'];
            }
            $data[0] = $HostUserData;
            foreach ($childUserData as $k => $v) {
                $data[$k + 1] = $v;
            }

        }
        return $data;
    }

    /**
     * 根据订单id 获取所有已付款成员信息
     *
     *
     */
    public function getGroupOrderAllUser($orderId)
    {
        $OrderData = M('order')->where(['id' => $orderId])->find();
        if($OrderData){
            if($OrderData["is_host"] != 1){
                $OrderData = M('order')->where(['id' => $OrderData['pid']])->find();
            }
            //团长头像 名称  参团时间
            $filed = "db_user.id,db_user.nick_name,db_user_header.user_header";
            $HostUserData = M("user")
                ->join("LEFT JOIN db_user_header  ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => $OrderData['user_id']])
                ->field($filed)
                ->find();
            $HostUserData['pay_time'] = $OrderData['pay_time'];
            $data[0] = $HostUserData;

            //已付款团成员数据
            $childOrderData = M('order')
                ->where(['pid' => $OrderData['id'], 'order_status' => "1"])
                ->order('pay_time')
                ->field("user_id as id,pay_time")
                ->select();
            if(empty($childOrderData)){
                return $data;
            }
            $userIdArr = array_column($childOrderData, "id");
            $childUserData = M("user")
                ->join("LEFT JOIN db_user_header  ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => ['in', $userIdArr]])
                ->field($filed)
                ->select();

            foreach ($childOrderData as $k => $v) {
                $childOrderData[$k]['nick_name'] = $childUserData[$k]['nick_name'];
                $childOrderData[$k]['user_header'] = $childUserData[$k]['user_header'];
            }
            $data[0] = $HostUserData;
            foreach ($childOrderData as $k => $v) {
                $data[$k + 1] = $v;
            }

//            foreach ($childUserData as $k => $v) {
//                $childUserData[$k]['pay_time'] = $childOrderData[$k]['id'];
//            }
//            $data[0] = $HostUserData;
//            foreach ($childUserData as $k => $v) {
//                $data[$k + 1] = $v;
//            }
            return $data;
        }

    }


    /**
     * 根据订单id 获取过期团单所有已付款成员信息
     *
     *
     */
    public function expGroupOrderAllUser($orderId)
    {
        $OrderData = M('order')->where(['id' => $orderId])->find();
        if($OrderData){
            if($OrderData["is_host"] != 1){
                $OrderData = M('order')->where(['id' => $OrderData['pid']])->find();
            }
            //团长头像 名称  参团时间
            $filed = "db_user.id,db_user.nick_name,db_user_header.user_header";
            $HostUserData = M("user")
                ->join("LEFT JOIN db_user_header  ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => $OrderData['user_id']])
                ->field($filed)
                ->find();
            $HostUserData['pay_time'] = $OrderData['pay_time'];
            $data[0] = $HostUserData;

            //已付款团成员数据
            $childOrderData = M('order')
                ->where(['pid' => $OrderData['id'], 'order_status' => ['in',['8','9']]])
                ->order('pay_time')
                ->field("user_id as id,pay_time")
                ->select();
            if(empty($childOrderData)){
                return $data;
            }
            $userIdArr = array_column($childOrderData, "id");
            $childUserData = M("user")
                ->join("LEFT JOIN db_user_header  ON db_user.id=db_user_header.user_id ")
                ->where(['db_user.id' => ['in', $userIdArr]])
                ->field($filed)
                ->select();

            foreach ($childOrderData as $k => $v) {
                $childOrderData[$k]['nick_name'] = $childUserData[$k]['nick_name'];
                $childOrderData[$k]['user_header'] = $childUserData[$k]['user_header'];
            }
            $data[0] = $HostUserData;
            foreach ($childOrderData as $k => $v) {
                $data[$k + 1] = $v;
            }

//            foreach ($childUserData as $k => $v) {
//                $childUserData[$k]['pay_time'] = $childOrderData[$k]['id'];
//            }
//            $data[0] = $HostUserData;
//            foreach ($childUserData as $k => $v) {
//                $data[$k + 1] = $v;
//            }
            return $data;
        }

    }



    /**
     * 判断该用户能否 开、参团       ---meng
     *   ture   可以参团
     *   false  不可以参团   购买过 或者购买中时不能参加
     *
     *
     */
    public function isJoinGroupOrder()
    {
        $res = M('order')
            ->where(['user_id'=>$_SESSION['user_id'],'group_id'=>$_SESSION['group_id']])
            ->field("order_status,group_status,pid,group_id,user_id,overdue_time")
            ->select();

        if($res){
            //1做团长的   2参加别人团的
            foreach ($res as $k => $v){
                if($v['pid'] == 0){
                    $res11[$k] =$v;
                }else{
                    $res22[$k] =$v;
                }
            }

            //开团 只要有一个团购成功的  不可团
            foreach ($res11 as $k1 =>$v1){
                if($v1['overdue_time'] > time()){
                    $info = 1;    //false  购买中
                }
            }

            //参团
            $hostO = M('order')
                ->where(['id'=>['in',array_column($res22,'pid')]])
                ->field("order_status,group_status,pid,group_id,user_id,overdue_time")
                ->select();

            //参团 只要有一个团购成功的  不可团
            foreach ($hostO as $k2 =>$v2){
                if($v2['group_status'] < 3 ){
                    $info2 = 1;   //false  购买中或者购买成功
                }
            }
//            if(isset($info) || isset($info2)){
            if(isset($info2)){      //参加过别人团的不能再参团，可以开团
                return false;
            }else{
                return true;
            }
        }else{
            return true;
        }

    }

    /**
     * 优先显示支付最早的订单       ---meng
     * 最后一个子订单未付款状态的不能显示
     */
    public function showOrder($groupId){
        //随机产生一个订单id，
        $personNum = $this->where(['id'=>$groupId])->getField("group_person_num");
        $orderHost = M('order')
            ->field("id,user_id,group_person_num")
            ->where(['group_id'=>$groupId,'pid'=>['eq',0],'group_status'=>1])
            ->order('pay_time')
            ->limit(10)
            ->select();
        if(empty($orderHost)){
            return null;
        }
        //去除拼购即将成功的订单
        foreach ($orderHost as $k=>$v) {
            if ($personNum - $v['group_person_num'] == 1) {
                $orderChild = M('order')
                    ->field("id,order_status")
                    ->where(['pid' => $v['id'], 'order_status' => ['eq', "0"]])
                    ->select();
                if (!empty($orderChild)){
                    unset($k);
                    unset($v);
                }
            }
        }

        foreach ($orderHost as $k=>$v){
            $quickJoin[] = M('order')
                ->alias('r')
                ->join('db_group as p ON r.group_id=p.id')
                ->field("r.id,r.user_id,r.group_id,r.group_person_num as join_person,p.goods_id,p.group_person_num")
                ->where(['r.id'=>$v['id']])
                ->order('r.pay_time')
                ->find();
        }
        foreach ($quickJoin as $k=>&$v){
            $v['nick_name']  =  M('user')->where(['id'=>$v['user_id']])->getField('nick_name');
            $v['pic_url'] = M('goods')
                ->alias('g')
                ->join('db_goods_images as i ON g.p_id=i.goods_id')
                ->where(['g.id'=>$v['goods_id']])
                ->getField('i.pic_url');
            $v['lack_person']=$v['group_person_num']-$v['join_person'];
        }
        return $quickJoin;
    }
    /**
     * 开团限制    交易未结束不能开团 包括：
     *               1,团未结束(未付款和拼团中)
     *              // 2，参加别人团未结束的

     */
    public function startGruopLimit($groupId){
        $res = M('order')
            ->field("id,pid,order_status,group_status,order_status")
            ->where(['group_id'=>$groupId,'user_id'=> $_SESSION['user_id']])
            ->select();
        foreach ($res as $key=>$val){
            if($val['group_status'] == 1 || $val['group_status'] == null || $val['order_status'] == "0"){
                return  false;
            }
        }
//        foreach ($res as $k=>$v){
//            if($v['pid']!=0){
//                $orderIdArr[]= $v['pid'];
//            }
//        }
//        $res1 = M('order')
//            ->field("id,pid,order_status,group_status")
//            ->where(['group_id'=>$groupId,'id'=>['in',$orderIdArr],'group_status'=>['eq',1]])
//            ->select();
//        if($res1){
//             return  false;
//        }
        return true;
    }


}