<?php

namespace Home\Model;

use Think\Model;

class OrderModel extends Model
{
    /**
     * 支付成功根据订单id  修改主团单状态及团单状态和开团人数
     *
     *
     */
    public function updatePersonAndStatus($orderId)
    {
        $isGroupRes = $this->field("is_host,pid")->where( [ 'id' => $orderId ] )->find();
        $hostOrderData = $this->field("id,group_id,group_person_num,overdue_time,group_status")->where( [ 'id' => $isGroupRes['pid'] ] )->find();
        if(empty($isGroupRes['is_host'])){      //参团单
            $group_person_num = M('group')->where( [ 'id' => $hostOrderData['group_id'] ] )->getField('group_person_num');
            $data=[];
            if(($group_person_num-$hostOrderData['group_person_num']) == 1 ){     //拼购人数凑齐，拼团成功
                $data['group_person_num'] = $hostOrderData['group_person_num']+1;   //['exp','group_person_num + 1']
                $data['group_status'] = 2;

                //修改主团单团状态，购买人数
                $res = $this->where( [ 'id' => $hostOrderData['id'] ] )->save($data);

                //修改所有子团单的团状态
                $childOidArr = $this->field('id')->where(['pid'=>$hostOrderData['id'] ,'order_status'=>'1'])->select();
                $data['overdue_time'] = $hostOrderData['overdue_time'];
                $res1 = $this->where( [ 'id' => ['in', array_column($childOidArr,'id')] ] )->save($data);

                //修改团活动表已购买人数
                M('group')->where([ 'id' => $hostOrderData['group_id'] ])->setInc('buy_num',$group_person_num);
            }else{   //拼购人数未齐
                $data['group_person_num'] = $hostOrderData['group_person_num']+1;   //['exp','group_person_num + 1']

                //修改主团单购买人数
                $res = $this->where( [ 'id' => $hostOrderData['id'] ] )->save($data);

                //修改本订单数据
                $data['group_status'] = 1;
                $data['overdue_time'] = $hostOrderData['overdue_time'];
                $res1 = $this->where( [ 'id' => $orderId ] )->save($data);
            }

//            $group_person_num = M('group')->where( [ 'id' => $hostOrderData['group_id'] ] )->getField('group_person_num');
//            $data=[];
//            $data['group_person_num'] = $hostOrderData['group_person_num']+1;   //['exp','group_person_num + 1']
//            $data['group_status'] = 1;
//            if(($group_person_num-$hostOrderData['group_person_num']) == 1 ){     //主订单状态修改为拼团成功
//                $data['group_status'] = 2;         //拼团成功$data1['group_status'] = 2;
//            }
//            //修改主团单团状态，购买人数
//            $res = $this->where( [ 'id' => $hostOrderData['id'] ] )->save($data);
//
//            //修改本订单的团状态
//            $data['overdue_time'] = $hostOrderData['overdue_time'];
//            $res1 = $this->where( [ 'id' => $orderId ] )->save($data);
//
//            //拼购人数齐，拼购成功，修改已购买人数，修改子订单拼购成功
//            if( $data['group_status'] == 2){
//                $childOidArr = $this
//                    ->field('id')
//                    ->where(['pid'=>$hostOrderData['id'] ,'order_status'=>'1','id'=>['neq',$orderId]])
//                    ->select();
//                unset($data['overdue_time']);
//                $this->where( [ 'id' => ['in', array_column($childOidArr,'id')] ] )->save($data);
//                M('group')->where([ 'id' => $hostOrderData['group_id'] ])->setInc('buy_num',$group_person_num);
//            }
        }else{                        //开团单
            $data['group_status'] = 1;            //拼团中
            $data['group_person_num'] = 1;
            $data['overdue_time'] = time() + 259140;      //团单有效期（72小时内）
            $res2 = $this->where( [ 'id' => $orderId ] )->save($data);
        }
        return   (!empty($res) && !empty($res1))  || !empty($res2) ? true : false;
    }
    /**
     * 判断团活动是否已过期，过期时间团活动结束后72h 自动取消人数不足的团订单
     * 修改状态为拼团失败 还原团活动库存
     * @返回团购主订单id
     */
    public function expireUpdateOrderStatus($orderData)
    {
        foreach ($orderData as $k=>$v){
            if(!empty($v['group_id']) && $v['pid']==0  && $v['group_status'] == 1){   //团状态为拼团中1的
                $HostData[] = $v;
            }
//            elseif (!empty($v['group_id']) && $v['pid']!=0){
//                $childData[] = $v;
//            }
        }
        if($HostData){    //谁是团长谁修改状态 增加库存  （团员还原时 会超）
            //1 查询用户开的团 团活动是否过期   得到订单id
            $groupHost  = $this
                ->alias('r')
                ->join('db_group as p ON r.group_id=p.id')
                ->where(['r.id'=>['in',array_column($HostData,'id')],'p.end_time'=>['egt',(time()-172800)]])
                ->field("r.id,r.group_person_num,r.group_id")
                ->select();
            //还原库存
            foreach ($groupHost as $k1=>$v1){
                $res[] = M('group')->where(['id'=>$v1['group_id']])->setInc('goods_num',$v1['group_person_num']);
            }
            if(!empty($res)){
                //修改主团单过期 未成功的  拼团状态修改为拼团失败
                $res2[] = $this->where(['id'=>['in',array_column($groupHost,'id')]])->setField('group_status',3);
            }

            if($res && $res2){
                return true;
            }else{
                return implode('-',array_column($groupHost,'id'));
            }
        }

//        if($childData){
//            //2 用户参的团
//            $groupChildOrder = $this->where(['group_id'=>['in',array_column($childData,'pid')]])->select();
//            $groupChildData = $this
//                ->alias('r')
//                ->join('db_group as p ON r.group_id=p.id')
//                ->where(['r.id'=>['in',array_column($groupChildOrder,'id')],'p.end_time'=>['egt',(time()-172800)]])
//                ->field("r.id,r.group_person_num,r.group_id")
//                ->select();
//            $this->where(['id'=>['in',array_column($groupChildData,'id')]])->setField('group_status',3);
//            //还原库存
//            foreach ($groupChildData as $k2=>$v2){
//                M('group')->where(['id'=>$v2['group_id']])->setInc('goods_num',$v2['group_person_num']);
//            }
//        }
    }
    /**
     * 我的团购订单购商品数据
     *
     */
    public function getMyGroupGoods($orderGroupData)
    {
       foreach ($orderGroupData as $k=>$v){
           $groupData = M('group')->field("title,price,goods_num,group_person_num,goods_id")->where(['id'=>$v['group_id']])->find();
           $groupData['pay_id'] = M('pay_order')->where(['order_id_str'=>(int)$v['id']])->getField('id');
           $goodsPid = M('goods')->where(['id'=>$groupData['goods_id']])->getField('p_id');
           $groupData['img'] = M('goods_images')->where(['goods_id'=>$goodsPid])->getField('pic_url');
           $tmpArr[$k] = array_merge($v,$groupData);
       }
       return $tmpArr;


//       foreach ($tmpArr as $k1=>$v1){
//           $groupDataTmp['img'] = M('goods_images')->where(['goods_id'=>$v1['goods_id']])->getField('pic_url');
//           $tmpArr1[$k1] = array_merge($v,$groupDataTmp);
//       }


//        $groupDataTmp['img'] = M('goods_images')
//            ->where(['goods_id'=>['in',array_column($groupData,'goods_id')]])
//            ->getField('pic_url');
//
//
//       $groupData = M('group')
//                   ->where(['id'=>['in',array_column($orderGroupData,'group_id')]])
//                   ->select();
//       foreach ($groupData as $k => $v){
//           $groupDataTmp['img'] = M('goods_images')
//                               ->where(['goods_id'=>$v['goods_id']])
//                               ->getField('pic_url');
//
//           $groupDataTmp['lack_person'] = $v['group_person_num'] - $orderGroupData[$k]['group_person_num'];
//           $groupDataTmp['order_id'] = $orderGroupData[$k]['order_id'];
//           $groupDataTmp['order_status'] = $orderGroupData[$k]['order_status'];
//           $groupDataTmp['group_status'] = $orderGroupData[$k]['group_status'];
//           $groupDataArr[] = array_merge($v,$groupDataTmp);
//       }
//        return $groupDataArr;
    }
    /**
     * 我的团购订单商品详情
     *
     */
    public function myGroupOrderDetails($orderId)
    {
        $orderData = $this
                    ->where(['id'=>$orderId])
                    ->find();
        if($orderData['pid'] == 0){
            //我是团长时，根据订单状态，团单状态        返回团单状态把
           $data['order_status'] = $orderData['order_status'];
           $data['group_status'] = $orderData['group_status'];
        }else{
           $res = $this
                ->where(['id'=>$orderData['pid']])
                ->find();
           $data['order_status'] = $res['order_status'];
           $data['group_status'] = $res['group_status'];
        }
        return $data;
    }
    /**
     * 根据团购活动id 构造订单详情表需要数据
     *
     */
    public function orderGoodsSmall($groupId)
    {
        $groupData = M('group')
            ->where(['id'=>$groupId])
            ->find();
        $data['goods_id']= $groupData['goods_id'];
        $data['goods_num']= 1;
        $data['goods_price']= $groupData['price'];
        $data['space_id']=  M('spec_goods_price')->where(array('goods_id' =>$groupData['goods_id']))->getField('id');
        return $data;
    }

    /**
     * pc端 后台团购订单详情页面
     * 根据订单id获取已参团用户信息     ---meng
     * $data 二维数组  0为团长信息
     */
    public function getGroupOrderUser($OrderId)
    {
        $data = [];
        //主团单数据
        $OrderData = $this->where(['id' => $OrderId])->find();

        if ($OrderData['is_host'] == 1) {
            //团成员数据
            $childOrderData = $this
                ->where(['pid' => $OrderData['id']])
                ->order('pay_time')
                ->field("id,order_sn_id,user_id,pay_time,order_status,pay_time")
                ->select();
            $data[0] = $OrderData;
            foreach ($childOrderData as $k => $v) {
                $data[$k + 1] = $v;
            }

        }else{   //不是团长，查询团长及其他成员
            $host = $this
                ->where(['id' => $OrderData['pid']])
                ->field("id,order_sn_id,user_id,pay_time,order_status,group_status,is_host,group_person_num,overdue_time")
                ->find();

            //团成员数据
            $childOrderData = M('order')
                ->where(['pid' => $host['id']])
                ->order('pay_time')
                ->field("id,order_sn_id,user_id,pay_time,order_status,group_status,is_host")
                ->select();
            $data[0] = $host;
            foreach ($childOrderData as $k => $v) {
                $data[$k + 1] = $v;
            }
        }
        return $data;
    }


}