<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 14-8-23
 * Time: 下午4:56
 */
Class ApnsUtils
{

    static function validatePayloadLength($locKey, $locArgs, $message, $actionLocKey, $launchImage, $badge, $sound, $payload,$contentAvailable)
    {
        $json = ApnsUtils :: processPayload($locKey, $locArgs, $message, $actionLocKey, $launchImage, $badge, $sound, $payload,$contentAvailable);
        return strlen($json);
    }

    static function processPayload($locKey, $locArgs, $message, $actionLocKey, $launchImage, $badge, $sound, $payload, $contentAvailable)
    {
        $isValid = false;
        $pb = new Payload();
        if ($locKey != null && strlen($locKey) > 0) {
            // loc-key
            $pb->setAlertLocKey($locKey);
            // loc-args
            if ($locArgs != null && strlen($locArgs) > 0) {
                $pb->setAlertLocArgs(explode(',',$locArgs));
            }
            $isValid = true;
        }

        // body
        if ($message != null && strlen($message) > 0) {
            $pb->setAlertBody($message);
            $isValid = true;
        }

        // action-loc-key
        if ($actionLocKey!=null && strlen($actionLocKey) > 0) {
            $pb->setAlertActionLocKey($actionLocKey);
        }

        // launch-image
        if ($launchImage!=null && strlen($launchImage) > 0) {
            $pb->setAlertLaunchImage($launchImage);
        }

        // badge
        $badgeNum = -1;
        if(is_numeric($badge)){
            $badgeNum = (int)$badge;
        }
        if ($badgeNum >= 0) {
            $pb->setBadge($badgeNum);
            $isValid = true;
        }

        // sound
        if ($sound != null && strlen($sound) > 0) {
            $pb->setSound($sound);
        } else {
            $pb->setSound("default");
        }

        //contentAvailable
        if ($contentAvailable == 1) {
            $pb->setContentAvailable(1);
            $isValid = true;
        }

        // payload
        if ($payload != null && strlen($payload) > 0) {
            $pb->addParam("payload", $payload);
        }

        if($isValid == false){
            throw new Exception("one of the params(locKey,message,badge) must not be null or contentAvailable must be 1");
        }
        $json = $pb->toString();
        if($json == null){
            throw new Exception("payload json is null");
        }
        return $json;
    }
}

Class Payload
{
    var $APS = "aps";
    var $params;
    var $alert;
    var $badge;
    var $sound = "";

    var $alertBody;
    var $alertActionLocKey;
    var $alertLocKey;
    var $alertLocArgs;
    var $alertLaunchImage;
    var $contentAvailable;

    function getParams()
    {
        return $this->params;
    }

    function  setParams($params)
    {
        $this->params = $params;
    }

    function addParam($key, $obj)
    {
        if ($this->params == null) {
            $this->params = array();
        }
        if ($this->APS == strtolower($key)) {
            throw new Exception("the key can't be aps");
        }
        $this->params[$key] = $obj;
    }

    function getAlert()
    {
        return $this->alert;
    }

    function setAlert($alert)
    {
        $this->alert = $alert;
    }

    function getBadge()
    {
        return $this->badge;
    }

    function setBadge($badge)
    {
        $this->badge = $badge;
    }

    function getSound()
    {
        return $this->sound;
    }

    function setSound($sound)
    {
        $this->sound = $sound;
    }

    function getAlertBody()
    {
        return $this->alertBody;
    }

    function setAlertBody($alertBody)
    {
        $this->alertBody = $alertBody;
    }

    function getAlertActionLocKey()
    {
        return $this->alertActionLocKey;
    }

    function setAlertActionLocKey($alertActionLocKey)
    {
        $this->alertActionLocKey = $alertActionLocKey;
    }

    function getAlertLocKey()
    {
        return $this->alertLocKey;
    }

    function  setAlertLocKey($alertLocKey)
    {
        $this->alertLocKey = $alertLocKey;
    }

    function getAlertLaunchImage()
    {
        return $this->alertLaunchImage;
    }

    function setAlertLaunchImage($alertLaunchImage)
    {
        $this->alertLaunchImage = $alertLaunchImage;
    }

    function getAlertLocArgs()
    {
        return $this->alertLocArgs;
    }

    function setAlertLocArgs($alertLocArgs)
    {
        $this->alertLocArgs = $alertLocArgs;
    }

    function getContentAvailable()
    {
        return $this->contentAvailable;
    }

    function setContentAvailable($contentAvailable)
    {
        $this->contentAvailable = $contentAvailable;
    }

    function putIntoJson($key, $value, $obj)
    {
        if ($value != null) {
            $obj[$key] = $value;
        }
        return $obj;
    }

    function toString()
    {
        $object = array();
        $apsObj = array();
        if ($this->getAlert() != null) {
            $apsObj["alert"] = urlencode($this->getAlert());
        } else {
            if ($this->getAlertBody() != null || $this->getAlertLocKey() != null) {
                $alertObj = array();
                $alertObj = $this->putIntoJson("body", urlencode($this->getAlertBody()), $alertObj);
                $alertObj = $this->putIntoJson("action-loc-key", urlencode($this->getAlertActionLocKey()), $alertObj);
                $alertObj = $this->putIntoJson("loc-key", urlencode($this->getAlertLocKey()), $alertObj);
                $alertObj = $this->putIntoJson("launch-image", urlencode($this->getAlertLaunchImage()), $alertObj);
                if ($this->getAlertLocArgs() != null) {
                    $array = array();
                    foreach ($this->getAlertLocArgs() as $str) {
                        array_push($array, urlencode($str));
                    }
                    $alertObj["loc-args"] = $array;
                }
                $apsObj["alert"] = $alertObj;
            }
        }
        if ($this->getBadge() != null) {
            $apsObj["badge"] = $this->getBadge();
        }
        // 判断是否静音
        if ("com.gexin.ios.silence" != ($this->getSound())) {
            $apsObj = $this->putIntoJson("sound", urlencode($this->getSound()), $apsObj);
        }
        if($this->getContentAvailable() == 1){
            $apsObj["content-available"]=1;
        }
        $object[$this->APS] = $apsObj;
        if ($this->getParams() != null) {
            foreach ($this->getParams() as $key => $value) {
                $object[urlencode($key)] = urlencode($value);
            }
        }
        return urldecode(json_encode($object));

    }


}