<?php
/**
 * [UQcms System] Copyright uqcms.com
 * QQ: 2200631718
 * Author: gj.name
 * This is NOT a freeware
*/  class oss_qiniu { private static $timeout = 60; private static $instance; public static function init(){ if (is_null(self::$instance)){ self::$instance = new self(); } return self::$instance; } function __construct($param, $bucket, $host_url = null){ $this->accessKey = $param['accessKey']; $this->secretKey = $param['secretKey']; $this->bucket = $bucket; if(!empty($host_url)){ $this->host_url = $host_url; } $this->expires = 3600; $this->url = 'http://up.qiniu.com'; $this->uc_host = 'http://uc.qbox.me'; $this->rs_host = 'http://rs.qbox.me'; } function upload($srcPath, $dstPath){ $size = filesize($srcPath); if($size <= ((1024*1024)*2)){ $args['scope'] = $this->bucket; $args['deadline'] = time() + $this->expires; $host = $this->getupHosts(); $args['upHosts'] = $host['upHosts']; $b = json_encode($args); $encodedData = $this->base64_urlSafeEncode($b); $upToken = $this->sign($encodedData) . ':' . $encodedData; $mimeBoundary = md5(microtime()); $datas = array(); $fields = array('token'=>$upToken, 'key'=>$dstPath); foreach ($fields as $key => $val) { array_push($datas, '--' . $mimeBoundary); array_push($datas, "Content-Disposition: form-data; name=\"$key\""); array_push($datas, ''); array_push($datas, $val); } $srcPath = realpath($srcPath); array_push($datas, '--' . $mimeBoundary); $name = 'file'; $fileBody = file_get_contents($srcPath); $finalFileName = self::escapeQuotes($dstPath); array_push($datas, "Content-Disposition: form-data; name=\"$name\"; filename=\"$finalFileName\""); array_push($datas, "Content-Type: application/octet-stream"); array_push($datas, ''); array_push($datas, $fileBody); array_push($datas, '--' . $mimeBoundary . '--'); array_push($datas, ''); $body = implode("\r\n", $datas); $headers['Content-Type'] = 'multipart/form-data; boundary='.$mimeBoundary; $header = array(); foreach ($headers as $key => $val) { array_push($header, "$key: $val"); } $result = $this->curl_post($this->url, $body, $header); preg_match('/(?:\{)(.*)(?:\})/i', $result['info'], $match); if($match[1]){ $result_json = '{'.$match[1].'}'; $json_result = json_decode($result_json, true, 512); if(isset($json_result['hash'])){ $data['error'] = '0'; $data['name'] = $dstPath; $data['url'] = 'http://'.$this->host_url.'/'.$dstPath; $data['size'] = $size; return $data; }else{ return array('error'=>1,'msg'=>'QINIU上传失败,原因：'.$json_result['error']); } }else{ return array('error'=>1,'msg'=>'QINIU上传失败,无法提取信息'); } }else{ return array('error'=>1,'msg'=>'QINIU上传的文件过大'); } } function del($dstPath){ $path = '/delete/' . $this->entry($this->bucket, $dstPath); $url = $this->rs_host . $path; $body = ''; $authorization = 'QBox ' . $this->signRequest($url, $body, 'application/x-www-form-urlencoded'); $headers = array('Authorization' => $authorization); $header = array(); foreach ($headers as $key => $val) { array_push($header, "$key: $val"); } $result = $this->curl_post($url, $body, $header); if($result['code'] == '200'){ return true; }else{ return false; } } public function signRequest($urlString, $body, $contentType = null) { $url = parse_url($urlString); $data = ''; if (array_key_exists('path', $url)) { $data = $url['path']; } if (array_key_exists('query', $url)) { $data .= '?' . $url['query']; } $data .= "\n"; if ($body !== null && $contentType === 'application/x-www-form-urlencoded') { $data .= $body; } return $this->sign($data); } function entry($bucket, $key){ $en = $bucket; if (!empty($key)) { $en = $bucket . ':' . $key; } return $this->base64_urlSafeEncode($en); } public function sign($data){ $hmac = hash_hmac('sha1', $data, $this->secretKey, true); return $this->accessKey . ':' . $this->base64_urlSafeEncode($hmac); } function base64_urlSafeEncode($data){ $find = array('+', '/'); $replace = array('-', '_'); return str_replace($find, $replace, base64_encode($data)); } function base64_urlSafeDecode($str){ $find = array('-', '_'); $replace = array('+', '/'); return base64_decode(str_replace($find, $replace, $str)); } private static function escapeQuotes($str){ $find = array("\\", "\""); $replace = array("\\\\", "\\\""); return str_replace($find, $replace, $str); } private function curl_post($url, $body, $header = array()){ $ch = curl_init(); $options = array( CURLOPT_USERAGENT => 'QiniuPHP/7.1.4 (Windows NT/i586) PHP/5.3.28', CURLOPT_RETURNTRANSFER => true, CURLOPT_SSL_VERIFYPEER => false, CURLOPT_SSL_VERIFYHOST => false, CURLOPT_HEADER => true, CURLOPT_NOBODY => false, CURLOPT_CUSTOMREQUEST => 'POST', CURLOPT_URL => $url ); if (!ini_get('safe_mode') && !ini_get('open_basedir')) { $options[CURLOPT_FOLLOWLOCATION] = true; } if (!empty($header)) { $options[CURLOPT_HTTPHEADER] = $header; } curl_setopt($ch, CURLOPT_HTTPHEADER, array('Expect:')); if (!empty($body)) { $options[CURLOPT_POSTFIELDS] = $body; } curl_setopt_array($ch, $options); $result['info'] = curl_exec($ch); $result['code'] = curl_getinfo($ch, CURLINFO_HTTP_CODE); return $result; } function getupHosts(){ $url = $this->uc_host . '/v1/query' . "?ak=".$this->accessKey."&bucket=".$this->bucket; $ret = curl::get($url); $hosts = json_decode($ret, true, 512); $schemeHosts = $hosts['http']; $bucketHosts = array( 'upHosts' => $schemeHosts['up'], 'ioHost' => $schemeHosts['io'], 'deadline' => time() + $hosts['ttl'] ); return $bucketHosts; } static function img_size($w, $h){ if($h == '0'){ return '?imageView2/2/w/'.$w; }elseif($w == '10000'){ return '?imageView2/2/h/'.$h; }elseif($w != '0' && $h != '0'){ return '?imageView2/2/w/'.$w.'/h/'.$h; }else{ return ''; } } }