CREATE TABLE `uq_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `postion` int(10) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `link` varchar(200) DEFAULT NULL,
  `start_time` int(11) DEFAULT '0',
  `end_time` int(11) DEFAULT '0',
  `content` text,
  `images` varchar(100) DEFAULT NULL,
  `color` varchar(20) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `pass` int(1) NOT NULL DEFAULT '1',
  `px` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_ad_postion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `alias` varchar(30) DEFAULT NULL,
  `postion` varchar(100) NOT NULL DEFAULT '0',
  `px` int(10) DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_admin` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(1) NOT NULL DEFAULT '1',
  `username` varchar(120) DEFAULT NULL,
  `password` varchar(120) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `mobile` varchar(12) DEFAULT NULL,
  `power` int(1) DEFAULT '0',
  `rank` int(5) DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0',
  `type` int(5) NOT NULL DEFAULT '0' COMMENT '1.登陆，2.操作',
  `desc` varchar(100) DEFAULT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_admin_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(120) NOT NULL,
  `method` varchar(30) NOT NULL,
  `action` varchar(30) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `px` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_admin_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) DEFAULT '0',
  `pay_type` int(1) DEFAULT '1' COMMENT '支付类型：1.订单，2.充值，3.商户订单',
  `settle_type` int(1) NOT NULL DEFAULT '0' COMMENT '结算类型：1.订单合并结算， 0.单独结算',
  `trade_no` varchar(30) NOT NULL DEFAULT '0' COMMENT '生成的担保交易号',
  `order_no` varchar(30) DEFAULT '0' COMMENT '订单号',
  `pay_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `payment` int(2) NOT NULL DEFAULT '0',
  `pay_status` int(1) DEFAULT '0' COMMENT '1.支付, 0.未支付',
  `pay_time` int(10) DEFAULT '0',
  `ip` varchar(22) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_admin_power` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `desc` varchar(220) DEFAULT NULL,
  `content` text,
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_admin_power_nav` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT '0',
  `code` varchar(30) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_album` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) DEFAULT '0',
  `type` int(2) DEFAULT '0',
  `utype` int(10) NOT NULL DEFAULT '0',
  `url` varchar(200) NOT NULL,
  `size` int(10) DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `up` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_album_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_express` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `alias` varchar(20) DEFAULT NULL,
  `param` varchar(30) DEFAULT NULL,
  `pcon` varchar(220) DEFAULT NULL,
  `width` int(5) NOT NULL DEFAULT '0',
  `height` int(5) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `desc` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` varchar(20) DEFAULT NULL,
  `name` varchar(30) DEFAULT NULL,
  `describe` varchar(200) DEFAULT NULL,
  `content` varchar(200) DEFAULT NULL,
  `app_key` varchar(50) DEFAULT NULL,
  `app_secret` varchar(100) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `alias` varchar(30) DEFAULT NULL,
  `param` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_notice_tpl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(30) NOT NULL DEFAULT '0',
  `type` varchar(15) DEFAULT NULL,
  `type2` varchar(10) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `tpl_id` varchar(50) DEFAULT NULL COMMENT '短信模板ID',
  `param` varchar(200) DEFAULT NULL,
  `param2` varchar(200) DEFAULT NULL,
  `content` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_oss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` varchar(20) DEFAULT NULL,
  `name` varchar(30) DEFAULT NULL,
  `describe` varchar(200) DEFAULT NULL,
  `param` varchar(50) DEFAULT NULL,
  `pcon` varchar(200) DEFAULT NULL,
  `bucket` varchar(30) DEFAULT NULL,
  `host` varchar(100) DEFAULT NULL,
  `https` varchar(5) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_api_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `alias` varchar(50) DEFAULT NULL,
  `fees` decimal(10,2) NOT NULL DEFAULT '0.00',
  `describe` varchar(200) DEFAULT NULL,
  `simg` varchar(50) DEFAULT NULL,
  `param` varchar(50) DEFAULT NULL,
  `config` text,
  `support` varchar(10) DEFAULT NULL,
  `is_default` int(1) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `px` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_api_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` varchar(20) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `describe` varchar(50) DEFAULT NULL,
  `app_key` varchar(50) DEFAULT NULL,
  `app_secret` varchar(50) DEFAULT NULL,
  `sign` varchar(15) DEFAULT NULL COMMENT '短信签名',
  `status` int(1) NOT NULL DEFAULT '0',
  `left_delimiter` varchar(3) DEFAULT NULL,
  `right_delimiter` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_area` (
  `id` int(10) NOT NULL,
  `pid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(30) DEFAULT NULL,
  `level` int(2) NOT NULL DEFAULT '0',
  `letter` varchar(3) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned DEFAULT '0',
  `cid` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `desc` varchar(255) DEFAULT NULL,
  `simg` varchar(200) DEFAULT NULL,
  `content` text,
  `click` int(10) DEFAULT '0',
  `like` int(10) unsigned DEFAULT '0',
  `collect` int(10) DEFAULT '0',
  `from` varchar(100) DEFAULT NULL,
  `is_comment` int(10) NOT NULL DEFAULT '0',
  `is_msg` int(1) DEFAULT '1',
  `px_recommend` int(1) unsigned DEFAULT '0',
  `px_hot` int(1) unsigned DEFAULT '0',
  `px_index` int(1) unsigned DEFAULT '0',
  `status` int(1) unsigned DEFAULT '1',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_article_category` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pcid` int(11) DEFAULT '0',
  `name` varchar(120) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `describe` varchar(255) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_article_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0',
  `uid` int(10) DEFAULT '0',
  `content` varchar(200) DEFAULT NULL,
  `ip` varchar(22) DEFAULT NULL,
  `pass` int(1) DEFAULT '1',
  `addtime` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_cart` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cookie` varchar(35) DEFAULT NULL,
  `uid` int(10) DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `sku_id` varchar(50) DEFAULT '0',
  `buy_num` int(6) unsigned NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_category` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `pcid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `keywords` varchar(200) DEFAULT NULL,
  `describe` varchar(200) DEFAULT NULL,
  `images` varchar(200) DEFAULT NULL,
  `px_hot` int(1) NOT NULL DEFAULT '0',
  `px_index` int(1) NOT NULL DEFAULT '0',
  `px_recommend` int(1) NOT NULL DEFAULT '0',
  `px_asc` int(10) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_category_attr` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级分类ID',
  `cid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品分类CID',
  `name` varchar(100) DEFAULT NULL,
  `module` varchar(100) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_category_com` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `pcid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `status` int(1) DEFAULT '1',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_collect_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_collect_shop` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `spid` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_config` (
  `name` varchar(120) DEFAULT NULL,
  `value` text,
  `remark` varchar(260) DEFAULT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_distribute` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `from_uid` int(10) DEFAULT '0',
  `service_uid` int(10) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(1) NOT NULL DEFAULT '1',
  `service_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '区域收入金额',
  `service_status` int(1) NOT NULL DEFAULT '0' COMMENT '是否开通区域代理',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_distribute_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(1) NOT NULL DEFAULT '1' COMMENT '订单类型，1店铺订单，2会员分成，3区域分成',
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0' COMMENT '店铺的ID',
  `ogid` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `buy_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '购买产品价格',
  `buy_num` int(10) NOT NULL DEFAULT '0' COMMENT '购买数量',
  `commission` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '佣金',
  `commission_rate` int(3) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '结算状态,1. 发起，2.成交，0.失效',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_distribute_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL DEFAULT '0',
  `commission_rate` int(10) NOT NULL DEFAULT '0',
  `total_num` int(10) NOT NULL DEFAULT '0' COMMENT '总共推广数量',
  `total_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '总共支出佣金',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_distribute_rate` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `commission_rate` varchar(5) NOT NULL DEFAULT '0',
  `px` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='分销设置';

CREATE TABLE `uq_distribute_relate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `child_uid` int(10) NOT NULL DEFAULT '0',
  `level` int(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_distribute_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL DEFAULT '0',
  `commission_rate` int(3) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_distribute_settle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `settle_month` int(4) NOT NULL DEFAULT '0' COMMENT '结算月份',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `settle_status` int(1) NOT NULL DEFAULT '0',
  `settle_time` int(10) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_express` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `code` int(10) NOT NULL DEFAULT '0',
  `sender_name` varchar(10) DEFAULT NULL,
  `sender_mobile` varchar(16) DEFAULT NULL,
  `sender_address` varchar(200) DEFAULT NULL,
  `receiver_name` varchar(10) DEFAULT NULL,
  `receiver_mobile` varchar(16) DEFAULT NULL,
  `receiver_address` varchar(200) DEFAULT NULL,
  `pay_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_status` int(1) NOT NULL DEFAULT '0' COMMENT '订单状态：1.发起。2.结束订单',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '1.正常。0.冻结',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned DEFAULT '0',
  `group_cid` int(10) unsigned DEFAULT '0',
  `shop_id` int(10) unsigned DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `desc` varchar(200) DEFAULT NULL,
  `intro` varchar(200) DEFAULT NULL COMMENT '活动描述',
  `brand` int(10) DEFAULT '0',
  `images` varchar(100) DEFAULT NULL,
  `content` longtext,
  `price` decimal(10,2) unsigned DEFAULT '0.00',
  `market_price` decimal(10,2) unsigned DEFAULT '0.00',
  `sku_num` int(3) NOT NULL DEFAULT '0',
  `unit` int(2) unsigned NOT NULL DEFAULT '1',
  `express` int(5) unsigned DEFAULT '0' COMMENT '快递编号',
  `volume` int(10) unsigned DEFAULT '0' COMMENT '售出数量',
  `stock` int(10) unsigned DEFAULT '0' COMMENT '库存',
  `comment` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论数量',
  `px_index` int(1) unsigned DEFAULT '0',
  `px_hot` int(1) unsigned DEFAULT '0',
  `px_recommend` int(1) unsigned DEFAULT '0',
  `collect` int(10) NOT NULL DEFAULT '0' COMMENT '收藏数量',
  `score_good` int(10) NOT NULL DEFAULT '0',
  `score_average` int(10) NOT NULL DEFAULT '0',
  `score_bad` int(10) NOT NULL DEFAULT '0',
  `status` int(1) unsigned DEFAULT '1',
  `addtime` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `unit` (`unit`),
  KEY `cid` (`cid`),
  KEY `group_cid` (`group_cid`),
  KEY `shop_id` (`shop_id`),
  KEY `brand` (`brand`),
  KEY `px_index` (`px_index`),
  KEY `px_hot` (`px_hot`),
  KEY `px_recommend` (`px_recommend`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_goods_attr_index` (
  `gid` int(10) NOT NULL DEFAULT '0',
  `gcid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品分类',
  `attr_id` int(10) unsigned DEFAULT '0',
  KEY `gid` (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `describe` varchar(200) DEFAULT NULL,
  `images` varchar(100) DEFAULT NULL,
  `px` int(10) unsigned DEFAULT '0',
  `status` int(1) unsigned DEFAULT '1',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) DEFAULT '0',
  `oid` int(11) DEFAULT '0',
  `ogid` int(10) NOT NULL DEFAULT '0',
  `content` text,
  `score` int(5) DEFAULT '5',
  `reply` varchar(200) DEFAULT NULL,
  `reply_time` int(10) NOT NULL DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_comment_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '留言ID',
  `images` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_consult` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `cid` int(5) DEFAULT '0',
  `question` varchar(200) DEFAULT NULL,
  `reply` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) DEFAULT '0',
  `replytime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `px` int(5) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL,
  `url` varchar(200) DEFAULT NULL,
  `px` int(10) DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(10) DEFAULT '0',
  `cid` int(10) DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `file` varchar(120) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_sku_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) DEFAULT '0',
  `sku_id` varchar(100) DEFAULT NULL,
  `images` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_goods_sku_index` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(10) NOT NULL DEFAULT '0',
  `value` varchar(100) DEFAULT NULL,
  `name` varchar(1000) DEFAULT NULL,
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `stock` int(10) DEFAULT '0',
  `code` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_keyword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(10) NOT NULL DEFAULT '0',
  `keyword` varchar(100) DEFAULT NULL,
  `view` int(10) NOT NULL DEFAULT '0',
  `hot` int(1) NOT NULL DEFAULT '0',
  `px` int(10) DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `link` varchar(200) NOT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_member` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(1) NOT NULL DEFAULT '1',
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `rand` varchar(10) DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `nick` varchar(200) DEFAULT NULL,
  `sex` int(1) DEFAULT '0',
  `avatar` varchar(200) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `birth` varchar(15) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '账户金额',
  `dis_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '推广佣金',
  `integral` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  `experience` int(10) NOT NULL DEFAULT '0' COMMENT '经验',
  `qq_uid` varchar(100) DEFAULT '0',
  `weibo_uid` varchar(100) DEFAULT '0',
  `wchat_uid` varchar(100) DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `register_ip` varchar(22) DEFAULT '0',
  `refresh_time` int(10) DEFAULT '0',
  `last_login_ip` varchar(22) DEFAULT '0',
  `last_login_time` int(11) DEFAULT '0',
  `addtime` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `sex` (`sex`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_member_address` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `prov` int(10) DEFAULT '0',
  `prov_cn` varchar(50) DEFAULT NULL,
  `city` int(10) DEFAULT '0',
  `city_cn` varchar(50) DEFAULT NULL,
  `dist` int(10) DEFAULT '0',
  `dist_cn` varchar(50) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `is_default` int(1) DEFAULT '0',
  `px` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_member_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `type` int(2) DEFAULT '0' COMMENT '交易的类型',
  `order_no` varchar(30) DEFAULT NULL COMMENT '交易对于的编号',
  `status` int(1) NOT NULL DEFAULT '0',
  `remark` varchar(100) DEFAULT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_member_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `bank_id` int(10) NOT NULL DEFAULT '0',
  `number` varchar(50) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `is_default` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_member_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `integral` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_member_withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `spid` int(10) NOT NULL DEFAULT '0' COMMENT '店铺ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '提现现金',
  `surplus` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '账户剩余',
  `pay_type` varchar(50) DEFAULT NULL,
  `pay_name` varchar(30) DEFAULT NULL,
  `pay_account` varchar(30) NOT NULL,
  `pay_remark` varchar(200) DEFAULT NULL,
  `pay_status` int(1) NOT NULL DEFAULT '0' COMMENT '0.提交，1.通过，2.失败',
  `pay_time` int(10) DEFAULT '0',
  `pay_admin_code` varchar(30) DEFAULT NULL,
  `pay_admin_remark` varchar(200) DEFAULT NULL COMMENT '管理支付备注',
  `refuse_time` int(10) NOT NULL DEFAULT '0',
  `refuse_reason` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` varchar(120) DEFAULT NULL,
  `message` varchar(120) DEFAULT NULL,
  `reply` varchar(120) DEFAULT NULL,
  `status` int(1) DEFAULT '0',
  `addtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_navigate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `link` varchar(200) DEFAULT NULL,
  `px` int(10) DEFAULT NULL,
  `status` int(1) DEFAULT '1',
  `addtime` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT NULL,
  `title` varchar(260) DEFAULT NULL,
  `alias` varchar(30) DEFAULT NULL,
  `content` mediumtext,
  `link` varchar(200) DEFAULT NULL,
  `link_status` int(1) DEFAULT '0',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

CREATE TABLE `uq_news_cats` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `pcid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) DEFAULT NULL,
  `alias` varchar(30) DEFAULT NULL,
  `px` int(10) unsigned DEFAULT '0',
  `status` int(1) unsigned NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_notice` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `type` varchar(20) DEFAULT NULL,
  `tpl_name` varchar(30) DEFAULT NULL COMMENT '模板编号',
  `username` varchar(100) DEFAULT NULL COMMENT '发送账号',
  `content` text COMMENT '发送内容',
  `status` int(1) NOT NULL DEFAULT '0',
  `remark` varchar(200) DEFAULT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_order_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` int(10) NOT NULL DEFAULT '0',
  `bid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(20) DEFAULT NULL,
  `prov` int(6) NOT NULL DEFAULT '0',
  `prov_cn` varchar(20) DEFAULT NULL,
  `city` int(6) NOT NULL DEFAULT '0',
  `city_cn` varchar(20) DEFAULT NULL,
  `dist` int(6) NOT NULL DEFAULT '0',
  `dist_cn` varchar(20) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `arrival_time` int(10) DEFAULT '0',
  `kd_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `kd_code` varchar(10) DEFAULT NULL,
  `kd_number` varchar(50) DEFAULT NULL,
  `kd_mktime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_order_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` int(10) NOT NULL,
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) DEFAULT NULL,
  `gid` varchar(10) NOT NULL,
  `title` varchar(150) DEFAULT NULL,
  `intro` varchar(200) DEFAULT NULL,
  `images` varchar(100) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `market_price` decimal(10,2) DEFAULT '0.00',
  `buy_num` int(10) NOT NULL DEFAULT '0',
  `sku_id` int(10) DEFAULT '0',
  `sku_value` varchar(300) DEFAULT NULL,
  `barcode` varchar(30) DEFAULT NULL,
  `receipt_time` int(10) DEFAULT '0' COMMENT '确认收货时间',
  `comment_time` int(10) NOT NULL DEFAULT '0' COMMENT '评论时间',
  `commission_rate` int(3) NOT NULL DEFAULT '0' COMMENT '分销比例',
  `service_id` varchar(30) NOT NULL DEFAULT '0' COMMENT '退款/退货号',
  `order_status` int(1) unsigned NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL,
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_order_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `shop_id` int(10) NOT NULL,
  `trade_no` varchar(30) DEFAULT NULL COMMENT '支付交易号，只记录',
  `order_no` varchar(30) DEFAULT NULL COMMENT '订单号',
  `otype` int(5) NOT NULL DEFAULT '0' COMMENT '订单类型 0.正常，2.拼单',
  `total_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `express_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `promote_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠了多少钱',
  `other_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `message` varchar(200) DEFAULT NULL,
  `order_status` int(1) NOT NULL DEFAULT '1',
  `position` int(1) NOT NULL DEFAULT '0' COMMENT '下单位置',
  `payment` int(2) NOT NULL DEFAULT '0',
  `pay_time` int(10) DEFAULT '0',
  `deliver_time` int(10) NOT NULL DEFAULT '0',
  `receipt_time` int(10) NOT NULL DEFAULT '0',
  `comment_time` int(10) NOT NULL DEFAULT '0',
  `cancel_reason` varchar(30) DEFAULT NULL COMMENT '取消原因',
  `status` int(1) NOT NULL DEFAULT '1',
  `del_user` int(1) NOT NULL DEFAULT '0',
  `del_shop` int(1) NOT NULL DEFAULT '0',
  `remark` varchar(220) DEFAULT NULL COMMENT '商户订单备注',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `share_id` int(10) NOT NULL DEFAULT '0',
  `share_gid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `order_no` (`order_no`),
  KEY `trade_no` (`trade_no`),
  KEY `order_no_2` (`order_no`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_order_score` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oid` varchar(10) DEFAULT '0',
  `uid` int(10) DEFAULT '0',
  `spid` int(10) DEFAULT '0',
  `goods` int(1) DEFAULT '5',
  `service` int(1) NOT NULL DEFAULT '5',
  `logistics` int(1) DEFAULT '5',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='订单打分记录表';

CREATE TABLE `uq_plug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `desc` varchar(220) DEFAULT NULL,
  `version` varchar(20) DEFAULT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL,
  `gid` int(10) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '拼团人数',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `start_time` int(10) NOT NULL,
  `end_time` int(10) NOT NULL,
  `status` int(1) NOT NULL,
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_group_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `num` int(10) NOT NULL DEFAULT '0',
  `start_time` int(10) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '0发起，1成功，4失败',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_group_relate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `order_id` varchar(30) DEFAULT NULL,
  `pay_status` int(1) NOT NULL DEFAULT '0',
  `main_status` int(1) NOT NULL DEFAULT '0' COMMENT '是否为拼团发起者',
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_group_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `group_id` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `sku_id` int(10) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_reduce` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `start_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  `total_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `reduce_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='满就减';

CREATE TABLE `uq_promote_seckill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀一口价价格',
  `volume` int(10) NOT NULL DEFAULT '0',
  `stock` int(10) NOT NULL DEFAULT '0',
  `start_time` int(10) NOT NULL DEFAULT '10',
  `end_time` int(10) NOT NULL DEFAULT '10',
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_promote_seckill_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `sid` int(10) NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `sku_id` int(10) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `goods_id` int(10) NOT NULL DEFAULT '0',
  `service_id` varchar(30) NOT NULL DEFAULT '30' COMMENT '退款号',
  `reason` int(1) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `remarks` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '1.提交,2.退货,3.确认,4.介入,5.成功,6.失败',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `passtime` int(10) NOT NULL DEFAULT '0',
  `sendtime` int(10) NOT NULL DEFAULT '0',
  `admintime` int(10) NOT NULL DEFAULT '0',
  `oktime` int(10) NOT NULL DEFAULT '0',
  `failtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='退款/退货';

CREATE TABLE `uq_refund_process` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(1) NOT NULL DEFAULT '0',
  `title` varchar(150) DEFAULT NULL,
  `content` text,
  `images` text,
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='退款流程';

CREATE TABLE `uq_shop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(1) DEFAULT '1' COMMENT '店铺类型',
  `uid` int(10) NOT NULL,
  `cid` int(10) DEFAULT '0' COMMENT '店铺分类',
  `name` varchar(50) DEFAULT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `contact` varchar(20) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `prov` int(10) DEFAULT '0',
  `city` int(10) DEFAULT '0',
  `dist` int(10) DEFAULT '0',
  `lng` varchar(50) DEFAULT NULL COMMENT '经度',
  `lat` varchar(50) DEFAULT NULL COMMENT '纬度',
  `qq` varchar(200) DEFAULT NULL,
  `ww` varchar(200) DEFAULT NULL,
  `templates` int(2) DEFAULT NULL,
  `intro` text COMMENT '企业介绍',
  `notice` text COMMENT '企业介绍',
  `main_seller` varchar(200) DEFAULT NULL,
  `auth_status` int(1) NOT NULL DEFAULT '0',
  `ratio` varchar(5) NOT NULL DEFAULT '0' COMMENT '佣金比例',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `collect` int(10) NOT NULL DEFAULT '0' COMMENT '收藏数',
  `click` int(10) DEFAULT '0',
  `exper` int(10) NOT NULL DEFAULT '0' COMMENT '经验值',
  `px_recommend` int(1) NOT NULL DEFAULT '0',
  `px_hot` int(1) NOT NULL DEFAULT '0',
  `act_status` int(1) NOT NULL DEFAULT '0' COMMENT '是否开启促销',
  `status` int(1) DEFAULT '1',
  `addtime` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_shop_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(10) DEFAULT NULL,
  `mobile` varchar(15) DEFAULT NULL,
  `prov` int(11) NOT NULL DEFAULT '0',
  `city` int(11) NOT NULL DEFAULT '0',
  `dist` int(11) NOT NULL DEFAULT '0',
  `address` varchar(200) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `explain` text,
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_auth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) DEFAULT NULL,
  `shop_type` int(11) NOT NULL DEFAULT '0' COMMENT '1.persion,2.company',
  `id_name` varchar(50) DEFAULT NULL,
  `id_type` int(10) DEFAULT NULL,
  `id_code` varchar(50) DEFAULT NULL,
  `id_img_up` varchar(100) DEFAULT NULL,
  `id_img_down` varchar(100) DEFAULT NULL,
  `holder_img` varchar(100) DEFAULT NULL,
  `license_code` varchar(50) DEFAULT NULL,
  `license_range` varchar(255) DEFAULT NULL,
  `license_start_time` int(10) DEFAULT NULL,
  `license_end_time` int(10) DEFAULT NULL,
  `license_long_time` int(1) NOT NULL DEFAULT '0',
  `license_img` varchar(100) DEFAULT NULL,
  `apply_time` int(10) DEFAULT '0',
  `auth_time` int(10) DEFAULT '0',
  `auth_reason` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '0提交，2拒绝，1通过 ',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) NOT NULL DEFAULT '0',
  `order_no` varchar(50) DEFAULT NULL,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '结算总金额',
  `price_income` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '收入金额',
  `price_service` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '平台服务费',
  `price_distribute` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '推广服务费',
  `price_goods` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_express` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_promote` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠费用',
  `receipt_time` int(10) NOT NULL DEFAULT '0' COMMENT '确认收货时间',
  `settle_status` int(1) NOT NULL DEFAULT '0' COMMENT '结算状态',
  `settle_time` int(10) NOT NULL DEFAULT '0' COMMENT '结算时间',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `refund_status` int(1) NOT NULL DEFAULT '0' COMMENT '退款状态',
  `refund_time` int(10) NOT NULL DEFAULT '0' COMMENT '退货时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_design` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) unsigned NOT NULL DEFAULT '0',
  `top_images` varchar(200) DEFAULT NULL,
  `bg_images` varchar(220) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `spid` (`shop_id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_express` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `price` decimal(10,2) NOT NULL,
  `area` text,
  `remark` varchar(200) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_express_eara` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eid` int(10) NOT NULL DEFAULT '0',
  `area` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_score` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) DEFAULT NULL,
  `goods` decimal(5,2) DEFAULT '5.00',
  `goods_score` int(10) NOT NULL DEFAULT '0' COMMENT '总分数',
  `goods_num` int(10) NOT NULL DEFAULT '0' COMMENT '人数',
  `service` decimal(5,2) DEFAULT '5.00',
  `service_score` int(10) NOT NULL DEFAULT '0',
  `service_num` int(10) NOT NULL DEFAULT '0',
  `logistics` decimal(5,2) DEFAULT '5.00',
  `logistics_score` int(10) NOT NULL DEFAULT '0',
  `logistics_num` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_shop_service_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(10) NOT NULL DEFAULT '0',
  `week` int(10) NOT NULL DEFAULT '0',
  `time1` int(10) NOT NULL DEFAULT '0',
  `time2` int(10) NOT NULL DEFAULT '0',
  `time3` int(10) NOT NULL DEFAULT '0',
  `time4` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_type` int(1) NOT NULL DEFAULT '0' COMMENT '订单类型。0出库，1入库',
  `bill_no` varchar(30) DEFAULT NULL COMMENT '自动生成的订单号',
  `out_bill_no` varchar(30) DEFAULT NULL,
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '仓库',
  `seller_type` int(5) NOT NULL DEFAULT '0' COMMENT '售卖类型。0零售，1批发，2最低，3进价',
  `oid` int(10) NOT NULL DEFAULT '0' COMMENT '订单产生',
  `aid` int(10) DEFAULT '0',
  `uid` int(10) NOT NULL DEFAULT '0',
  `total_price` decimal(10,2) NOT NULL,
  `promote_price` decimal(10,2) NOT NULL,
  `other_price` decimal(10,2) NOT NULL,
  `pay_price` decimal(10,2) NOT NULL,
  `pay_status` int(1) NOT NULL DEFAULT '0',
  `pay_time` int(10) NOT NULL DEFAULT '0',
  `pay_pass_aid` int(10) DEFAULT '0',
  `remark` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_bill_pro` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bid` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(150) DEFAULT NULL,
  `procode` varchar(30) DEFAULT NULL,
  `unit` int(5) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `num` int(10) NOT NULL DEFAULT '1',
  `total_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `remark` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(35) DEFAULT NULL,
  `procode` varchar(35) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `unit` int(2) NOT NULL DEFAULT '0',
  `sku` varchar(100) DEFAULT NULL,
  `price_sale` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_wholesale` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price_lower` decimal(10,2) NOT NULL DEFAULT '0.00',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `stock_num` int(10) NOT NULL DEFAULT '0',
  `notice_num` int(10) NOT NULL DEFAULT '0',
  `remark` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(30) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `prov` int(6) NOT NULL DEFAULT '0',
  `prov_cn` varchar(30) DEFAULT NULL,
  `city` int(6) NOT NULL DEFAULT '0',
  `city_cn` varchar(30) DEFAULT NULL,
  `dist` int(6) NOT NULL DEFAULT '0',
  `dist_cn` varchar(30) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_store_num` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(10) NOT NULL DEFAULT '0' COMMENT '库房的ID',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '产品的ID',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '数量',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_stock_unit` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `px` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_theme` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `html` text,
  `end_time` int(10) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE `uq_wchat_auto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_key` varchar(200) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `keyword` varchar(200) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `is_sys` int(1) DEFAULT '0',
  `temp` int(11) DEFAULT '0',
  `addtime` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_wchat_auto_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `describe` varchar(200) DEFAULT NULL,
  `content` text,
  `pic_url` varchar(200) DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `px` int(10) DEFAULT NULL,
  `addtime` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

CREATE TABLE `uq_wchat_menu` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `pcid` int(10) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `event` varchar(100) DEFAULT NULL,
  `click_key` varchar(100) DEFAULT NULL,
  `view_url` varchar(250) DEFAULT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

