// JavaScript Document 
$(function(){
	 $.fn.area = function(options){
		var defaults = {
			'title':'',
			'prov':'0',
			'city':'0',
			'dist':'0'
		}; 
		var settings = $.extend({}, defaults, options);
	  	var prov = [], city = [], dist = [];
		$.ajax({  
			type : "get",  
			url : "index.php?m=ajax&a=get_area",   
			async : false,  
			dataType : 'json',
			success : function(data){
				prov = data.prov;
				city = data.city;
				dist = data.dist;
			}
		});
		
		// 系统后台用
		prov_html =	'<span class="area_nav">选择省/选择市/选择县</span>'+ 
					'<input type="hidden" name="prov" id="prov" value="'+settings.prov+'"/>'+
					'<input type="hidden" name="city" id="city" value="'+settings.city+'"/>'+
					'<input type="hidden" name="dist" id="dist" value="'+settings.dist+'"/>';
		$(".area_box").html(prov_html);
		
		prov_html = '<ul class="areaList area-list">';
		$.each(prov, function(k, v){ 
			prov_html += '<li><a href="javascript:;" data-pid="'+k+'"><span>'+v+'</span></a></li>';
		});
		prov_html += '</ul>';
		$(".area_con").html(prov_html);
		// 初始化操作
		$(document).on('click', 'span.area_nav', function(){ 
			html =	'<div class="area_html">'+
						'<div class="area_name"><a id="backUp" class="addr_back" href="javascript:void(0)" data-level="0" title="返回"><i></i><span>选择地区</span></a></div>'+ 
						'<div class="area_con"></div>'+
					'</div>'; 
			$("span.area_nav").after(html); 
			
			prov_html = '<ul class="areaList area-list" data-bh="0">';
			$.each(prov, function(k, v){ 
				prov_html += '<li><a href="javascript:;" data-pid="'+k+'"><span>'+v+'</span></a></li>';
			});
			prov_html += '</ul>';
			$(".area_con").html(prov_html);
		});
		// 地址 
		$(document).on('click', 'ul.areaList a', function(){
			$this = $(this);
			id = $this.attr('data-pid'); 
			val = $("span",this).html();
			level = $("#backUp").attr('data-level'); 
			$this.parents("ul.areaList").attr('data-key', id).attr('data-val', val); 
			if(level == '0'){
				html = '<ul class="areaList area-list" data-bh="1">';
				$.each(city[id], function(k, v){
					html += '<li><a href="javascript:;" data-pid="'+k+'"><span>'+v+'</span></a></li>';
				});
				html += '</ul>';
				$(".areaList:last").after(html).next().siblings().hide(); 
				$("#backUp").attr('data-level','1'); 
				
			}else if(level == '1'){
				html = '<ul class="areaList area-list" data-bh="2">';
				$.each(dist[id], function(k, v){
					html += '<li><a href="javascript:;" data-pid="'+k+'"><span>'+v+'</span></a></a>';
				});
				html += '</ul>'; 
				$(".areaList:last").after(html).next().siblings().hide(); 
				$("#backUp").attr('data-level','2');
				
			}else if(level == '2'){
				val_html = '';
				// 显示全部 
				$(".areaList").each(function(i,k){
					bh = $(this).attr('data-bh');
					bh_key = $(this).attr('data-key'); 
					bh_val = $(this).attr('data-val'); 
					if(bh == '0'){
						$("#prov").val(bh_key);
					}else if(bh == '1'){
						$("#city").val(bh_key);
					}else if(bh == '2'){
						$("#dist").val(bh_key);
					}
					val_html+=bh_val+'/';
				});
				val_html=val_html.substring(0,val_html.length-1);
				$(".area_nav").html(val_html);
				$(".area_html").remove();
			}
		}); 
		
		$(document).on('click', '.addr_back', function(){
			$this = $(this);
			level_id = $this.attr('data-level');
			if(level_id == '0'){
				$(".area_html").remove();
			}else{
				level_id = parseInt(level_id)-parseInt(1);
				$this.attr('data-level',level_id);
				$(".areaList").eq(level_id).show().siblings().hide();	
			} 
		});  
		
		if(settings.prov != '0' && settings.city != '0' && settings.dist != '0'){ 
			$("span.area_nav").html(settings.title); 
			$("#prov").val(settings.prov); 
			$("#city").val(settings.city); 
			$("#dist").val(settings.dist);
		}
		
		
		
		
		
		
	 
	 }
		
	
	
});
 

 