<?php

namespace app\install\controller;

use think\Controller;
use think\Db;

class Index extends Controller {

    protected function initialize() {
        parent::initialize();
        if (file_exists(ROOT_PATH . 'config' . DIRECTORY_SEPARATOR . 'database.php')) {
            $this->error('已经成功安装了ukcms，若需要重新安装请先删除database.php', ROOT_URL);
        }
        $this->assign('baseUrl', $this->request->baseFile() . '/index/');
    }

    //安装首页
    public function index() {
        return $this->fetch();
    }

    //安装第一步，检测运行所需的环境设置
    public function step1() {
        session('error', false);
        //环境检测
        $env = check_env();
        //目录文件读写检测
        $dirfile = check_dirfile();
        //函数检测
        $func = check_func();

        session('step', 1);

        $this->assign('dirfile', $dirfile);
        $this->assign('env', $env);
        $this->assign('func', $func);
        return $this->fetch();
    }

    /**
     * 第二步
     * @param  array $db 配置信息
     * @param  bool $ifdemo 是否安装演示
     */
    public function step2($db = null, $ifdemo = null) {
        session('error') && $this->error('环境检测没有通过，请调整环境后重试！', url('step1'));
        $step = session('step');
        if ($step != 1 && $step != 2) {
            $this->redirect('step1');
        }
        if (request()->isPost()) {
            //检测数据库配置
            if (!is_array($db) || empty($db[0]) || empty($db[1]) || empty($db[2]) || empty($db[3])) {
                $this->error('请填写完整的数据库配置');
            } else {
                $DB = array();
                list($DB['type'], $DB['hostname'], $DB['database'], $DB['username'], $DB['password'], $DB['hostport'], $DB['prefix']) = $db;
                //存储数据库配置
                session('db_config', $DB);
                session('ifdemo', $ifdemo);

                $dbname = $DB['database'];
                unset($DB['database']);
                $dbc = Db::connect($DB);
                // 检测数据库连接
                try {
                    $dbc->execute('select version()');
                } catch (\Exception $e) {
                    $this->error('数据库连接失败：' . $e->getMessage());
                }
                //创建数据库
                $sql = "CREATE DATABASE IF NOT EXISTS `" . $dbname . "` DEFAULT CHARACTER SET utf8";
                try {
                    $dbc->execute($sql);
                } catch (\Exception $e) {
                    $this->error('创建数据库失败：' . $e->getMessage());
                }
                session('step', 2);
                //跳转到数据库安装页面
                $this->redirect('step3');
            }
        } else {
            return $this->fetch();
        }
    }

    //安装第三步，安装数据表，创建配置文件
    public function step3() {
        $dbconfig = session('db_config');
        if (session('step') != 2 || empty($dbconfig)) {
            $this->redirect('step2');
        }
        echo $this->fetch();
        $db = Db::connect($dbconfig);
        session('step', null);
        session('error', null);
//        session('ifdemo', null);
        //创建数据表
        create_tables($db, $dbconfig['prefix']);
        //创建配置文件
        write_config($dbconfig);
        \think\facade\Cache::clear();
        show_msg('<span><a class=\"am-btn am-btn-primary\" href=\"' . ROOT_URL . 'admin.php\">登录后台</a> <a class=\"am-btn am-btn-primary \" href=\"' . ROOT_URL . 'index.php\">访问首页</a></span><style>#working{display:none}</style>');
    }

}
