<?php

namespace app\admin\controller;


use think\Lang;

class Adminlog extends AdminControl
{
    const EXPORT_SIZE = 5000;
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/zh-cn/adminlog.lang.php');
    }

    /**
     * 日志列表
     *
     */
    public function loglist()
    {
        $condition = array();
        $time1='';
        $time2='';
        if (!empty(input('param.admin_name'))) {
            $condition['admin_name'] = input('param.admin_name');
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition['createtime'] = array('between', array($time1, $time2));
        }
        elseif ($time1) {
            $condition['createtime'] = array('egt', $time1);
        }
        elseif ($time2) {
            $condition['createtime'] = array('elt', $time2);
        }
        $list = db('adminlog')->where($condition)->order('id desc')->paginate(10,false,['query' => request()->param()]);
        $page=$list->render();
        $this->assign('list', $list);
        $this->assign('page', $page);
        $this->setAdminCurItem('loglist');
        return $this->fetch();
    }

    /**
     * 删除日志
     *
     */
    public function list_del()
    {
        $condition = array();
        if (is_numeric(input('param.delago'))) {
            $condition['createtime'] = array('lt', TIMESTAMP - intval(input('param.delago')));
        }
        elseif (input('param.delago') == 'all') {
            $condition = true;
        }
        elseif (is_array($_POST['del_id'])) {
            $condition['id'] = array('in', $_POST['del_id']);
        }
        if (!db('adminlog')->where($condition)->delete()) {
            $this->log(lang('ds_del').lang('admin_log'), 0);
            $this->error(lang('ds_common_del_fail'));
        }
        else {
            $this->log(lang('ds_del').lang('admin_log'), 1);
            $this->success(lang('ds_common_del_succ'));
        }
    }

    /**
     * 导出第一步
     */
    public function export_step1()
    {
        $time1='';
        $time2='';
        $condition = array();
        if (!empty(input('param.admin_name'))) {
            $condition['admin_name'] = input('param.admin_name');
        }
        if (!empty(input('param.time_from'))) {
            $time1 = strtotime(input('param.time_from'));
        }
        if (!empty(input('param.time_to'))) {
            $time2 = strtotime(input('param.time_to'));
            if ($time2 !== false)
                $time2 = $time2 + 86400;
        }
        if ($time1 && $time2) {
            $condition['createtime'] = array('between', array($time1, $time2));
        }
        elseif ($time1) {
            $condition['createtime'] = array('egt', $time1);
        }
        elseif ($time2) {
            $condition['createtime'] = array('elt', $time2);
        }
        if (!is_numeric(input('param.curpage'))) {
            $count = db('adminlog')->where($condition)->count();
            $array = array();
            if ($count > self::EXPORT_SIZE) {    //显示下载链接
                $page = ceil($count / self::EXPORT_SIZE);
                for ($i = 1; $i <= $page; $i++) {
                    $limit1 = ($i - 1) * self::EXPORT_SIZE + 1;
                    $limit2 = $i * self::EXPORT_SIZE > $count ? $count : $i * self::EXPORT_SIZE;
                    $array[$i] = $limit1 . ' ~ ' . $limit2;
                }
                $this->assign('list', $array);
                $this->assign('murl', url('adminlog/list'));
                return $this->fetch('excel');
            }
            else {    //如果数量小，直接下载
                $data = db('adminlog')->where($condition)->order('id desc')->limit(self::EXPORT_SIZE)->select();
                $this->createExcel($data);
            }
        }
        else {    //下载
            $limit1 = (input('param.curpage') - 1) * self::EXPORT_SIZE;
            $limit2 = self::EXPORT_SIZE;
            $data = db('adminlog')->where($condition)->order('id desc')->limit("{$limit1},{$limit2}")->select();
            $this->createExcel($data);
        }
    }

    /**
     * 生成excel
     *
     * @param array $data
     */
    private function createExcel($data = array())
    {
        Lang::load(APP_PATH .'admin/lang/zh-cn/export.php');
        $excel_obj = new \excel\Excel();
        $excel_data = array();
        //设置样式
        $excel_obj->setStyle(array(
                                 'id' => 's_title', 'Font' => array('FontName' => '宋体', 'Size' => '12', 'Bold' => '1')
                             ));
        //header
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_man'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_do'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => lang('admin_log_dotime'));
        $excel_data[0][] = array('styleid' => 's_title', 'data' => 'IP');
        foreach ((array)$data as $k => $v) {
            $tmp = array();
            $tmp[] = array('data' => $v['admin_name']);
            $tmp[] = array('data' => $v['content']);
            $tmp[] = array('data' => date('Y-m-d H:i:s', $v['createtime']));
            $tmp[] = array('data' => $v['ip']);
            $excel_data[] = $tmp;
        }
        $excel_data = $excel_obj->charset($excel_data, CHARSET);
        $excel_obj->addArray($excel_data);
        $excel_obj->addWorksheet($excel_obj->charset(lang('admin_log'), CHARSET));
        $excel_obj->generateXML($excel_obj->charset(lang('admin_log'), CHARSET) . input('param.curpage') . '-' . date('Y-m-d-H', time()));
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'loglist',
                'text' => lang('admin_log'),
                'url' => url('adminlog/loglist')
            )
            );
        return $menu_array;

    }
}