<?php

namespace app\admin\controller;


class Chatlog extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub

        $add_time_to = date("Y-m-d");
        $time_from = array();
        $time_from['7'] = strtotime($add_time_to) - 60 * 60 * 24 * 7;
        $time_from['90'] = strtotime($add_time_to) - 60 * 60 * 24 * 90;
        $add_time_from = date("Y-m-d", $time_from['90']);
        $this->assign('minDate', $add_time_from);//只能查看3个月内数据
        $this->assign('maxDate', $add_time_to);
        $time_add_from = input('param.add_time_from');
        $time_aadd_to = input('param.add_time_to');
        if (empty($time_add_from ) || $time_add_from  < $add_time_from) {//默认显示7天内数据
            $time_from = date("Y-m-d", $time_from['7']);
        }
        if (empty($time_aadd_to) || $time_aadd_to > $add_time_to) {
            $time_to = $add_time_to;
        }
    }

    /**
     * 聊天记录查询
     */
    public function chatlog()
    {
        $model_chat = Model('webchat');
        $f_member = array();//发消息人
        $t_member = array();//收消息人
        $f_name = trim(input('param.f_name'));
        if (!empty($f_name)) {
            $condition = array();
            $condition['member_name'] = $f_name;
            $f_member = $model_chat->getMemberInfo($condition);
            $this->assign('f_member', $f_member);
        }
        $t_name = trim(input('param.t_name'));
        if (!empty($t_name)) {
            $condition = array();
            $condition['member_name'] = $t_name;
            $t_member = $model_chat->getMemberInfo($condition);
            $this->assign('t_member', $t_member);
        }
        if (isset($f_member['member_id']) && isset($t_member['member_id'])) {
            if ($f_member['member_id'] > 0 && $t_member['member_id'] > 0) {//验证账号
                $condition = array();
                $condition['add_time_from'] = trim($time_from);
                $condition['add_time_to'] = trim($time_to);
                $condition['f_id'] = intval($f_member['member_id']);
                $condition['t_id'] = intval($t_member['member_id']);
                $log_list = $model_chat->getLogFromList($condition, 15);
                $log_list = array_reverse($log_list);
                $this->assign('log_list', $log_list);
                $this->assign('show_page', $model_chat->page_info->render());
            }
        }
        $this->setAdminCurItem('chatlog');
        return $this->fetch('index');
    }

    /**
     * 聊天内容查询
     */
    public function msglog()
    {
        if (!empty(input('param.msg'))) {
            $model_chat = Model('webchat');
            $condition = array();
            $add_time_from = strtotime($time_from);
            $add_time_to = strtotime($time_to);
            $condition['add_time'] = array('between', array($add_time_from, $add_time_to));
            $condition['t_msg'] = array('like', '%' . trim(input('param.msg')) . '%');
            $log_list = $model_chat->getLogList($condition, 15);
            $log_list = array_reverse($log_list);
            $this->assign('log_list', $log_list);
            $this->assign('show_page', $model_chat->page_info->render());
        }
        $this->setAdminCurItem('msglog');
        return $this->fetch();
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'chatlog', 'text' => '聊天记录', 'url' => url('Chatlog/chatlog')
            ),
            array(
                'name' => 'msglog', 'text' => '聊天内容', 'url' => url('Chatlog/msglog')
            ),
        );
        return $menu_array;
    }
}