<?php

namespace app\admin\controller;


class Common extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    public function pic_upload()
    {
        if (input('param.form_submit')=='ok') {
            if (!empty($_FILES['_pic']['tmp_name'])) {
                $file_object = request()->file('_pic');
                $base_url = input('param.uploadpath');
                $image_url = BASE_UPLOAD_PATH . DS . $base_url;
                $info = $file_object->validate(['ext' => 'jpg,png,gif'])->move($image_url);
                if ($info) {
                    json_encode(array('status' => 1, 'url' => UPLOAD_SITE_URL . '/' . $base_url . '/' . $info->getFilename()));
                    exit;
                }
                else {
                    json_encode(array('status' => 0, 'msg' => $file_object->getError()));
                    exit;
                }
            }
        }
    }

    /**
     * 图片裁剪
     *
     */
    public function pic_cut()
    {
        if (request()->isPost()) {
            $thumb_width = $_POST['x'];
            $x1 = $_POST["x1"];
            $y1 = $_POST["y1"];
            $x2 = $_POST["x2"];
            $y2 = $_POST["y2"];
            $w = $_POST["w"];
            $h = $_POST["h"];
            $scale = $thumb_width / $w;
            $src = str_ireplace(config('url_domain_root'), ROOT_PATH, $_POST['url']);
            $src = str_replace('..', '', $src);

            $cropped = resize_thumb($src, $src, $w, $h, $x1, $y1, $scale);
            if (is_file($src)) {
                @unlink($src);
            }
            $pathinfo = pathinfo($src);
            exit($pathinfo['basename']);
        }
        $save_file = str_ireplace(config('url_domain_root'), ROOT_PATH, $_POST['url']);
        $_GET['x'] = (intval(input('param.x')) > 50 && input('param.x') < 400) ? input('param.x') : 200;
        $_GET['y'] = (intval(input('param.y')) > 50 && input('param.y') < 400) ? input('param.y') : 200;
        $_GET['resize'] = input('param.resize') == '0' ? '0' : '1';
        $imageinfo=getimagesize($save_file);
        $this->assign('height', $imageinfo[1]);
        $this->assign('width',  $imageinfo[0]);

        return $this->fetch($this->template_dir.'cut');

    }

    /**
     * 查询每月的周数组
     */
    public function getweekofmonthOp(){
        import('function.datehelper');
        $year = $_GET['y'];
        $month = $_GET['m'];
        $week_arr = getMonthWeekArr($year, $month);
        echo json_encode($week_arr);
        die;
    }
    /**
     * AJAX查询品牌
     */
    public function ajax_get_brandOp() {
        $initial = trim($_GET['letter']);
        $keyword = trim($_GET['keyword']);
        $type = trim($_GET['type']);
        if (!in_array($type, array('letter', 'keyword')) || ($type == 'letter' && empty($initial)) || ($type == 'keyword' && empty($keyword))) {
            echo json_encode(array());die();
        }

        // 实例化模型
        $model_type = Model('type');
        $where = array();
        // 验证类型是否关联品牌
        if ($type == 'letter') {
            switch ($initial) {
                case 'all':
                    break;
                case '0-9':
                    $where['brand_initial'] = array('in', array(0,1,2,3,4,5,6,7,8,9));
                    break;
                default:
                    $where['brand_initial'] = $initial;
                    break;
            }
        } else {
            $where['brand_name|brand_initial'] = array('like', '%' . $keyword . '%');
        }
        $brand_array = Model('brand')->getBrandPassedList($where, 'brand_id,brand_name,brand_initial', 0, 'brand_initial asc, brand_sort asc');
        echo json_encode($brand_array);die();
    }
}