<?php

namespace app\admin\controller;


class Delivery extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 物流自提服务站列表
     */
    public function index()
    {
        $model_dp = Model('deliverypoint');
        $where = array();
        if (input('param.search_name') != '') {
            $where['dlyp_truename'] = array('like', '%' . input('param.search_name') . '%');
            $this->assign('search_name', input('param.search_name'));
        }
        if (input('param.sign') == 'verify') {
            $this->assign('sign', 'verify');
            $dp_list = $model_dp->getDeliveryPointWaitVerifyList($where, 10);
            $this->setAdminCurItem('verify');
        }
        else {
            $dp_list = $model_dp->getDeliveryPointList($where, 10);
            $this->setAdminCurItem('index');
        }
        $this->assign('show_page', $model_dp->page_info->render());
        $this->assign('dp_list', $dp_list);

        $this->assign('delivery_state', $model_dp->getDeliveryState());
        return $this->fetch();
    }

    /**
     * 物流自提服务站设置
     */
    public function setting()
    {
        $list_setting = Model('config')->getListConfig();
        $this->assign('list_setting', $list_setting);
        $this->setAdminCurItem('setting');
        return $this->fetch();
    }

    /**
     * 提说站设置保存
     */
    public function save_setting()
    {
        if (!request()->isPost()) {
            $this->error(lang('ds_common_save_fail'));
        }
        $update_array = array();
        $update_array['delivery_isuse'] = intval($_POST['delivery_isuse']);
        $result = Model('config')->updateConfig($update_array);
        $log = '开启';
        if ($result === true) {
            if ($update_array['delivery_isuse'] == 0) {
                $log = '关闭';
                // 删除相关联的收货地址
                Model('address')->delAddress(array('dlyp_id' => array('neq', 0)));
            }
            $this->log($log . '物流自提服务站功能', 1);
            $this->error(lang('ds_common_save_succ'));
        }
        else {
            $this->log($log . '物流自提服务站功能', 0);
            $this->error(lang('ds_common_save_fail'));
        }
    }

    /**
     * 编辑物流自提服务站信息
     */
    public function edit_delivery()
    {
        $dlyp_id = intval(input('param.d_id'));
        if ($dlyp_id <= 0) {
            $this->error(lang('param_error'));
        }
        $dlyp_info = Model('deliverypoint')->getDeliveryPointInfo(array('dlyp_id' => $dlyp_id));
        if (empty($dlyp_info)) {
            $this->error(lang('param_error'));
        }
        $this->assign('dlyp_info', $dlyp_info);
        $this->setAdminCurItem('edit_delivery');
        return $this->fetch();
    }

    /**
     * 编辑保存
     */
    public function save_edit()
    {
        $dlyp_id = intval($_POST['did']);
        if (!request()->isPost() || $dlyp_id <= 0) {
            $this->error(lang('param_error'));
        }
        $where = array('dlyp_id' => $dlyp_id);
        $update = array();
        $update['dlyp_mobile'] = $_POST['dmobile'];
        $update['dlyp_telephony'] = $_POST['dtelephony'];
        $update['dlyp_address_name'] = $_POST['daddressname'];
        $update['dlyp_address'] = $_POST['daddress'];
        if ($_POST['dpasswd'] != '') {
            $update['dlyp_passwd'] = md5($_POST['dpasswd']);
        }
        $update['dlyp_state'] = intval($_POST['dstate']);
        $update['dlyp_fail_reason'] = $_POST['fail_reason'];
        $result = Model('deliverypoint')->editDeliveryPoint($update, $where);
        if ($result) {
            // 删除相关联的收货地址
            Model('address')->delAddress(array('dlyp_id' => $dlyp_id));
            $this->log('编辑物流自提服务站功能，ID：' . $dlyp_id, 1);
            $this->error(lang('ds_common_op_succ'), urlAdmin('delivery', 'index'));
        }
        else {
            $this->log('编辑物流自提服务站功能，ID：' . $dlyp_id, 0);
            $this->error(lang('ds_common_op_fail'));
        }
    }

    /**
     * 订单列表
     */
    public function order_list()
    {
        $dlyp_id = intval(input('param.d_id'));
        if ($dlyp_id <= 0) {
            $this->error(lang('param_error'));
        }
        $model_do = Model('deliveryorder');
        $where = array();
        $where['dlyp_id'] = $dlyp_id;
        if (input('param.search_name') != '') {
            $where['order_sn|shipping_code'] = array('like', '%' . input('param.search_name') . '%');
            $this->assign('search_name', input('param.search_name'));
        }
        $dorder_list = $model_do->getDeliveryOrderList($where, 10);
        $this->assign('dorder_list', $dorder_list);
        $this->assign('show_page', $model_do->page_info->render());

        $dorder_state = $model_do->getDeliveryOrderState();
        $this->assign('dorder_state', $dorder_state);
        $this->setAdminCurItem('order_list');
        return $this->fetch();
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => '管理', 'url' => url('Delivery/index')
            ), array(
                'name' => 'verify', 'text' => '等待审核', 'url' => url('Delivery/index', 'sign=verify')
            ), array(
                'name' => 'setting', 'text' => '设置', 'url' => url('Delivery/setting')
            ),
        );
        if (request()->action() == 'edit_delivery') {
            $menu_array[] = array('name' => 'edit_delivery', 'text' => '编辑', 'url' => url('Delivery/edit_delivery'));
        }
        if (request()->action() == 'order_list') {
            $menu_array[] = array('name' => 'order_list', 'text' => '编辑', 'url' => url('Delivery/order_list'));
        }
        return $menu_array;
    }
}