<?php
/**
 * 会员协议管理
 */

namespace app\admin\controller;


use think\Lang;
use think\Validate;

class Document extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/zh-cn/document.lang.php');
    }

    /**
     * 系统文章管理首页
     */
    public function index()
    {
        $model_doc = Model('document');
        $doc_list = $model_doc->getList();
        $this->assign('doc_list', $doc_list);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 系统文章编辑
     */
    public function edit()
    {
        if (request()->isPost()) {
            /**
             * 验证
             */
            $obj_validate = new Validate();
            $data=[
                'doc_title'=>$_POST["doc_title"],
                'doc_content'=>$_POST["doc_content"],
            ];
            $rule=[
                ['doc_title','require',lang('document_index_title_null')],
                ['doc_content','require',lang('document_index_content_null')]
            ];
            
            $error = $obj_validate->check($data,$rule);
            if (!$error) {
                $this->error($obj_validate->getError());
            }
            else {

                $param = array();
                $param['doc_id'] = intval($_POST['doc_id']);
                $param['doc_title'] = trim($_POST['doc_title']);
                $param['doc_content'] = trim($_POST['doc_content']);
                $param['doc_time'] = time();
                $model_doc = Model('document');

                $result = $model_doc->update($param);

                if ($result) {
                    /**
                     * 更新图片信息ID
                     */
                    $model_upload = Model('upload');
                    if (isset($_POST['file_id'])&&is_array($_POST['file_id'])) {
                        foreach ($_POST['file_id'] as $k => $v) {
                            $v = intval($v);
                            $update_array = array();
                            $update_array['upload_id'] = $v;
                            $update_array['item_id'] = intval($_POST['doc_id']);
                            $model_upload->update($update_array);
                            unset($update_array);
                        }
                    }
                    
                    $this->log(lang('ds_edit').lang('document_index_document') . '[ID:' . $_POST['doc_id'] . ']', 1);
                    $this->success(lang('ds_common_save_succ'),'document/index');
                }
                else {
                    $this->error(lang('ds_common_save_fail'));
                }
            }
        }

        if (empty(input('param.doc_id'))) {
            $this->error(lang('miss_argument'));
        }
        $model_doc = Model('document');
        $doc = $model_doc->getOneById(intval(input('param.doc_id')));

        /**
         * 模型实例化
         */
        $model_upload = Model('upload');
        $condition['upload_type'] = '4';
        $condition['item_id'] = $doc['doc_id'];
        $file_upload = $model_upload->getUploadList($condition);
        if (is_array($file_upload)) {
            foreach ($file_upload as $k => $v) {
                $file_upload[$k]['upload_path'] = $file_upload[$k]['file_name'];
            }
        }

        $this->assign('PHPSESSID', session_id());
        $this->assign('file_upload', $file_upload);
        $this->assign('doc', $doc);
        $this->setAdminCurItem('edit');
        return $this->fetch();
    }

    /**
     * 系统文章图片上传
     */
    public function document_pic_upload()
    {
        /**
         * 上传图片
         */
        $upload = new UploadFile();
        $upload->set('default_dir', ATTACH_ARTICLE);

        $result = $upload->upfile('fileupload');
        if ($result) {
            $_POST['pic'] = $upload->file_name;
        }
        else {
            echo 'error';
            exit;
        }
        /**
         * 模型实例化
         */
        $model_upload = Model('upload');
        /**
         * 图片数据入库
         */
        $insert_array = array();
        $insert_array['file_name'] = $_POST['pic'];
        $insert_array['upload_type'] = '4';
        $insert_array['file_size'] = $_FILES['fileupload']['size'];
        $insert_array['item_id'] = intval($_POST['item_id']);
        $insert_array['upload_time'] = time();
        $result = $model_upload->add($insert_array);
        if ($result) {
            $data = array();
            $data['file_id'] = $result;
            $data['file_name'] = $_POST['pic'];
            $data['file_path'] = $_POST['pic'];
            /**
             * 整理为json格式
             */
            $output = json_encode($data);
            echo $output;
        }

    }

    /**
     * ajax操作
     */
    public function ajax()
    {
        switch (input('param.branch')) {
            /**
             * 删除文章图片
             */
            case 'del_file_upload':
                if (intval(input('param.file_id')) > 0) {
                    $model_upload = Model('upload');
                    /**
                     * 删除图片
                     */
                    $file_array = $model_upload->getOneUpload(intval(input('param.file_id')));
                    @unlink(BASE_UPLOAD_PATH . DS . ATTACH_ARTICLE . DS . $file_array['file_name']);
                    /**
                     * 删除信息
                     */
                    $model_upload->del(intval(input('param.file_id')));
                    echo 'true';
                    exit;
                }
                else {
                    echo 'false';
                    exit;
                }
                break;
        }
    }

    /**
     * 获取卖家栏目列表,针对控制器下的栏目
     */
    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => '管理', 'url' => url('Admin/Document/index')
            ),
        );
        if(request()->action()=='edit')
        $menu_array[] = array(
            'name' => 'edit', 'text' => '编辑', 'url' => url('Admin/Document/edit')
        );
        return $menu_array;
    }
}