<?php

namespace app\admin\controller;


use think\Lang;

class Evaluate extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'admin/lang/zh-cn/evaluate.lang.php');
    }

    /**
     * 商品来自买家的评价列表
     */
    public function evalgoods_list() {
        $model_evaluate_goods = Model('evaluategoods');

        $condition = array();
        //商品名称
        if (!empty(input('param.goods_name'))) {
            $condition['geval_goodsname'] = array('like', '%'.input('param.goods_name').'%');
        }
        //店铺名称
        if (!empty(input('param.store_name'))) {
            $condition['geval_storename'] = array('like', '%'.input('param.store_name').'%');
        }
        $stime=strtotime(input('param.stime'));
        $etime=strtotime(input('param.etime'));
        $condition['geval_addtime'] = array('between time',array($stime,$etime));
        //halt($condition);
        $evalgoods_list	= $model_evaluate_goods->getEvaluateGoodsList($condition, 10);

        $this->assign('show_page',$model_evaluate_goods->page_info->render());
        $this->assign('evalgoods_list',$evalgoods_list);
        $this->setAdminCurItem('evalgoods_list');
        return $this->fetch('index');
    }

    /**
     * 删除商品评价
     */
    public function evalgoods_del() {
        $geval_id = intval($_POST['geval_id']);
        if ($geval_id <= 0) {
            $this->error(lang('param_error'));
        }

        $model_evaluate_goods = Model('evaluategoods');

        $result = $model_evaluate_goods->delEvaluateGoods(array('geval_id'=>$geval_id));

        if ($result) {
            $this->log('删除商品评价，评价编号'.$geval_id);
            $this->success(lang('ds_common_del_succ'));
        } else {
            $this->error(lang('ds_common_del_fail'));
        }
    }

    /**
     * 店铺动态评价列表
     */
    public function evalstore_list() {
        $model_evaluate_store = Model('evaluatestore');

        $condition = array();
        //评价人
        if (!empty(input('param.from_name'))) {
            $condition['seval_membername'] = array('like', '%'.input('param.from_name').'%');
        }
        //店铺名称
        if (!empty(input('param.store_name'))) {
            $condition['seval_storename'] = array('like', '%'.input('param.store_name').'%');
        }
        $condition['seval_addtime'] = array('between time', array(strtotime(input('param.stime')), strtotime(input('param.etime'))));

        $evalstore_list	= $model_evaluate_store->getEvaluateStoreList($condition, 10);
        $this->assign('show_page',$model_evaluate_store->page_info->render());
        $this->assign('evalstore_list',$evalstore_list);
        $this->setAdminCurItem('evalstore_list');
        return $this->fetch();
    }

    /**
     * 删除店铺评价
     */
    public function evalstore_del() {
        $seval_id = intval($_POST['seval_id']);
        if ($seval_id <= 0) {
            $this->error(lang('param_error'));
        }

        $model_evaluate_store = Model('evaluatestore');

        $result = $model_evaluate_store->delEvaluateStore(array('seval_id'=>$seval_id));

        if ($result) {
            $this->log('删除店铺评价，评价编号'.$seval_id);
            $this->success(lang('ds_common_del_succ'));
        } else {
            $this->error(lang('ds_common_del_fail'));
        }
    }
    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'evalgoods_list',
                'text' => lang('admin_evaluate_list'),
                'url' => url('Evaluate/evalgoods_list')
            ),
            array(
                'name' => 'evalstore_list',
                'text' => lang('admin_evalstore_list'),
                'url' => url('Evaluate/evalstore_list')
            )
        );
        return $menu_array;
    }
}