<?php

namespace app\admin\controller;


use think\Lang;

class Mbcategorypic extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/zh-cn/mobile.lang.php');
    }

    /**
     *
     */
    public function mb_category_list()
    {
        $model_link = Model('mbcategory');
        /**
         * 删除
         */
        if (request()->isPost()) {
            if (is_array($_POST['del_id']) && !empty($_POST['del_id'])) {
                foreach ($_POST['del_id'] as $k => $v) {
                    /**
                     * 删除图片
                     */
                    $v = intval($v);
                    $tmp = $model_link->getOneLink($v);
                    if (!empty($tmp['gc_thumb'])) {
                        @unlink(BASE_UPLOAD_PATH . DS . ATTACH_MOBILE . '/category/' . $tmp['gc_thumb']);
                    }
                    unset($tmp);
                    $model_link->del($v);
                }
                $this->success(lang('link_index_del_succ'));
            }
            else {
                $this->error(lang('link_index_choose_del'));
            }
        }

        $link_list = $model_link->getLinkList(array());
        /**
         * 整理图片链接
         */
        if (is_array($link_list)) {
            foreach ($link_list as $k => $v) {
                if (!empty($v['gc_thumb'])) {
                    $link_list[$k]['gc_thumb'] = UPLOAD_SITE_URL . '/' . ATTACH_MOBILE . '/category' . '/' . $v['gc_thumb'];
                }
            }
        }

        /**
         * 商品分类
         */
        $goods_class = Model('goodsclass')->getGoodsClassForCacheModel();
        $this->assign('goods_class', $goods_class);
        $this->setAdminCurItem('index');
        $this->setMenuList('mb_category_list');
        $this->assign('link_list', $link_list);
        return $this->fetch('category_list');
    }

    /**
     * 删除
     */
    public function mb_category_del()
    {
        if (intval(input('param.gc_id')) > 0) {
            $model_link = Model('mbcategory');

            /**
             * 删除图片
             */
            $tmp = $model_link->getOneLink(intval(input('param.gc_id')));
            if (!empty($tmp['gc_thumb'])) {
                @unlink(BASE_UPLOAD_PATH . DS . ATTACH_MOBILE . '/category/' . $tmp['gc_thumb']);
            }
            $model_link->del($tmp['gc_id']);
            $this->success(lang('link_index_del_succ'), 'mbcategorypic/mb_category_list');
        }
        else {
            $this->error(lang('link_index_choose_del'));
        }
    }

    /**
     * 添加
     */
    public function mb_category_add()
    {

        $model_link = Model('mbcategory');

        if (request()->isPost()) {
            $category = $model_link->getOneLink(intval($_POST['link_category']));
            if (!empty($category)) {
                $this->error(lang('link_add_category_exist'));
            }

            /**
             * 上传图片
             */
            if ($_FILES['link_pic']['name'] != '') {
                $upload = request()->file('link_pic');
                $file_path= BASE_UPLOAD_PATH .DS.ATTACH_MOBILE . DS .'category';
                $file_name= date('YmdHis') . rand(10000, 99999);
                $result=$upload->validate(['ext'=>'jpg,png,gif,jpeg'])->move($file_path,$file_name);
                if ($result) {
                    $link_pic = $result->getFilename();;
                }
                else {
                    $this->error($upload->getError());
                }
            }

            $insert_array = array();
            $insert_array['gc_id'] = trim($_POST['link_category']);
            $insert_array['gc_thumb'] = trim($link_pic);

            $result = $model_link->addinfo($insert_array);
            if ($result) {
                $this->success(lang('link_add_succ'), 'mbcategorypic/mb_category_list');
            }
            else {
                $this->error(lang('link_add_fail'));
            }
        }

        /**
         * 商品分类
         */
        $goods_class = Model('goodsclass')->getGoodsClassForCacheModel();
        $this->assign('goods_class', $goods_class);
        $this->setAdminCurItem('add');
        return $this->fetch('category_add');
    }

    /**
     * 编辑
     */
    public function mb_category_edit()
    {
        $model_link = Model('mbcategory');
        if (request()->isPost()) {
            $link_pic='';

            /**
             * 上传图片
             */
            if ($_FILES['link_pic']['name'] != '') {
                $upload = request()->file('link_pic');
                $file_path= BASE_UPLOAD_PATH .DS.ATTACH_MOBILE . DS .'category';
                $file_name= date('YmdHis') . rand(10000, 99999);
                $result=$upload->validate(['ext'=>'jpg,png,gif,jpeg'])->move($file_path,$file_name);
                if ($result) {
                    $link_pic = $result->getFilename();;
                }
                else {
                    $this->error($upload->getError());
                }
            }
            $link_array = $model_link->getOneLink(intval($_POST['gc_id']));
            $update_array = array();
            $update_array['gc_id'] = intval($_POST['gc_id']);
            if ($link_pic) {
                $update_array['gc_thumb'] = $link_pic;
            }
            $result = $model_link->update($update_array);
            if ($result) {
                /**
                 * 删除图片
                 */
                if (!empty($link_pic) && !empty($link_array['gc_thumb'])) {
                    @unlink(BASE_UPLOAD_PATH . DS . ATTACH_MOBILE . '/category/' . $link_array['gc_thumb']);
                }
                $this->success(lang('link_edit_succ'), 'mbcategorypic/mb_category_list');
            }
            else {
                $this->error(lang('link_edit_fail'));
            }
        }

        $link_array = $model_link->getOneLink(intval(input('param.gc_id')));
        if (empty($link_array)) {
            $this->error(lang('wrong_argument'));
        }

        /**
         * 商品分类
         */
        $goods_class = Model('goodsclass')->getGoodsClassForCacheModel();
        $this->assign('goods_class', $goods_class);

        $this->assign('link_array', $link_array);
        $this->setAdminCurItem('edit');
        return $this->fetch('category_edit');
    }

    /**
     * ajax操作
     */
    public function ajaxOp()
    {
        switch (input('param.branch')) {
            /**
             * 合作伙伴 排序
             */
            case 'link_sort':
                $model_link = Model('link');
                $update_array = array();
                $update_array['link_id'] = intval(input('param.id'));
                $update_array[input('param.column')] = trim(input('param.value'));
                $result = $model_link->update($update_array);
                echo 'true';
                exit;
                break;
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name'=>'index','text'=>lang('ds_manage'),'url'=>url('Mbcategorypic/mb_category_list')
            ),array(
                'name'=>'add','text'=>lang('ds_new'),'url'=>url('Mbcategorypic/mb_category_add')
            )
        );
        if(request()->action()=='mb_category_edit'){
            $menu_array[]=array(
                'name'=>'edit','text'=>lang('ds_edit'),'url'=>''
            );
        }
        return $menu_array;
    }
}