<?php

namespace app\admin\controller;


class Mbpayment extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    public function payment_list()
    {
        $model_mb_payment = Model('mbpayment');
        $mb_payment_list = $model_mb_payment->getMbPaymentList();
       $this->assign('mb_payment_list', $mb_payment_list);
       $this->setAdminCurItem('index');
       return $this->fetch('list');
    }

    /**
     * 编辑
     */
    public function payment_edit()
    {
        $payment_id = intval(input('param.payment_id'));

        $model_mb_payment = Model('mbpayment');

        $mb_payment_info = $model_mb_payment->getMbPaymentInfo(array('payment_id' => $payment_id));
        //halt($mb_payment_info);
       $this->assign('payment', $mb_payment_info);
       $this->setAdminCurItem('edit');
       return $this->fetch('edit');
    }

    /**
     * 编辑保存
     */
    public function payment_save()
    {
        $payment_id = intval($_POST["payment_id"]);

        $data = array();
        $data['payment_state'] = intval($_POST["payment_state"]);

        switch ($_POST['payment_code']) {
            case 'alipay':
                $payment_config = array(
                    'alipay_appid' => $_POST['alipay_appid'], 'public_key' => $_POST['public_key'],
                    'private_key' => $_POST['private_key']
                );
                break;
            case 'wxpay_app':
                $payment_config = array(
                    'wxpay_appid' => $_POST['wxpay_appid'],
                    'wxpay_partnerid' => $_POST['wxpay_partnerid'],
                    'wxpay_partnerkey' => $_POST['wxpay_partnerkey']
                );
                break;
            case 'wxpay_jsapi':
                $payment_config = array(
                    'appId' => $_POST['appId'], 'appSecret' => $_POST['appSecret'], 'partnerId' => $_POST['partnerId'],
                    'apiKey' => $_POST['apiKey'],
                );
                break;
            case 'alipay_app':
                $payment_config = array(
                    'app_alipay_appid' => $_POST['app_alipay_appid'],
                    'app_public_key' => $_POST['app_public_key'],
                    'app_private_key' => $_POST['app_private_key']
                );
                break;
            default:
                $this->error(lang('param_error'));
        }
        $data['payment_config'] = $payment_config;

        $model_mb_payment = Model('mbpayment');

        $result = $model_mb_payment->editMbPayment($data, array('payment_id' => $payment_id));
        if ($result) {
            $this->success(lang('ds_common_save_succ'), 'mbpayment/payment_list');
        }
        else {
            $this->error(lang('ds_common_save_fail'));
        }
    }
    protected function getAdminItemList()
    {
        $menu=array(
            array(
                'text'=>'列表','name'=>'index','url'=>url('Mbpayment/payment_list')
            ),
        );
        if (request()->action()=='payment_edit'){
            $menu[]=array(
                'name'=>'edit','text'=>lang('ds_edit'),'url'=>''
            );
        }
        return $menu;
    }
}