<?php
/**
 * 显示折扣
 */

namespace app\admin\controller;


use think\Lang;

class Promotionxianshi extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/zh-cn/promotionxianshi.lang.php');
    }


    /**
     * 活动列表
     **/
    public function index()
    {
        //自动开启限时折扣
        if (intval(input('param.promotion_allow')) === 1) {
            $model_setting = Model('setting');
            $update_array = array();
            $update_array['promotion_allow'] = 1;
            $model_setting->updateSetting($update_array);
        }

        $model_xianshi = Model('pxianshi');
        $condition = array();
        if (!empty(input('param.xianshi_name'))) {
            $condition['xianshi_name'] = array('like', '%' . input('param.xianshi_name') . '%');
        }
        if (!empty(input('param.store_name'))) {
            $condition['store_name'] = array('like', '%' . input('param.store_name') . '%');
        }
        if (!empty(input('param.state'))) {
            $condition['state'] = intval(input('param.state'));
        }
        $xianshi_list = $model_xianshi->getXianshiList($condition, 10, 'state desc, end_time desc');
        $this->assign('list', $xianshi_list);
        $this->assign('show_page', $model_xianshi->page_info->render());
        $this->assign('xianshi_state_array', $model_xianshi->getXianshiStateArray());

        $this->setAdminCurItem('xianshi_list');
        // 输出自营店铺IDS
        $this->assign('flippedOwnShopIds', array_flip(model('store')->getOwnShopIds()));
        return $this->fetch();
    }

    /**
     * 限时折扣活动取消
     **/
    public function xianshi_cancel()
    {
        $xianshi_id = intval($_POST['xianshi_id']);
        $model_xianshi = Model('pxianshi');
        $result = $model_xianshi->cancelXianshi(array('xianshi_id' => $xianshi_id));
        if ($result) {
            $this->log('取消限时折扣活动，活动编号' . $xianshi_id);
            $this->error(lang('ds_common_op_succ'));
        }
        else {
            $this->error(lang('ds_common_op_fail'));
        }
    }

    /**
     * 限时折扣活动删除
     **/
    public function xianshi_del()
    {
        $xianshi_id = intval($_POST['xianshi_id']);
        $model_xianshi = Model('pxianshi');
        $result = $model_xianshi->delXianshi(array('xianshi_id' => $xianshi_id));
        if ($result) {
            $this->log('删除限时折扣活动，活动编号' . $xianshi_id);
            $this->error(lang('ds_common_op_succ'));
        }
        else {
            $this->error(lang('ds_common_op_fail'));
        }
    }

    /**
     * 活动详细信息
     **/
    public function xianshi_detail()
    {
        $xianshi_id = intval(input('param.xianshi_id'));

        $model_xianshi = Model('pxianshi');
        $model_xianshi_goods = Model('pxianshigoods');

        $xianshi_info = $model_xianshi->getXianshiInfoByID($xianshi_id);
        if (empty($xianshi_info)) {
            $this->error(lang('param_error'));
        }
        $this->assign('xianshi_info', $xianshi_info);

        //获取限时折扣商品列表
        $condition = array();
        $condition['xianshi_id'] = $xianshi_id;
        $xianshi_goods_list = $model_xianshi_goods->getXianshiGoodsExtendList($condition,5);
        $this->assign('list', $xianshi_goods_list);
        $this->assign('show_page',$model_xianshi_goods->page_info->render());
        $this->setAdminCurItem('xianshi_detail');
        return $this->fetch();
    }

    /**
     * 套餐管理
     **/
    public function xianshi_quota()
    {
        $model_xianshi_quota = Model('pxianshiquota');

        $condition = array();
        $condition['store_name'] = array('like', '%' . input('param.store_name') . '%');
        $list = $model_xianshi_quota->getXianshiQuotaList($condition, 10, 'end_time desc');
        $this->assign('list', $list);
        $this->assign('show_page', $model_xianshi_quota->page_info->render());

        $this->setAdminCurItem('xianshi_quota');
        return $this->fetch();

    }

    /**
     * 设置
     **/
    public function xianshi_setting()
    {

        $model_setting = Model('config');
        $setting = $model_setting->GetListConfig();
        $this->assign('setting', $setting);

        $this->setAdminCurItem('xianshi_setting');
        return $this->fetch();
    }

    public function xianshi_setting_save()
    {

        $promotion_xianshi_price = intval($_POST['promotion_xianshi_price']);
        if ($promotion_xianshi_price === 0) {
            $promotion_xianshi_price = 20;
        }

        $model_setting = Model('config');
        $update_array = array();
        $update_array['promotion_xianshi_price'] = $promotion_xianshi_price;

        $result = $model_setting->updateConfig($update_array);
        if ($result) {
            $this->log('修改限时折扣价格为' . $promotion_xianshi_price . '元');
            $this->error(lang('setting_save_success'));
        }
        else {
            $this->error(lang('setting_save_fail'));
        }
    }

    /**
     * ajax修改抢购信息
     */
    public function ajax()
    {
        $result = true;
        $update_array = array();
        $where_array = array();

        switch (input('param.branch')) {
            case 'recommend':
                $model = Model('pxianshigoods');
                $update_array['xianshi_recommend'] = input('param.value');
                $where_array['xianshi_goods_id'] = input('param.id');
                $result = $model->editXianshiGoods($update_array, $where_array);
                break;
        }

        if ($result) {
            echo 'true';
            exit;
        }
        else {
            echo 'false';
            exit;
        }

    }


    /*
     * 发送消息
     */
    private function send_message($member_id, $member_name, $message)
    {
        $param = array();
        $param['from_member_id'] = 0;
        $param['member_id'] = $member_id;
        $param['to_member_name'] = $member_name;
        $param['message_type'] = '1';//表示为系统消息
        $param['msg_content'] = $message;
        $model_message = Model('message');
        return $model_message->saveMessage($param);
    }

    /**
     * 页面内导航菜单
     *
     * @param string $menu_key 当前导航的menu_key
     * @param array $array 附加菜单
     * @return
     */
    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'xianshi_list', 'text' => lang('xianshi_list'), 'url' => url('promotionxianshi/index')
            ), array(
                'name' => 'xianshi_quota', 'text' => lang('xianshi_quota'),
                'url' => url('promotionxianshi/xianshi_quota')
            ), array(
                'name' => 'xianshi_setting', 'text' => lang('xianshi_setting'),
                'url' => url('promotionxianshi/xianshi_setting')
            ),
        );
        if (request()->action() == 'xianshi_detail')
            $menu_array[] = array(
                'name' => 'xianshi_detail', 'text' => lang('xianshi_detail'),
                'url' => url('promotionxianshi/xianshi_detail')
            );
        return $menu_array;
    }
}